/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.ColumnValue;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.TypeDescriptor;
import org.apache.hive.service.cli.thrift.TColumnValue;
import org.apache.hive.service.cli.thrift.TRow;

public class Row {
    private final List<ColumnValue> values = new ArrayList<ColumnValue>();

    public Row() {
    }

    public Row(TRow tRow) {
        for (TColumnValue tColumnValues : tRow.getColVals()) {
            this.values.add(new ColumnValue(tColumnValues));
        }
    }

    public Row(TableSchema schema, Object[] fields) {
        assert (fields.length == schema.getColumnDescriptors().size());
        for (ColumnDescriptor colDesc : schema.getColumnDescriptors()) {
            TypeDescriptor typeDesc = colDesc.getTypeDescriptor();
            this.values.add(ColumnValue.newColumnValue(typeDesc.getType(), fields[colDesc.getOrdinalPosition() - 1]));
        }
    }

    public Row addColumnValue(ColumnValue value) {
        this.values.add(value);
        return this;
    }

    public Row addBoolean(boolean value) {
        this.values.add(ColumnValue.booleanValue(value));
        return this;
    }

    public Row addByte(byte value) {
        this.values.add(ColumnValue.byteValue(value));
        return this;
    }

    public Row addString(String value) {
        this.values.add(ColumnValue.stringValue(value));
        return this;
    }

    public TRow toTRow() {
        TRow tRow = new TRow();
        for (ColumnValue columnValue : this.values) {
            tRow.addToColVals(columnValue.toTColumnValue());
        }
        return tRow;
    }
}

