/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.auth.PlainSaslServer;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class PlainSaslHelper {
    public static TProcessorFactory getPlainProcessorFactory(ThriftCLIService service) {
        return new SQLPlainProcessorFactory(service);
    }

    public static TTransportFactory getPlainTransportFactory(String authTypeStr) {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        saslFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap(), (CallbackHandler)new PlainServerCallbackHandler());
        return saslFactory;
    }

    public static TTransport getPlainTransport(String userName, String passwd, TTransport underlyingTransport) throws SaslException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainClientbackHandler(userName, passwd), underlyingTransport);
    }

    static {
        Security.addProvider(new PlainSaslServer.SaslPlainProvider());
    }

    private static class SQLPlainProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;

        public SQLPlainProcessorFactory(ThriftCLIService service) {
            super(null);
            this.service = service;
        }

        public TProcessor getProcessor(TTransport trans) {
            return new TCLIService.Processor<ThriftCLIService>(this.service);
        }
    }

    public static class PlainClientbackHandler
    implements CallbackHandler {
        private final String userName;
        private final String passWord;

        public PlainClientbackHandler(String userName, String passWord) {
            this.userName = userName;
            this.passWord = passWord;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Object ac = null;
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callbacks[i];
                    nameCallback.setName(this.userName);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callbacks[i];
                    passCallback.setPassword(this.passWord.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i]);
            }
        }
    }

    private static class PlainServerCallbackHandler
    implements CallbackHandler {
        private PlainServerCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            PlainSaslServer.ExternalAuthenticationCallback ac = null;
            int i = 0;
            if (i < callbacks.length) {
                if (callbacks[i] instanceof PlainSaslServer.ExternalAuthenticationCallback) {
                    ac = (PlainSaslServer.ExternalAuthenticationCallback)callbacks[i];
                } else {
                    throw new UnsupportedCallbackException(callbacks[i]);
                }
            }
            if (ac != null) {
                PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(ac.getAuthMethod());
                provider.Authenticate(ac.getUserName(), ac.getPasswd());
                ac.setAuthenticated(true);
            }
        }
    }
}

