/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIServiceClient;
import org.junit.Assert;
import org.junit.Test;

public class TestScratchDir {
    @Test
    public void testScratchDirs() throws Exception {
        this.stageDirTest("hive.exec.scratchdir", "TestScratchDirs_foobar", false);
    }

    @Test
    public void testLocalScratchDirs() throws Exception {
        this.stageDirTest("hive.exec.local.scratchdir", "TestLocalScratchDirs_foobar", true);
    }

    @Test
    public void testResourceDirs() throws Exception {
        this.stageDirTest("hive.downloaded.resources.dir", "TestResourceDirs_foobar", true);
    }

    private void stageDirTest(String stageDirConfigStr, String stageDirName, boolean isLocal) throws IOException {
        String scratchDirStr = System.getProperty("test.tmp.dir") + File.separator + stageDirName;
        System.setProperty(stageDirConfigStr, scratchDirStr);
        EmbeddedThriftBinaryCLIService service = new EmbeddedThriftBinaryCLIService();
        ThriftCLIServiceClient client = new ThriftCLIServiceClient((TCLIService.Iface)service);
        Path scratchDir = new Path(scratchDirStr);
        Configuration conf = new Configuration();
        FileSystem fs = scratchDir.getFileSystem(conf);
        if (isLocal) {
            fs = FileSystem.getLocal((Configuration)conf);
        }
        Assert.assertTrue((boolean)fs.exists(scratchDir));
        FileStatus[] fStatus = fs.globStatus(scratchDir);
        boolean foo = fStatus[0].equals((Object)new FsPermission(511));
        Assert.assertEquals((Object)new FsPermission(511), (Object)fStatus[0].getPermission());
        service.stop();
        fs.delete(scratchDir, true);
        System.clearProperty(stageDirConfigStr);
    }
}

