/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import java.io.IOException;
import java.net.ServerSocket;
import junit.framework.TestCase;
import org.apache.hadoop.hive.service.HiveClient;
import org.apache.hadoop.hive.service.HiveServer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class TestHiveServerSessions
extends TestCase {
    private static final int clientNum = 2;
    private int port;
    private Thread server;
    private TSocket[] transports = new TSocket[2];
    private HiveClient[] clients = new HiveClient[2];

    public TestHiveServerSessions(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.port = this.findFreePort();
        this.server = new Thread(new Runnable(){

            @Override
            public void run() {
                HiveServer.main((String[])new String[]{"-p", String.valueOf(TestHiveServerSessions.this.port)});
            }
        });
        this.server.start();
        Thread.sleep(5000L);
        for (int i = 0; i < this.transports.length; ++i) {
            TSocket transport = new TSocket("localhost", this.port);
            transport.open();
            this.transports[i] = transport;
            this.clients[i] = new HiveClient((TProtocol)new TBinaryProtocol((TTransport)transport));
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        for (TSocket socket : this.transports) {
            if (socket == null) continue;
            try {
                socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.server != null) {
            this.server.interrupt();
        }
    }

    private int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public void testSessionVars() throws Exception {
        int i;
        for (i = 0; i < this.clients.length; ++i) {
            this.clients[i].execute("set hiveconf:var=value" + i);
        }
        for (i = 0; i < this.clients.length; ++i) {
            this.clients[i].execute("set hiveconf:var");
            TestHiveServerSessions.assertEquals((String)("hiveconf:var=value" + i), (String)this.clients[i].fetchOne());
        }
    }
}

