/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HttpCLIServiceUGIProcessor;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TTransport;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class HttpAuthUtils {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BASIC = "Basic";
    public static final String NEGOTIATE = "Negotiate";

    public static TProcessorFactory getAuthProcFactory(ThriftCLIService service) {
        return new HttpCLIServiceProcessorFactory(service);
    }

    public static String getKerberosServiceTicket(String principal, String host, String serverHttpUrl) throws GSSException, IOException, InterruptedException {
        UserGroupInformation clientUGI = HttpAuthUtils.getClientUGI("kerberos");
        String serverPrincipal = HttpAuthUtils.getServerPrincipal(principal, host);
        return (String)clientUGI.doAs((PrivilegedExceptionAction)new HttpKerberosClientAction(serverPrincipal, clientUGI.getShortUserName(), serverHttpUrl));
    }

    private static String getServerPrincipal(String principal, String host) throws IOException {
        return ShimLoader.getHadoopThriftAuthBridge().getServerPrincipal(principal, host);
    }

    public static UserGroupInformation getClientUGI(String authType) throws IOException {
        return ShimLoader.getHadoopThriftAuthBridge().getCurrentUGIWithConf(authType);
    }

    public static class HttpKerberosClientAction
    implements PrivilegedExceptionAction<String> {
        String serverPrincipal;
        String clientUserName;
        String serverHttpUrl;
        private final Base64 base64codec;
        public static final String HTTP_RESPONSE = "HTTP_RESPONSE";
        public static final String SERVER_HTTP_URL = "SERVER_HTTP_URL";
        private final HttpContext httpContext;

        public HttpKerberosClientAction(String serverPrincipal, String clientUserName, String serverHttpUrl) {
            this.serverPrincipal = serverPrincipal;
            this.clientUserName = clientUserName;
            this.serverHttpUrl = serverHttpUrl;
            this.base64codec = new Base64(0);
            this.httpContext = new BasicHttpContext();
            this.httpContext.setAttribute(SERVER_HTTP_URL, (Object)serverHttpUrl);
        }

        @Override
        public String run() throws Exception {
            Oid mechOid = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager manager = GSSManager.getInstance();
            GSSName clientName = manager.createName(this.clientUserName, GSSName.NT_USER_NAME);
            GSSName serverName = manager.createName(this.serverPrincipal, krb5PrincipalOid);
            GSSCredential clientCreds = manager.createCredential(clientName, 0, mechOid, 1);
            GSSContext gssContext = manager.createContext(serverName, mechOid, clientCreds, 0);
            gssContext.requestMutualAuth(false);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            String authHeaderBase64String = new String(this.base64codec.encode(outToken));
            return authHeaderBase64String;
        }
    }

    public static class HttpCLIServiceProcessorFactory
    extends TProcessorFactory {
        private final ThriftCLIService service;
        private final HiveConf hiveConf;
        private final boolean isDoAsEnabled;

        public HttpCLIServiceProcessorFactory(ThriftCLIService service) {
            super(null);
            this.service = service;
            this.hiveConf = service.getHiveConf();
            this.isDoAsEnabled = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        }

        public TProcessor getProcessor(TTransport trans) {
            TCLIService.Processor<ThriftCLIService> baseProcessor = new TCLIService.Processor<ThriftCLIService>(this.service);
            return this.isDoAsEnabled ? new HttpCLIServiceUGIProcessor(baseProcessor) : baseProcessor;
        }
    }
}

