/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.log;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hive.service.cli.log.LinkedStringBuffer;
import org.apache.log4j.Logger;

public class OperationLog {
    private static final String HIVE_ENCODING = Charsets.UTF_8.name();
    private static Logger LOG = Logger.getLogger((String)OperationLog.class.getName());
    private final String operationLogName;
    private final LinkedStringBuffer operationLogBuffer;
    private final long creationTime;

    OperationLog(String name, int size) {
        this.operationLogName = name;
        this.operationLogBuffer = new LinkedStringBuffer(size);
        this.creationTime = System.currentTimeMillis();
    }

    public void writeOperationLog(String OperationLogMessage) {
        this.operationLogBuffer.write(OperationLogMessage);
    }

    public String readOperationLog() {
        return this.operationLogBuffer.read();
    }

    public void resetOperationLog() {
        this.operationLogBuffer.clear();
    }

    public OutputStream getOutputStream() {
        return new OperationLogOutputStream(this.operationLogBuffer);
    }

    public String getName() {
        return this.operationLogName;
    }

    private static class OperationLogOutputStream
    extends OutputStream {
        private final LinkedStringBuffer backingStore;

        public OperationLogOutputStream(LinkedStringBuffer operationLogBuffer) {
            this.backingStore = operationLogBuffer;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.backingStore.write(new String(b, HIVE_ENCODING));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.backingStore.write(new String(b, off, len, HIVE_ENCODING));
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)b};
            this.write(buf);
        }
    }
}

