/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class MetadataOperation
extends Operation {
    protected static final String DEFAULT_HIVE_CATALOG = "";
    protected static TableSchema RESULT_SET_SCHEMA;
    private static final char SEARCH_STRING_ESCAPE = '\\';

    protected MetadataOperation(HiveSession parentSession, OperationType opType) {
        super(parentSession, opType, false);
        this.setHasResultSet(true);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
    }

    protected String convertIdentifierPattern(String pattern, boolean datanucleusFormat) {
        if (pattern == null) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, datanucleusFormat);
    }

    protected String convertSchemaPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, true);
    }

    private String convertPattern(String pattern, boolean datanucleusFormat) {
        String wStr = datanucleusFormat ? "*" : ".*";
        return pattern.replaceAll("([^\\\\])%", "$1" + wStr).replaceAll("\\\\%", "%").replaceAll("^%", wStr).replaceAll("([^\\\\])_", "$1.").replaceAll("\\\\_", "_").replaceAll("^_", ".");
    }
}

