/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import javax.servlet.Servlet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpServlet;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThriftHttpCLIService
extends ThriftCLIService {
    public ThriftHttpCLIService(CLIService cliService) {
        super(cliService, "ThriftHttpCLIService");
    }

    @Override
    public void run() {
        try {
            ThriftHttpCLIService.verifyHttpConfiguration(this.hiveConf);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_HTTP_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PORT);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_MAX_WORKER_THREADS);
            String httpPath = this.getHttpPath(this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_HTTP_PATH));
            this.httpServer = new Server();
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setMinThreads(this.minWorkerThreads);
            threadPool.setMaxThreads(this.maxWorkerThreads);
            this.httpServer.setThreadPool((ThreadPool)threadPool);
            SelectChannelConnector connector = new SelectChannelConnector();
            boolean useSsl = this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL);
            String schemeName = useSsl ? "https" : "http";
            String authType = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
            UserGroupInformation serviceUGI = this.cliService.getServiceUGI();
            UserGroupInformation httpUGI = this.cliService.getHttpUGI();
            if (useSsl) {
                String keyStorePath = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH).trim();
                String keyStorePassword = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD);
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PATH.varname + " Not configured for SSL connection");
                }
                SslContextFactory sslContextFactory = new SslContextFactory();
                sslContextFactory.setKeyStorePath(keyStorePath);
                sslContextFactory.setKeyStorePassword(keyStorePassword);
                connector = new SslSelectChannelConnector(sslContextFactory);
            }
            connector.setPort(this.portNum);
            connector.setReuseAddress(!Shell.WINDOWS);
            this.httpServer.addConnector((Connector)connector);
            hiveAuthFactory = new HiveAuthFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            TProcessor processor = processorFactory.getProcessor(null);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            ThriftHttpServlet thriftHttpServlet = new ThriftHttpServlet(processor, (TProtocolFactory)protocolFactory, authType, serviceUGI, httpUGI);
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this.httpServer.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)thriftHttpServlet), httpPath);
            this.httpServer.start();
            String msg = "Started ThriftHttpCLIService in " + schemeName + " mode on port " + this.portNum + " path=" + httpPath + " with " + this.minWorkerThreads + ".." + this.maxWorkerThreads + " worker threads";
            LOG.info((Object)msg);
            this.httpServer.join();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error: ", t);
        }
    }

    private String getHttpPath(String httpPath) {
        if (httpPath == null || httpPath.equals("")) {
            httpPath = "/*";
        } else {
            if (!httpPath.startsWith("/")) {
                httpPath = "/" + httpPath;
            }
            if (httpPath.endsWith("/")) {
                httpPath = httpPath + "*";
            }
            if (!httpPath.endsWith("/*")) {
                httpPath = httpPath + "/*";
            }
        }
        return httpPath;
    }

    private static void verifyHttpConfiguration(HiveConf hiveConf) {
        String authType = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.KERBEROS.toString()) && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_USE_SSL)) {
            String msg = HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION + " setting of " + authType + " is not supported with " + HiveConf.ConfVars.HIVE_SERVER2_USE_SSL + " set to true";
            LOG.fatal((Object)msg);
            throw new RuntimeException(msg);
        }
        if (authType.equalsIgnoreCase(HiveAuthFactory.AuthTypes.NONE.toString())) {
            LOG.warn((Object)(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION + " setting to " + authType + ". SASL is not supported with http transport mode," + " so using equivalent of " + (Object)((Object)HiveAuthFactory.AuthTypes.NOSASL)));
        }
    }
}

