/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;

public class SQLOperation
extends ExecuteStatementOperation {
    private Driver driver = null;
    private CommandProcessorResponse response;
    private TableSchema resultSchema = null;
    private Schema mResultSchema = null;
    private SerDe serde = null;
    private final boolean runAsync;
    private Future<?> backgroundHandle;
    private boolean fetchStarted = false;
    private final transient List<Object> convey = new ArrayList<Object>();

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runInBackground) {
        super(parentSession, statement, confOverlay);
        this.runAsync = runInBackground;
    }

    public void prepare(HiveConf sqlOperationConf) throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            this.driver = new Driver(this.getParentSession().getHiveConf(), this.getParentSession().getUserName(), this.getParentSession().getIpAddress());
            this.driver.setTryCount(Integer.MAX_VALUE);
            String subStatement = new VariableSubstitution().substitute(sqlOperationConf, this.statement);
            this.response = this.driver.compileAndRespond(subStatement);
            if (0 != this.response.getResponseCode()) {
                throw new HiveSQLException("Error while compiling statement: " + this.response.getErrorMessage(), this.response.getSQLState(), this.response.getResponseCode());
            }
            this.mResultSchema = this.driver.getSchema();
            if (this.driver.getPlan().getFetchTask() != null) {
                if (this.mResultSchema == null || !this.mResultSchema.isSetFieldSchemas()) {
                    throw new HiveSQLException("Error compiling query: Schema and FieldSchema should be set when query plan has a FetchTask");
                }
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
            } else {
                this.setHasResultSet(false);
            }
            for (Task task : this.driver.getPlan().getRootTasks()) {
                if (task.getClass() != ExplainTask.class) continue;
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
                break;
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
    }

    private void runInternal(HiveConf sqlOperationConf) throws HiveSQLException {
        try {
            this.driver.setTryCount(Integer.MAX_VALUE);
            this.response = this.driver.run();
            if (0 != this.response.getResponseCode()) {
                throw new HiveSQLException("Error while processing statement: " + this.response.getErrorMessage(), this.response.getSQLState(), this.response.getResponseCode());
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.PENDING);
        this.prepare(this.getConfigForOperation());
        if (!this.shouldRunAsync()) {
            this.runInternal(this.getConfigForOperation());
        } else {
            Runnable backgroundOperation = new Runnable(){
                SessionState ss = SessionState.get();

                @Override
                public void run() {
                    SessionState.start((SessionState)this.ss);
                    try {
                        SQLOperation.this.runInternal(SQLOperation.this.getConfigForOperation());
                    }
                    catch (HiveSQLException e) {
                        Operation.LOG.error((Object)"Error: ", (Throwable)e);
                    }
                }
            };
            try {
                this.backgroundHandle = this.getParentSession().getSessionManager().submitBackgroundOperation(backgroundOperation);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState.ERROR);
                throw new HiveSQLException(rejected);
            }
        }
    }

    private void cleanup(OperationState state) throws HiveSQLException {
        SessionState ss;
        this.setState(state);
        if (this.shouldRunAsync() && this.backgroundHandle != null) {
            this.backgroundHandle.cancel(true);
        }
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        if ((ss = SessionState.get()).getTmpOutputFile() != null) {
            ss.getTmpOutputFile().delete();
        }
    }

    @Override
    public void cancel() throws HiveSQLException {
        this.cleanup(OperationState.CANCELED);
    }

    @Override
    public void close() throws HiveSQLException {
        this.cleanup(OperationState.CLOSED);
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        this.assertState(OperationState.FINISHED);
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion());
        try {
            if (orientation.equals((Object)FetchOrientation.FETCH_FIRST) && this.fetchStarted) {
                this.driver.resetFetch();
            }
            this.fetchStarted = true;
            this.driver.setMaxRows((int)maxRows);
            if (this.driver.getResults(this.convey)) {
                RowSet rowSet2 = this.decode(this.convey, rowSet);
                return rowSet2;
            }
            RowSet rowSet3 = rowSet;
            return rowSet3;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (CommandNeedRetryException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
        finally {
            this.convey.clear();
        }
    }

    private RowSet decode(List<Object> rows, RowSet rowSet) throws Exception {
        if (this.driver.isFetchingTable()) {
            return this.prepareFromRow(rows, rowSet);
        }
        return this.decodeFromString(rows, rowSet);
    }

    private RowSet prepareFromRow(List<Object> rows, RowSet rowSet) throws Exception {
        for (Object row : rows) {
            rowSet.addRow((Object[])row);
        }
        return rowSet;
    }

    private RowSet decodeFromString(List<Object> rows, RowSet rowSet) throws SQLException, SerDeException {
        this.getSerDe();
        StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
        List fieldRefs = soi.getAllStructFieldRefs();
        Object[] deserializedFields = new Object[fieldRefs.size()];
        int protocol = this.getProtocolVersion().getValue();
        for (Object rowString : rows) {
            Object rowObj = this.serde.deserialize((Writable)new BytesWritable(((String)rowString).getBytes()));
            for (int i = 0; i < fieldRefs.size(); ++i) {
                StructField fieldRef = (StructField)fieldRefs.get(i);
                ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                Object fieldData = soi.getStructFieldData(rowObj, fieldRef);
                deserializedFields[i] = SerDeUtils.toThriftPayload((Object)fieldData, (ObjectInspector)fieldOI, (int)protocol);
            }
            rowSet.addRow(deserializedFields);
        }
        return rowSet;
    }

    private SerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            List fieldSchemas = this.mResultSchema.getFieldSchemas();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug((Object)("Column names: " + names));
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug((Object)("Column types: " + types));
                props.setProperty("columns.types", types);
            }
            this.serde.initialize((Configuration)new HiveConf(), props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }

    private boolean shouldRunAsync() {
        return this.runAsync;
    }

    private HiveConf getConfigForOperation() throws HiveSQLException {
        HiveConf sqlOperationConf = this.getParentSession().getHiveConf();
        if (!this.getConfOverlay().isEmpty() || this.shouldRunAsync()) {
            sqlOperationConf = new HiveConf(sqlOperationConf);
            for (Map.Entry<String, String> confEntry : this.getConfOverlay().entrySet()) {
                try {
                    sqlOperationConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new HiveSQLException("Error applying statement specific settings", e);
                }
            }
        }
        return sqlOperationConf;
    }
}

