/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class HiveCommandOperation
extends ExecuteStatementOperation {
    private CommandProcessorResponse response;
    private CommandProcessor commandProcessor;
    private TableSchema resultSchema = null;
    private BufferedReader resultReader;

    protected HiveCommandOperation(HiveSession parentSession, String statement, CommandProcessor commandProcessor, Map<String, String> confOverlay) {
        super(parentSession, statement, confOverlay);
        this.commandProcessor = commandProcessor;
        this.setupSessionIO(parentSession.getSessionState());
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            LOG.info((Object)("Putting temp output to file " + sessionState.getTmpOutputFile().toString()));
            sessionState.in = null;
            sessionState.out = new PrintStream((OutputStream)new FileOutputStream(sessionState.getTmpOutputFile()), true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (IOException e) {
            LOG.error((Object)"Error in creating temp output file ", (Throwable)e);
            try {
                sessionState.in = null;
                sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
            }
            catch (UnsupportedEncodingException ee) {
                LOG.error((Object)"Error creating PrintStream", (Throwable)e);
                ee.printStackTrace();
                sessionState.out = null;
                sessionState.err = null;
            }
        }
    }

    private void tearDownSessionIO() {
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.parentSession.getSessionState().out});
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.parentSession.getSessionState().err});
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            String command = this.getStatement().trim();
            String[] tokens = this.statement.split("\\s");
            String commandArgs = command.substring(tokens[0].length()).trim();
            this.response = this.commandProcessor.run(commandArgs);
            int returnCode = this.response.getResponseCode();
            String sqlState = this.response.getSQLState();
            String errorMessage = this.response.getErrorMessage();
            Schema schema = this.response.getSchema();
            if (schema != null) {
                this.setHasResultSet(true);
                this.resultSchema = new TableSchema(schema);
            } else {
                this.setHasResultSet(false);
                this.resultSchema = new TableSchema();
            }
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
        this.tearDownSessionIO();
        this.cleanTmpFile();
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.resetResultReader();
        }
        List<String> rows = this.readResults((int)maxRows);
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion());
        for (String row : rows) {
            rowSet.addRow(new String[]{row});
        }
        return rowSet;
    }

    private List<String> readResults(int nLines) throws HiveSQLException {
        if (this.resultReader == null) {
            SessionState sessionState = this.getParentSession().getSessionState();
            File tmp = sessionState.getTmpOutputFile();
            try {
                this.resultReader = new BufferedReader(new FileReader(tmp));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("File " + tmp + " not found. "), (Throwable)e);
                throw new HiveSQLException(e);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < nLines || nLines <= 0; ++i) {
            try {
                String line = this.resultReader.readLine();
                if (line == null) break;
                results.add(line);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"Reading temp results encountered an exception: ", (Throwable)e);
                throw new HiveSQLException(e);
            }
        }
        return results;
    }

    private void cleanTmpFile() {
        this.resetResultReader();
        SessionState sessionState = this.getParentSession().getSessionState();
        File tmp = sessionState.getTmpOutputFile();
        tmp.delete();
    }

    private void resetResultReader() {
        if (this.resultReader != null) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.resultReader});
            this.resultReader = null;
        }
    }
}

