/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.hooks.HookUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public class SessionManager
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new HashMap<SessionHandle, HiveSession>();
    private OperationManager operationManager = new OperationManager();
    private LogManager logManager = new LogManager();
    private static final Object sessionMapLock = new Object();
    private ExecutorService backgroundOperationPool;
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.operationManager = new OperationManager();
        int backgroundPoolSize = hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_THREADS);
        LOG.info((Object)("HiveServer2: Async execution pool size" + backgroundPoolSize));
        this.backgroundOperationPool = Executors.newFixedThreadPool(backgroundPoolSize);
        this.addService(this.operationManager);
        this.logManager = new LogManager();
        this.logManager.setSessionManager(this);
        this.addService(this.logManager);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.backgroundOperationPool != null) {
            this.backgroundOperationPool.shutdown();
            long timeout = this.hiveConf.getLongVar(HiveConf.ConfVars.HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT);
            try {
                this.backgroundOperationPool.awaitTermination(timeout, TimeUnit.SECONDS);
            }
            catch (InterruptedException exc) {
                LOG.warn((Object)("HIVE_SERVER2_ASYNC_EXEC_SHUTDOWN_TIMEOUT = " + timeout + " seconds has been exceeded. RUNNING background operations will be shut down"), (Throwable)exc);
            }
        }
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf) throws HiveSQLException {
        return this.openSession(protocol, username, password, sessionConf, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        Object hiveSessionUgi;
        if (username == null) {
            username = threadLocalUserName.get();
        }
        if (withImpersonation) {
            hiveSessionUgi = new HiveSessionImplwithUGI(protocol, username, password, sessionConf, threadLocalIpAddress.get(), delegationToken);
            session = HiveSessionProxy.getProxy((HiveSession)hiveSessionUgi, ((HiveSessionImplwithUGI)hiveSessionUgi).getSessionUgi());
            ((HiveSessionImplwithUGI)hiveSessionUgi).setProxySession(session);
        } else {
            session = new HiveSessionImpl(protocol, username, password, sessionConf, threadLocalIpAddress.get());
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        session.setLogManager(this.logManager);
        hiveSessionUgi = sessionMapLock;
        synchronized (hiveSessionUgi) {
            this.handleToSession.put(session.getSessionHandle(), session);
        }
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            throw new HiveSQLException("Failed to execute session hooks", e);
        }
        return session.getSessionHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.remove(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.get(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    private void clearUserName() {
        threadLocalUserName.remove();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        List sessionHooks = HookUtils.getHooks((HiveConf)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK, HiveSessionHook.class);
        for (HiveSessionHook sessionHook : sessionHooks) {
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }

    public Future<?> submitBackgroundOperation(Runnable r) {
        return this.backgroundOperationPool.submit(r);
    }
}

