/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer = null;
    private String authTypeStr;
    HiveConf conf = new HiveConf();

    public HiveAuthFactory() throws TTransportException {
        this.authTypeStr = this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        if (this.authTypeStr == null) {
            this.authTypeStr = AuthTypes.NONE.getAuthName();
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName()) && ShimLoader.getHadoopShims().isSecureShimImpl()) {
            this.saslServer = ShimLoader.getHadoopThriftAuthBridge().createServer(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        Map hadoopSaslProps = ShimLoader.getHadoopThriftAuthBridge().getHadoopSaslProperties((Configuration)this.conf);
        SaslQOP hadoopSaslQOP = SaslQOP.fromString((String)hadoopSaslProps.get("javax.security.sasl.qop"));
        if (hadoopSaslQOP.ordinal() > saslQOP.ordinal()) {
            LOG.warn(MessageFormat.format("\"hadoop.rpc.protection\" is set to higher security level {0} then {1} which is set to {2}", hadoopSaslQOP.toString(), HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP.varname, saslQOP.toString()));
        }
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            try {
                transportFactory = this.saslServer.createTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NONE.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.LDAP.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NOSASL.getAuthName())) {
            transportFactory = new TTransportFactory();
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.CUSTOM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else {
            throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        if (this.saslServer != null) {
            return this.saslServer.getRemoteUser();
        }
        return null;
    }

    public String getIpAddress() {
        return this.saslServer != null ? this.saslServer.getRemoteAddress().toString() : null;
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() && keyTabFile.isEmpty()) {
            return;
        }
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 kerberos principal or keytab is not correctly configured");
        }
        ShimLoader.getHadoopShims().loginUserFromKeytab(principal, keyTabFile);
    }

    public static enum AuthTypes {
        NOSASL("NOSASL"),
        NONE("NONE"),
        LDAP("LDAP"),
        KERBEROS("KERBEROS"),
        CUSTOM("CUSTOM");

        private String authType;

        private AuthTypes(String authType) {
            this.authType = authType;
        }

        public String getAuthName() {
            return this.authType;
        }
    }
}

