/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.log;

import java.io.CharArrayWriter;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.log.OperationLog;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LogDivertAppender
extends WriterAppender {
    private static final Logger LOG = Logger.getLogger((String)LogDivertAppender.class.getName());
    private final LogManager logManager;
    private final CharArrayWriter writer = new CharArrayWriter();

    public LogDivertAppender(Layout layout, LogManager logManager) {
        this.setLayout(layout);
        this.setWriter(this.writer);
        this.setName("LogDivertAppender");
        this.logManager = logManager;
        this.addFilter(new NameExclusionFilter(LOG.getName()));
        this.addFilter(new NameExclusionFilter(OperationLog.class.getName()));
        this.addFilter(new NameExclusionFilter(LogManager.class.getName()));
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        String logOutput = this.writer.toString();
        this.writer.reset();
        OperationLog log = this.logManager.getOperationLogByThreadName(event.getThreadName());
        if (log == null) {
            LOG.debug((Object)(" ---+++=== Dropped log event from thread " + event.getThreadName()));
            return;
        }
        log.writeOperationLog(logOutput);
    }

    private class NameExclusionFilter
    extends Filter {
        private String excludeLoggerName = null;

        public NameExclusionFilter(String excludeLoggerName) {
            this.excludeLoggerName = excludeLoggerName;
        }

        public int decide(LoggingEvent ev) {
            if (ev.getLoggerName().equals(this.excludeLoggerName)) {
                return -1;
            }
            return 0;
        }
    }
}

