/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.util.List;
import java.util.Map;
import org.apache.hive.service.cli.CLIServiceClient;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelOperationReq;
import org.apache.hive.service.cli.thrift.TCancelOperationResp;
import org.apache.hive.service.cli.thrift.TCloseOperationReq;
import org.apache.hive.service.cli.thrift.TCloseOperationResp;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TCloseSessionResp;
import org.apache.hive.service.cli.thrift.TExecuteStatementReq;
import org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import org.apache.hive.service.cli.thrift.TFetchResultsReq;
import org.apache.hive.service.cli.thrift.TFetchResultsResp;
import org.apache.hive.service.cli.thrift.TGetCatalogsReq;
import org.apache.hive.service.cli.thrift.TGetCatalogsResp;
import org.apache.hive.service.cli.thrift.TGetColumnsReq;
import org.apache.hive.service.cli.thrift.TGetColumnsResp;
import org.apache.hive.service.cli.thrift.TGetFunctionsReq;
import org.apache.hive.service.cli.thrift.TGetFunctionsResp;
import org.apache.hive.service.cli.thrift.TGetInfoReq;
import org.apache.hive.service.cli.thrift.TGetInfoResp;
import org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.cli.thrift.TGetSchemasReq;
import org.apache.hive.service.cli.thrift.TGetSchemasResp;
import org.apache.hive.service.cli.thrift.TGetTableTypesReq;
import org.apache.hive.service.cli.thrift.TGetTableTypesResp;
import org.apache.hive.service.cli.thrift.TGetTablesReq;
import org.apache.hive.service.cli.thrift.TGetTablesResp;
import org.apache.hive.service.cli.thrift.TGetTypeInfoReq;
import org.apache.hive.service.cli.thrift.TGetTypeInfoResp;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TStatus;
import org.apache.hive.service.cli.thrift.TStatusCode;

public class ThriftCLIServiceClient
extends CLIServiceClient {
    private final TCLIService.Iface cliService;

    public ThriftCLIServiceClient(TCLIService.Iface cliService) {
        this.cliService = cliService;
    }

    public void checkStatus(TStatus status) throws HiveSQLException {
        if (TStatusCode.ERROR_STATUS.equals((Object)status.getStatusCode())) {
            throw new HiveSQLException(status);
        }
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        try {
            TOpenSessionReq req = new TOpenSessionReq();
            req.setUsername(username);
            req.setPassword(password);
            req.setConfiguration(configuration);
            TOpenSessionResp resp = this.cliService.OpenSession(req);
            this.checkStatus(resp.getStatus());
            return new SessionHandle(resp.getSessionHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        throw new HiveSQLException("open with impersonation operation is not supported in the client");
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TCloseSessionReq req = new TCloseSessionReq(sessionHandle.toTSessionHandle());
            TCloseSessionResp resp = this.cliService.CloseSession(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType infoType) throws HiveSQLException {
        try {
            TGetInfoReq req = new TGetInfoReq(sessionHandle.toTSessionHandle(), infoType.toTGetInfoType());
            TGetInfoResp resp = this.cliService.GetInfo(req);
            this.checkStatus(resp.getStatus());
            return new GetInfoValue(resp.getInfoValue());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(sessionHandle, statement, confOverlay, false);
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        return this.executeStatementInternal(sessionHandle, statement, confOverlay, true);
    }

    private OperationHandle executeStatementInternal(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, boolean isAsync) throws HiveSQLException {
        try {
            TExecuteStatementReq req = new TExecuteStatementReq(sessionHandle.toTSessionHandle(), statement);
            req.setConfOverlay(confOverlay);
            req.setRunAsync(isAsync);
            TExecuteStatementResp resp = this.cliService.ExecuteStatement(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetTypeInfoReq req = new TGetTypeInfoReq(sessionHandle.toTSessionHandle());
            TGetTypeInfoResp resp = this.cliService.GetTypeInfo(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetCatalogsReq req = new TGetCatalogsReq(sessionHandle.toTSessionHandle());
            TGetCatalogsResp resp = this.cliService.GetCatalogs(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        try {
            TGetSchemasReq req = new TGetSchemasReq(sessionHandle.toTSessionHandle());
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            TGetSchemasResp resp = this.cliService.GetSchemas(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        try {
            TGetTablesReq req = new TGetTablesReq(sessionHandle.toTSessionHandle());
            req.setTableName(tableName);
            req.setTableTypes(tableTypes);
            req.setSchemaName(schemaName);
            TGetTablesResp resp = this.cliService.GetTables(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        try {
            TGetTableTypesReq req = new TGetTableTypesReq(sessionHandle.toTSessionHandle());
            TGetTableTypesResp resp = this.cliService.GetTableTypes(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        try {
            TGetColumnsReq req = new TGetColumnsReq();
            req.setSessionHandle(sessionHandle.toTSessionHandle());
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            req.setTableName(tableName);
            req.setColumnName(columnName);
            TGetColumnsResp resp = this.cliService.GetColumns(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        try {
            TGetFunctionsReq req = new TGetFunctionsReq(sessionHandle.toTSessionHandle(), functionName);
            req.setCatalogName(catalogName);
            req.setSchemaName(schemaName);
            TGetFunctionsResp resp = this.cliService.GetFunctions(req);
            this.checkStatus(resp.getStatus());
            return new OperationHandle(resp.getOperationHandle());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public OperationState getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        try {
            TGetOperationStatusReq req = new TGetOperationStatusReq(opHandle.toTOperationHandle());
            TGetOperationStatusResp resp = this.cliService.GetOperationStatus(req);
            this.checkStatus(resp.getStatus());
            return OperationState.getOperationState(resp.getOperationState());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        try {
            TCancelOperationReq req = new TCancelOperationReq(opHandle.toTOperationHandle());
            TCancelOperationResp resp = this.cliService.CancelOperation(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        try {
            TCloseOperationReq req = new TCloseOperationReq(opHandle.toTOperationHandle());
            TCloseOperationResp resp = this.cliService.CloseOperation(req);
            this.checkStatus(resp.getStatus());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        try {
            TGetResultSetMetadataReq req = new TGetResultSetMetadataReq(opHandle.toTOperationHandle());
            TGetResultSetMetadataResp resp = this.cliService.GetResultSetMetadata(req);
            this.checkStatus(resp.getStatus());
            return new TableSchema(resp.getSchema());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        try {
            TFetchResultsReq req = new TFetchResultsReq();
            req.setOperationHandle(opHandle.toTOperationHandle());
            req.setOrientation(orientation.toTFetchOrientation());
            req.setMaxRows(maxRows);
            TFetchResultsResp resp = this.cliService.FetchResults(req);
            this.checkStatus(resp.getStatus());
            return new RowSet(resp.getResults());
        }
        catch (HiveSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, FetchOrientation.FETCH_NEXT, 10000L);
    }
}

