/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.Type;
import org.apache.hive.service.cli.thrift.TColumnDesc;
import org.apache.hive.service.cli.thrift.TTableSchema;

public class TableSchema {
    private final List<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();

    public TableSchema() {
    }

    public TableSchema(int numColumns) {
    }

    public TableSchema(TTableSchema tTableSchema) {
        for (TColumnDesc tColumnDesc : tTableSchema.getColumns()) {
            this.columns.add(new ColumnDescriptor(tColumnDesc));
        }
    }

    public TableSchema(List<FieldSchema> fieldSchemas) {
        int pos = 1;
        for (FieldSchema field : fieldSchemas) {
            this.columns.add(new ColumnDescriptor(field, pos++));
        }
    }

    public TableSchema(Schema schema) {
        this(schema.getFieldSchemas());
    }

    public List<ColumnDescriptor> getColumnDescriptors() {
        return new ArrayList<ColumnDescriptor>(this.columns);
    }

    public ColumnDescriptor getColumnDescriptorAt(int pos) {
        return this.columns.get(pos);
    }

    public int getSize() {
        return this.columns.size();
    }

    public void clear() {
        this.columns.clear();
    }

    public TTableSchema toTTableSchema() {
        TTableSchema tTableSchema = new TTableSchema();
        for (ColumnDescriptor col : this.columns) {
            tTableSchema.addToColumns(col.toTColumnDesc());
        }
        return tTableSchema;
    }

    public TableSchema addPrimitiveColumn(String columnName, Type columnType, String columnComment) {
        this.columns.add(ColumnDescriptor.newPrimitiveColumnDescriptor(columnName, columnComment, columnType, this.columns.size() + 1));
        return this;
    }

    public TableSchema addStringColumn(String columnName, String columnComment) {
        this.columns.add(ColumnDescriptor.newPrimitiveColumnDescriptor(columnName, columnComment, Type.STRING_TYPE, this.columns.size() + 1));
        return this;
    }
}

