/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.operation.AddResourceOperation;
import org.apache.hive.service.cli.operation.DeleteResourceOperation;
import org.apache.hive.service.cli.operation.DfsOperation;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.operation.SQLOperation;
import org.apache.hive.service.cli.operation.SetOperation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class ExecuteStatementOperation
extends Operation {
    protected String statement = null;
    protected Map<String, String> confOverlay = new HashMap<String, String>();

    public ExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, OperationType.EXECUTE_STATEMENT);
        this.statement = statement;
        this.confOverlay = confOverlay;
    }

    public String getStatement() {
        return this.statement;
    }

    public static ExecuteStatementOperation newExecuteStatementOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay, boolean runAsync) {
        String[] tokens = statement.trim().split("\\s+");
        String command = tokens[0].toLowerCase();
        if ("set".equals(command)) {
            return new SetOperation(parentSession, statement, confOverlay);
        }
        if ("dfs".equals(command)) {
            return new DfsOperation(parentSession, statement, confOverlay);
        }
        if ("add".equals(command)) {
            return new AddResourceOperation(parentSession, statement, confOverlay);
        }
        if ("delete".equals(command)) {
            return new DeleteResourceOperation(parentSession, statement, confOverlay);
        }
        return new SQLOperation(parentSession, statement, confOverlay, runAsync);
    }
}

