/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.server.ServerOptionsProcessor;

public class HiveServer2
extends CompositeService {
    private static final Log LOG = LogFactory.getLog(HiveServer2.class);
    private static CompositeService.CompositeServiceShutdownHook serverShutdownHook;
    public static final int SHUTDOWN_HOOK_PRIORITY = 100;
    private CLIService cliService;
    private ThriftCLIService thriftCLIService;

    public HiveServer2() {
        super("HiveServer2");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.cliService = new CLIService();
        this.addService(this.cliService);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            try {
                Path scratchDir = new Path(HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIR));
                FileSystem fs = FileSystem.get((Configuration)hiveConf);
                if (!fs.exists(scratchDir)) {
                    fs.mkdirs(scratchDir);
                }
                fs.setPermission(scratchDir, new FsPermission(511));
            }
            catch (IOException e) {
                LOG.warn((Object)String.format("Failed to create/change scratchdir permissions to 777: %s", e.getMessage()), (Throwable)e);
            }
        }
        this.thriftCLIService = new ThriftCLIService(this.cliService);
        this.addService(this.thriftCLIService);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public static void main(String[] args) {
        try {
            LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            LOG.warn((Object)e.getMessage());
        }
        HiveStringUtils.startupShutdownMessage(HiveServer2.class, (String[])args, (Log)LOG);
        try {
            ServerOptionsProcessor oproc = new ServerOptionsProcessor("hiveserver2");
            if (!oproc.process(args)) {
                LOG.fatal((Object)"Error starting HiveServer2 with given arguments");
                System.exit(-1);
            }
            HiveConf hiveConf = new HiveConf();
            HiveServer2 server = new HiveServer2();
            server.init(hiveConf);
            server.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting HiveServer2", t);
            System.exit(-1);
        }
    }
}

