/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class CustomAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    Class<? extends PasswdAuthenticationProvider> customHandlerClass;
    PasswdAuthenticationProvider customProvider;

    CustomAuthenticationProviderImpl() throws AuthenticationException {
        HiveConf conf = new HiveConf();
        try {
            this.customHandlerClass = conf.getClass(HiveConf.ConfVars.HIVE_SERVER2_CUSTOM_AUTHENTICATION_CLASS.varname, PasswdAuthenticationProvider.class);
            this.customProvider = (PasswdAuthenticationProvider)ReflectionUtils.newInstance(this.customHandlerClass, (Configuration)conf);
        }
        catch (Exception e) {
            throw new AuthenticationException(e.toString());
        }
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        this.customProvider.Authenticate(user, password);
    }
}

