/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import javax.security.sasl.AuthenticationException;
import net.sf.jpam.Pam;
import net.sf.jpam.PamReturnValue;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class PamAuthenticationProvider
implements PasswdAuthenticationProvider {
    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        String[] pamSchemes;
        HiveConf conf = new HiveConf();
        String hivePamProfiles = conf.get("hive.server2.authentication.pam.profiles");
        if (hivePamProfiles == null || hivePamProfiles.trim().isEmpty()) {
            throw new AuthenticationException("PAM profiles not configured for hive");
        }
        for (String pamScheme : pamSchemes = hivePamProfiles.split(",")) {
            if ((pamScheme = pamScheme.trim()).isEmpty()) continue;
            try {
                Pam pam = new Pam(pamScheme);
                PamReturnValue err = pam.authenticate(user, password);
                if (err == PamReturnValue.PAM_SUCCESS) continue;
                throw new AuthenticationException("Error validating user through PAM. PamReturnValue=" + err);
            }
            catch (LinkageError ex) {
                throw new AuthenticationException("Link Error", ex);
            }
        }
    }
}

