/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;

public class HiveSessionImplwithUGI
extends HiveSessionImpl {
    public static final String HS2TOKEN = "HiveServer2ImpersonationToken";
    private UserGroupInformation sessionUgi = null;
    private String delegationTokenStr = null;
    private Hive sessionHive = null;
    private HiveSession proxySession = null;

    public HiveSessionImplwithUGI(String username, String password, Map<String, String> sessionConf, String delegationToken) throws HiveSQLException {
        super(username, password, sessionConf);
        this.setSessionUGI(username);
        this.setUserPath(username);
        this.setDelegationToken(delegationToken);
    }

    public void setSessionUGI(String owner) throws HiveSQLException {
        if (owner == null) {
            throw new HiveSQLException("No username provided for impersonation");
        }
        if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
            try {
                this.sessionUgi = ShimLoader.getHadoopShims().createProxyUser(owner);
            }
            catch (IOException e) {
                throw new HiveSQLException("Couldn't setup proxy user", e);
            }
        } else {
            this.sessionUgi = ShimLoader.getHadoopShims().createRemoteUser(owner, null);
        }
    }

    public UserGroupInformation getSessionUgi() {
        return this.sessionUgi;
    }

    public String getDelegationToken() {
        return this.delegationTokenStr;
    }

    @Override
    protected synchronized void acquire() throws HiveSQLException {
        super.acquire();
        if (this.sessionHive != null) {
            Hive.set((Hive)this.sessionHive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire();
            ShimLoader.getHadoopShims().closeAllForUGI(this.sessionUgi);
            this.cancelDelegationToken();
        }
        finally {
            this.release();
            super.close();
        }
    }

    private void setDelegationToken(String delegationTokenStr) throws HiveSQLException {
        this.delegationTokenStr = delegationTokenStr;
        if (delegationTokenStr != null) {
            this.getHiveConf().set("hive.metastore.token.signature", HS2TOKEN);
            try {
                ShimLoader.getHadoopShims().setTokenStr(this.sessionUgi, delegationTokenStr, HS2TOKEN);
            }
            catch (IOException e) {
                throw new HiveSQLException("Couldn't setup delegation token in the ugi", e);
            }
            Hive.set(null);
            try {
                this.sessionHive = Hive.get((HiveConf)this.getHiveConf());
            }
            catch (HiveException e) {
                throw new HiveSQLException("Failed to setup metastore connection", e);
            }
        }
    }

    private void cancelDelegationToken() throws HiveSQLException {
        if (this.delegationTokenStr != null) {
            try {
                Hive.get((HiveConf)this.getHiveConf()).cancelDelegationToken(this.delegationTokenStr);
            }
            catch (HiveException e) {
                throw new HiveSQLException("Couldn't cancel delegation token", e);
            }
            Hive.closeCurrent();
        }
    }

    private void setUserPath(String userName) {
        for (HiveConf.ConfVars var : HiveConf.userVars) {
            String userVar = this.getHiveConf().getVar(var);
            if (userVar == null) continue;
            if (userVar.endsWith(File.separator)) {
                userVar = userVar.substring(0, userVar.length() - 2);
            }
            this.getHiveConf().setVar(var, userVar + "-" + userName);
        }
    }

    @Override
    protected HiveSession getSession() {
        assert (this.proxySession != null);
        return this.proxySession;
    }

    public void setProxySession(HiveSession proxySession) {
        this.proxySession = proxySession;
    }
}

