/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;

public class SessionManager
extends CompositeService {
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new HashMap<SessionHandle, HiveSession>();
    private OperationManager operationManager = new OperationManager();

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.operationManager = new OperationManager();
        this.addService(this.operationManager);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    public SessionHandle openSession(String username, String password, Map<String, String> sessionConf) {
        HiveSession session = new HiveSession(username, password, sessionConf);
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        this.handleToSession.put(session.getSessionHandle(), session);
        return session.getSessionHandle();
    }

    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.remove(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session = this.handleToSession.get(sessionHandle);
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }
}

