/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.operation.GetCatalogsOperation;
import org.apache.hive.service.cli.operation.GetColumnsOperation;
import org.apache.hive.service.cli.operation.GetFunctionsOperation;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.operation.GetTableTypesOperation;
import org.apache.hive.service.cli.operation.GetTypeInfoOperation;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.SessionManager;

public class HiveSession {
    private final SessionHandle sessionHandle = new SessionHandle();
    private final String username;
    private final String password;
    private final Map<String, String> sessionConf = new HashMap<String, String>();
    private final HiveConf hiveConf = new HiveConf();
    private final SessionState sessionState;
    private static final String FETCH_WORK_SERDE_CLASS = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
    private SessionManager sessionManager;
    private OperationManager operationManager;
    private IMetaStoreClient metastoreClient = null;

    public HiveSession(String username, String password, Map<String, String> sessionConf) {
        this.username = username;
        this.password = password;
        if (sessionConf != null) {
            sessionConf.putAll(sessionConf);
        }
        this.sessionState = new SessionState(this.hiveConf);
    }

    private SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    private OperationManager getOperationManager() {
        return this.operationManager;
    }

    public void setOperationManager(OperationManager operationManager) {
        this.operationManager = operationManager;
    }

    private synchronized void acquire() {
        SessionState.start((SessionState)this.sessionState);
    }

    private synchronized void release() {
        assert (this.sessionState != null);
    }

    public SessionHandle getSessionHandle() {
        return this.sessionHandle;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public HiveConf getHiveConf() {
        this.hiveConf.setVar(HiveConf.ConfVars.HIVEFETCHOUTPUTSERDE, FETCH_WORK_SERDE_CLASS);
        return this.hiveConf;
    }

    public IMetaStoreClient getMetaStoreClient() throws HiveSQLException {
        if (this.metastoreClient == null) {
            try {
                this.metastoreClient = new HiveMetaStoreClient(this.getHiveConf());
            }
            catch (MetaException e) {
                throw new HiveSQLException(e);
            }
        }
        return this.metastoreClient;
    }

    public GetInfoValue getInfo(GetInfoType getInfoType) throws HiveSQLException {
        this.acquire();
        try {
            switch (getInfoType) {
                case CLI_SERVER_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_NAME: {
                    GetInfoValue getInfoValue = new GetInfoValue("Apache Hive");
                    return getInfoValue;
                }
                case CLI_DBMS_VER: {
                    GetInfoValue getInfoValue = new GetInfoValue("0.10");
                    return getInfoValue;
                }
                case CLI_MAX_COLUMN_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_SCHEMA_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
                case CLI_MAX_TABLE_NAME_LEN: {
                    GetInfoValue getInfoValue = new GetInfoValue(128);
                    return getInfoValue;
                }
            }
            throw new HiveSQLException("Unrecognized GetInfoType value: " + getInfoType.toString());
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle executeStatement(String statement, Map<String, String> confOverlay) throws HiveSQLException {
        this.acquire();
        try {
            ExecuteStatementOperation operation = this.getOperationManager().newExecuteStatementOperation(this, statement, confOverlay);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getTypeInfo() throws HiveSQLException {
        this.acquire();
        try {
            GetTypeInfoOperation operation = this.getOperationManager().newGetTypeInfoOperation(this);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getCatalogs() throws HiveSQLException {
        this.acquire();
        try {
            GetCatalogsOperation operation = this.getOperationManager().newGetCatalogsOperation(this);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getSchemas(String catalogName, String schemaName) throws HiveSQLException {
        this.acquire();
        try {
            GetSchemasOperation operation = this.getOperationManager().newGetSchemasOperation(this, catalogName, schemaName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getTables(String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        this.acquire();
        try {
            MetadataOperation operation = this.getOperationManager().newGetTablesOperation(this, catalogName, schemaName, tableName, tableTypes);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getTableTypes() throws HiveSQLException {
        this.acquire();
        try {
            GetTableTypesOperation operation = this.getOperationManager().newGetTableTypesOperation(this);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getColumns(String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        this.acquire();
        try {
            GetColumnsOperation operation = this.getOperationManager().newGetColumnsOperation(this, catalogName, schemaName, tableName, columnName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandle getFunctions(String catalogName, String schemaName, String functionName) throws HiveSQLException {
        this.acquire();
        try {
            GetFunctionsOperation operation = this.getOperationManager().newGetFunctionsOperation(this, catalogName, schemaName, functionName);
            operation.run();
            OperationHandle operationHandle = operation.getHandle();
            return operationHandle;
        }
        finally {
            this.release();
        }
    }

    public void close() throws HiveSQLException {
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }
}

