/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.thrift;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TCancelOperationReq;
import org.apache.hive.service.cli.thrift.TCancelOperationResp;
import org.apache.hive.service.cli.thrift.TCloseOperationReq;
import org.apache.hive.service.cli.thrift.TCloseOperationResp;
import org.apache.hive.service.cli.thrift.TCloseSessionReq;
import org.apache.hive.service.cli.thrift.TCloseSessionResp;
import org.apache.hive.service.cli.thrift.TExecuteStatementReq;
import org.apache.hive.service.cli.thrift.TExecuteStatementResp;
import org.apache.hive.service.cli.thrift.TFetchResultsReq;
import org.apache.hive.service.cli.thrift.TFetchResultsResp;
import org.apache.hive.service.cli.thrift.TGetCatalogsReq;
import org.apache.hive.service.cli.thrift.TGetCatalogsResp;
import org.apache.hive.service.cli.thrift.TGetColumnsReq;
import org.apache.hive.service.cli.thrift.TGetColumnsResp;
import org.apache.hive.service.cli.thrift.TGetFunctionsReq;
import org.apache.hive.service.cli.thrift.TGetFunctionsResp;
import org.apache.hive.service.cli.thrift.TGetInfoReq;
import org.apache.hive.service.cli.thrift.TGetInfoResp;
import org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataReq;
import org.apache.hive.service.cli.thrift.TGetResultSetMetadataResp;
import org.apache.hive.service.cli.thrift.TGetSchemasReq;
import org.apache.hive.service.cli.thrift.TGetSchemasResp;
import org.apache.hive.service.cli.thrift.TGetTableTypesReq;
import org.apache.hive.service.cli.thrift.TGetTableTypesResp;
import org.apache.hive.service.cli.thrift.TGetTablesReq;
import org.apache.hive.service.cli.thrift.TGetTablesResp;
import org.apache.hive.service.cli.thrift.TGetTypeInfoReq;
import org.apache.hive.service.cli.thrift.TGetTypeInfoResp;
import org.apache.hive.service.cli.thrift.TOpenSessionReq;
import org.apache.hive.service.cli.thrift.TOpenSessionResp;
import org.apache.hive.service.cli.thrift.TStatus;
import org.apache.hive.service.cli.thrift.TStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftCLIService
extends AbstractService
implements TCLIService.Iface,
Runnable {
    public static final Log LOG = LogFactory.getLog((String)ThriftCLIService.class.getName());
    protected CLIService cliService;
    private static final TStatus OK_STATUS = new TStatus(TStatusCode.SUCCESS_STATUS);
    private static final TStatus ERROR_STATUS = new TStatus(TStatusCode.ERROR_STATUS);
    private static HiveAuthFactory hiveAuthFactory;
    private int portNum;
    private InetSocketAddress serverAddress;
    private TServer server;
    private boolean isStarted = false;
    protected boolean isEmbedded = false;
    private HiveConf hiveConf;
    private int minWorkerThreads;
    private int maxWorkerThreads;

    public ThriftCLIService(CLIService cliService) {
        super("ThriftCLIService");
        this.cliService = cliService;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (!this.isStarted && !this.isEmbedded) {
            new Thread(this).start();
            this.isStarted = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.isStarted && !this.isEmbedded) {
            this.server.stop();
            this.isStarted = false;
        }
        super.stop();
    }

    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq req) throws TException {
        TOpenSessionResp resp = new TOpenSessionResp();
        try {
            String userName = hiveAuthFactory != null && hiveAuthFactory.getRemoteUser() != null ? hiveAuthFactory.getRemoteUser() : req.getUsername();
            SessionHandle sessionHandle = this.cliService.openSession(userName, req.getPassword(), req.getConfiguration());
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(new HashMap<String, String>());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq req) throws TException {
        TCloseSessionResp resp = new TCloseSessionResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            this.cliService.closeSession(sessionHandle);
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetInfoResp GetInfo(TGetInfoReq req) throws TException {
        TGetInfoResp resp = new TGetInfoResp();
        try {
            GetInfoValue getInfoValue = this.cliService.getInfo(new SessionHandle(req.getSessionHandle()), GetInfoType.getGetInfoType(req.getInfoType()));
            resp.setInfoValue(getInfoValue.toTGetInfoValue());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq req) throws TException {
        TExecuteStatementResp resp = new TExecuteStatementResp();
        try {
            SessionHandle sessionHandle = new SessionHandle(req.getSessionHandle());
            String statement = req.getStatement();
            Map<String, String> confOverlay = req.getConfOverlay();
            OperationHandle operationHandle = this.cliService.executeStatement(sessionHandle, statement, confOverlay);
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq req) throws TException {
        TGetTypeInfoResp resp = new TGetTypeInfoResp();
        try {
            OperationHandle operationHandle = this.cliService.getTypeInfo(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(operationHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq req) throws TException {
        TGetCatalogsResp resp = new TGetCatalogsResp();
        try {
            OperationHandle opHandle = this.cliService.getCatalogs(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq req) throws TException {
        TGetSchemasResp resp = new TGetSchemasResp();
        try {
            OperationHandle opHandle = this.cliService.getSchemas(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTablesResp GetTables(TGetTablesReq req) throws TException {
        TGetTablesResp resp = new TGetTablesResp();
        try {
            OperationHandle opHandle = this.cliService.getTables(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getTableTypes());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq req) throws TException {
        TGetTableTypesResp resp = new TGetTableTypesResp();
        try {
            OperationHandle opHandle = this.cliService.getTableTypes(new SessionHandle(req.getSessionHandle()));
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq req) throws TException {
        TGetColumnsResp resp = new TGetColumnsResp();
        try {
            OperationHandle opHandle = this.cliService.getColumns(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getTableName(), req.getColumnName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq req) throws TException {
        TGetFunctionsResp resp = new TGetFunctionsResp();
        try {
            OperationHandle opHandle = this.cliService.getFunctions(new SessionHandle(req.getSessionHandle()), req.getCatalogName(), req.getSchemaName(), req.getFunctionName());
            resp.setOperationHandle(opHandle.toTOperationHandle());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq req) throws TException {
        TGetOperationStatusResp resp = new TGetOperationStatusResp();
        try {
            OperationState operationState = this.cliService.getOperationStatus(new OperationHandle(req.getOperationHandle()));
            resp.setOperationState(operationState.toTOperationState());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TCancelOperationResp CancelOperation(TCancelOperationReq req) throws TException {
        TCancelOperationResp resp = new TCancelOperationResp();
        try {
            this.cliService.cancelOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq req) throws TException {
        TCloseOperationResp resp = new TCloseOperationResp();
        try {
            this.cliService.closeOperation(new OperationHandle(req.getOperationHandle()));
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq req) throws TException {
        TGetResultSetMetadataResp resp = new TGetResultSetMetadataResp();
        try {
            TableSchema schema = this.cliService.getResultSetMetadata(new OperationHandle(req.getOperationHandle()));
            resp.setSchema(schema.toTTableSchema());
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq req) throws TException {
        TFetchResultsResp resp = new TFetchResultsResp();
        try {
            RowSet rowSet = this.cliService.fetchResults(new OperationHandle(req.getOperationHandle()), FetchOrientation.getFetchOrientation(req.getOrientation()), req.getMaxRows());
            resp.setResults(rowSet.toTRowSet());
            resp.setHasMoreRows(false);
            resp.setStatus(OK_STATUS);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.setStatus(HiveSQLException.toTStatus(e));
        }
        return resp;
    }

    @Override
    public void run() {
        try {
            hiveAuthFactory = new HiveAuthFactory();
            TTransportFactory transportFactory = hiveAuthFactory.getAuthTransFactory();
            TProcessorFactory processorFactory = hiveAuthFactory.getAuthProcFactory(this);
            String portString = System.getenv("HIVE_SERVER2_THRIFT_PORT");
            this.portNum = portString != null ? Integer.valueOf(portString).intValue() : this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_PORT);
            String hiveHost = System.getenv("HIVE_SERVER2_THRIFT_BIND_HOST");
            if (hiveHost == null) {
                hiveHost = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_BIND_HOST);
            }
            this.serverAddress = hiveHost != null && !hiveHost.isEmpty() ? new InetSocketAddress(hiveHost, this.portNum) : new InetSocketAddress(this.portNum);
            this.minWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MIN_WORKER_THREADS);
            this.maxWorkerThreads = this.hiveConf.getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_MAX_WORKER_THREADS);
            TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)new TServerSocket(this.serverAddress)).processorFactory(processorFactory)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(this.minWorkerThreads).maxWorkerThreads(this.maxWorkerThreads);
            this.server = new TThreadPoolServer(sargs);
            LOG.info((Object)("ThriftCLIService listening on " + this.serverAddress));
            this.server.serve();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

