/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.parse.VariableSubstitution;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class SQLOperation
extends ExecuteStatementOperation {
    private Driver driver = null;
    private CommandProcessorResponse response;
    private TableSchema resultSchema = null;
    private Schema mResultSchema = null;
    private SerDe serde = null;

    public SQLOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, statement, confOverlay);
    }

    public void prepare() throws HiveSQLException {
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        String statement_trimmed = this.statement.trim();
        String[] tokens = statement_trimmed.split("\\s");
        String cmd_1 = statement_trimmed.substring(tokens[0].length()).trim();
        boolean ret = false;
        String errorMessage = "";
        Object SQLState = null;
        try {
            this.driver = new Driver(this.getParentSession().getHiveConf());
            this.driver.setTryCount(Integer.MAX_VALUE);
            String subStatement = new VariableSubstitution().substitute(this.getParentSession().getHiveConf(), this.statement);
            this.response = this.driver.run(subStatement);
            if (0 != this.response.getResponseCode()) {
                throw new HiveSQLException("Error while processing statement: " + this.response.getErrorMessage(), this.response.getSQLState(), this.response.getResponseCode());
            }
            this.mResultSchema = this.driver.getSchema();
            if (this.mResultSchema != null && this.mResultSchema.isSetFieldSchemas()) {
                this.resultSchema = new TableSchema(this.mResultSchema);
                this.setHasResultSet(true);
            } else {
                this.setHasResultSet(false);
            }
        }
        catch (HiveSQLException e) {
            this.setState(OperationState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString());
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void cancel() throws HiveSQLException {
        SessionState session;
        this.setState(OperationState.CANCELED);
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        if ((session = SessionState.get()).getTmpOutputFile() != null) {
            session.getTmpOutputFile().delete();
        }
    }

    @Override
    public void close() throws HiveSQLException {
        SessionState session;
        this.setState(OperationState.CLOSED);
        if (this.driver != null) {
            this.driver.close();
            this.driver.destroy();
        }
        if ((session = SessionState.get()).getTmpOutputFile() != null) {
            session.getTmpOutputFile().delete();
        }
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        if (this.resultSchema == null) {
            this.resultSchema = new TableSchema(this.driver.getSchema());
        }
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        ArrayList rows = new ArrayList();
        this.driver.setMaxRows((int)maxRows);
        try {
            this.driver.getResults(rows);
            this.getSerDe();
            StructObjectInspector soi = (StructObjectInspector)this.serde.getObjectInspector();
            List fieldRefs = soi.getAllStructFieldRefs();
            RowSet rowSet = new RowSet();
            Object[] deserializedFields = new Object[fieldRefs.size()];
            for (String rowString : rows) {
                Object rowObj = this.serde.deserialize((Writable)new BytesWritable(rowString.getBytes()));
                for (int i = 0; i < fieldRefs.size(); ++i) {
                    StructField fieldRef = (StructField)fieldRefs.get(i);
                    ObjectInspector fieldOI = fieldRef.getFieldObjectInspector();
                    deserializedFields[i] = SQLOperation.convertLazyToJava(soi.getStructFieldData(rowObj, fieldRef), fieldOI);
                }
                rowSet.addRow(this.resultSchema, deserializedFields);
            }
            return rowSet;
        }
        catch (IOException e) {
            throw new HiveSQLException(e);
        }
        catch (CommandNeedRetryException e) {
            throw new HiveSQLException(e);
        }
        catch (Exception e) {
            throw new HiveSQLException(e);
        }
    }

    private static Object convertLazyToJava(Object o, ObjectInspector oi) {
        Object obj = ObjectInspectorUtils.copyToStandardObject((Object)o, (ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
        if (obj != null && oi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            obj = obj.toString();
        }
        return obj;
    }

    private SerDe getSerDe() throws SQLException {
        if (this.serde != null) {
            return this.serde;
        }
        try {
            List fieldSchemas = this.mResultSchema.getFieldSchemas();
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> columnTypes = new ArrayList<String>();
            StringBuilder namesSb = new StringBuilder();
            StringBuilder typesSb = new StringBuilder();
            if (fieldSchemas != null && !fieldSchemas.isEmpty()) {
                for (int pos = 0; pos < fieldSchemas.size(); ++pos) {
                    if (pos != 0) {
                        namesSb.append(",");
                        typesSb.append(",");
                    }
                    columnNames.add(((FieldSchema)fieldSchemas.get(pos)).getName());
                    columnTypes.add(((FieldSchema)fieldSchemas.get(pos)).getType());
                    namesSb.append(((FieldSchema)fieldSchemas.get(pos)).getName());
                    typesSb.append(((FieldSchema)fieldSchemas.get(pos)).getType());
                }
            }
            String names = namesSb.toString();
            String types = typesSb.toString();
            this.serde = new LazySimpleSerDe();
            Properties props = new Properties();
            if (names.length() > 0) {
                LOG.debug((Object)("Column names: " + names));
                props.setProperty("columns", names);
            }
            if (types.length() > 0) {
                LOG.debug((Object)("Column types: " + types));
                props.setProperty("columns.types", types);
            }
            this.serde.initialize((Configuration)new HiveConf(), props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SQLException("Could not create ResultSet: " + ex.getMessage(), ex);
        }
        return this.serde;
    }
}

