/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class HiveCommandOperation
extends ExecuteStatementOperation {
    private CommandProcessorResponse response;
    private CommandProcessor commandProcessor;
    private TableSchema resultSchema = null;
    private BufferedReader resultReader;

    protected HiveCommandOperation(HiveSession parentSession, String statement, Map<String, String> confOverlay) {
        super(parentSession, statement, confOverlay);
        this.setupSessionIO(parentSession.getSessionState());
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            LOG.info((Object)("Putting temp output to file " + sessionState.getTmpOutputFile().toString()));
            sessionState.in = null;
            sessionState.out = new PrintStream((OutputStream)new FileOutputStream(sessionState.getTmpOutputFile()), true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (IOException e) {
            LOG.error((Object)"Error in creating temp output file ", (Throwable)e);
            try {
                sessionState.in = null;
                sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
            }
            catch (UnsupportedEncodingException ee) {
                ee.printStackTrace();
                sessionState.out = null;
                sessionState.err = null;
            }
        }
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            String command = this.getStatement().trim();
            String[] tokens = this.statement.split("\\s");
            String commandArgs = command.substring(tokens[0].length()).trim();
            this.response = this.getCommandProcessor().run(commandArgs);
            int returnCode = this.response.getResponseCode();
            String sqlState = this.response.getSQLState();
            String errorMessage = this.response.getErrorMessage();
            Schema schema = this.response.getSchema();
            if (schema != null) {
                this.setHasResultSet(true);
                this.resultSchema = new TableSchema(schema);
            } else {
                this.setHasResultSet(false);
                this.resultSchema = new TableSchema();
            }
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString());
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
        this.cleanTmpFile();
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        List<String> rows = this.readResults((int)maxRows);
        RowSet rowSet = new RowSet();
        for (String row : rows) {
            rowSet.addRow(this.resultSchema, new String[]{row});
        }
        return rowSet;
    }

    private List<String> readResults(int nLines) throws HiveSQLException {
        if (this.resultReader == null) {
            SessionState sessionState = this.getParentSession().getSessionState();
            File tmp = sessionState.getTmpOutputFile();
            try {
                this.resultReader = new BufferedReader(new FileReader(tmp));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("File " + tmp + " not found. "), (Throwable)e);
                throw new HiveSQLException(e);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < nLines || nLines <= 0; ++i) {
            try {
                String line = this.resultReader.readLine();
                if (line == null) break;
                results.add(line);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)"Reading temp results encountered an exception: ", (Throwable)e);
                throw new HiveSQLException(e);
            }
        }
        return results;
    }

    private void cleanTmpFile() {
        if (this.resultReader != null) {
            SessionState sessionState = this.getParentSession().getSessionState();
            File tmp = sessionState.getTmpOutputFile();
            tmp.delete();
            this.resultReader = null;
        }
    }

    protected CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    protected void setCommandProcessor(CommandProcessor commandProcessor) {
        this.commandProcessor = commandProcessor;
    }
}

