/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable;

import java.util.Arrays;

public class OutputByteBuffer {
    byte[] data;
    int length;

    public OutputByteBuffer(int size) {
        this.data = new byte[size];
    }

    public OutputByteBuffer() {
        this(128);
    }

    public void reset() {
        this.length = 0;
    }

    public final void write(byte b) {
        this.write(b, false);
    }

    public final void write(byte b, boolean invert) {
        if (this.length == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.length++] = invert ? (byte)(0xFF ^ b) : b;
    }

    public final byte[] getData() {
        return this.data;
    }

    public final int getLength() {
        return this.length;
    }

    public String dumpHex() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            int b = this.data[i];
            int v = b < 0 ? 256 + b : b;
            sb.append(String.format("x%02x", v));
        }
        return sb.toString();
    }
}

