/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;

public class LazyTimestamp
extends LazyPrimitive<LazyTimestampObjectInspector, TimestampWritable> {
    private static final Log LOG = LogFactory.getLog(LazyTimestamp.class);
    private static final BigDecimal NANOSECONDS_PERSEC_BD = new BigDecimal(1000000000);
    private static final String nullTimestamp = "NULL";

    public LazyTimestamp(LazyTimestampObjectInspector oi) {
        super(oi);
        this.data = new TimestampWritable();
    }

    public LazyTimestamp(LazyTimestamp copy) {
        super(copy);
        this.data = new TimestampWritable((TimestampWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String s = null;
        try {
            s = new String(bytes.getData(), start, length, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e);
            s = "";
        }
        Timestamp t = null;
        this.isNull = false;
        if (s.compareToIgnoreCase(nullTimestamp) == 0) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
        } else {
            try {
                t = Timestamp.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                try {
                    BigDecimal value = new BigDecimal(s.trim());
                    long valueAbs = value.longValue();
                    t = new Timestamp(valueAbs * 1000L);
                    if (value.scale() > 0) {
                        if (value.scale() > 9) {
                            this.isNull = true;
                            this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
                        } else {
                            value = value.subtract(new BigDecimal(valueAbs));
                            value = value.multiply(NANOSECONDS_PERSEC_BD);
                            t.setNanos(value.intValue());
                        }
                    }
                }
                catch (Exception ex) {
                    this.isNull = true;
                    this.logExceptionMessage(bytes, start, length, "TIMESTAMP");
                }
            }
        }
        ((TimestampWritable)this.data).set(t);
    }

    public static void writeUTF8(OutputStream out, TimestampWritable i) throws IOException {
        if (i == null) {
            out.write(TimestampWritable.nullBytes);
        } else {
            out.write(i.toString().getBytes("US-ASCII"));
        }
    }

    @Override
    public TimestampWritable getWritableObject() {
        return (TimestampWritable)this.data;
    }
}

