/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.serde;

import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.maprdb.json.shims.MapRDBProxy;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OTimestamp;

public final class MapRDBSerDeUtils {
    private MapRDBSerDeUtils() {
    }

    public static Object deserializeField(Object value, TypeInfo valueTypeInfo) {
        Object result = null;
        if (value != null) {
            switch (valueTypeInfo.getCategory()) {
                case LIST: {
                    result = MapRDBSerDeUtils.deserializeList(value, (ListTypeInfo)valueTypeInfo);
                    break;
                }
                case MAP: {
                    result = MapRDBSerDeUtils.deserializeMap(value, (MapTypeInfo)valueTypeInfo);
                    break;
                }
                case PRIMITIVE: {
                    result = MapRDBSerDeUtils.deserializePrimitive(value, (PrimitiveTypeInfo)valueTypeInfo);
                    break;
                }
                case STRUCT: {
                    result = MapRDBSerDeUtils.deserializeStruct(value, (StructTypeInfo)valueTypeInfo);
                    break;
                }
                case UNION: {
                    result = MapRDBSerDeUtils.deserializeUnion(value, (UnionTypeInfo)valueTypeInfo);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Can't deserialize '%s'", value.getClass().getSimpleName()));
                }
            }
        }
        return result;
    }

    public static Document serializeStruct(Object obj, StructObjectInspector soi, List<String> columnNames, Map<String, String> mappings) {
        if (null == obj) {
            return null;
        }
        List fields = soi.getAllStructFieldRefs();
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            StructField sf = (StructField)fields.get(i);
            Object data = soi.getStructFieldData(obj, sf);
            if (null == data) continue;
            jsonMap.put(MapRDBSerDeUtils.getSerializedFieldName(columnNames, i, sf, mappings), MapRDBSerDeUtils.serializeField(data, sf.getFieldObjectInspector(), mappings));
        }
        return MapRDBProxy.newDocument(jsonMap);
    }

    private static Object deserializePrimitive(Object value, PrimitiveTypeInfo valueTypeInfo) {
        switch (valueTypeInfo.getPrimitiveCategory()) {
            case BINARY: {
                return ((Value)value).getBinary().array();
            }
            case BOOLEAN: {
                return ((Value)value).getBoolean();
            }
            case DOUBLE: {
                return ((Value)value).getDouble();
            }
            case FLOAT: {
                return Float.valueOf(((Value)value).getFloat());
            }
            case INT: {
                return ((Value)value).getInt();
            }
            case STRING: {
                return ((Value)value).getString();
            }
            case DATE: {
                return Date.valueOf(((Value)value).getDate().toString());
            }
            case TIMESTAMP: {
                return new Timestamp(((Value)value).getTimestampAsLong());
            }
            case BYTE: {
                return ((Value)value).getByte();
            }
            case SHORT: {
                return ((Value)value).getShort();
            }
            case LONG: {
                return ((Value)value).getLong();
            }
        }
        throw new IllegalArgumentException(String.format("Can't deserialize '%s'", value.getClass().getSimpleName()));
    }

    private static Object deserializeUnion(Object value, UnionTypeInfo valueTypeInfo) {
        return MapRDBSerDeUtils.deserializeField(value, (TypeInfo)valueTypeInfo);
    }

    private static Object deserializeStruct(Object value, StructTypeInfo valueTypeInfo) {
        Document val = (Document)value;
        ArrayList structNames = valueTypeInfo.getAllStructFieldNames();
        ArrayList structTypes = valueTypeInfo.getAllStructFieldTypeInfos();
        ArrayList<Object> struct = new ArrayList<Object>(structNames.size());
        for (int i = 0; i < structNames.size(); ++i) {
            String fieldName = ((String)structNames.get(i)).toLowerCase();
            struct.add(MapRDBSerDeUtils.deserializeField(val.getValue(fieldName), (TypeInfo)structTypes.get(i)));
        }
        return struct;
    }

    private static Object deserializeMap(Object value, MapTypeInfo valueTypeInfo) {
        Map map = ((Value)value).getMap();
        TypeInfo mapValueTypeInfo = valueTypeInfo.getMapValueTypeInfo();
        HashMap result = new HashMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (mapValueTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                result.put(entry.getKey(), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), MapRDBSerDeUtils.deserializeField(entry.getValue(), mapValueTypeInfo));
        }
        return result;
    }

    private static Object deserializeList(Object value, ListTypeInfo valueTypeInfo) {
        List list = ((Value)value).getList();
        TypeInfo listElemTypeInfo = valueTypeInfo.getListElementTypeInfo();
        ArrayList<Object> results = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            if (listElemTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                results.add(i, list.get(i));
                continue;
            }
            results.add(i, MapRDBSerDeUtils.deserializeField(list.get(i), listElemTypeInfo));
        }
        return results;
    }

    private static String getSerializedFieldName(List<String> columnNames, int pos, StructField sf, Map<String, String> mappings) {
        String n = columnNames == null ? sf.getFieldName() : columnNames.get(pos);
        return mappings.containsKey(n) ? mappings.get(n) : n;
    }

    private static Object serializeField(Object o, ObjectInspector oi, Map<String, String> mappings) {
        Object result;
        if (o == null) {
            return null;
        }
        block0 : switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case BINARY: {
                        BytesWritable bw = ((BinaryObjectInspector)poi).getPrimitiveWritableObject(o);
                        result = ByteBuffer.wrap(bw.getBytes());
                        break block0;
                    }
                    case BOOLEAN: {
                        result = ((BooleanObjectInspector)poi).get(o) ? Boolean.TRUE : Boolean.FALSE;
                        break block0;
                    }
                    case INT: {
                        result = ((IntObjectInspector)poi).get(o);
                        break block0;
                    }
                    case BYTE: {
                        result = ((ByteObjectInspector)poi).get(o);
                        break block0;
                    }
                    case SHORT: {
                        result = ((ShortObjectInspector)poi).get(o);
                        break block0;
                    }
                    case LONG: {
                        result = ((LongObjectInspector)poi).get(o);
                        break block0;
                    }
                    case FLOAT: {
                        result = Float.valueOf(((FloatObjectInspector)poi).get(o));
                        break block0;
                    }
                    case DOUBLE: {
                        result = ((DoubleObjectInspector)poi).get(o);
                        break block0;
                    }
                    case STRING: {
                        result = ((StringObjectInspector)poi).getPrimitiveJavaObject(o);
                        break block0;
                    }
                    case DATE: {
                        DateWritable dw = ((DateObjectInspector)poi).getPrimitiveWritableObject(o);
                        result = new ODate(dw.get().getTime());
                        break block0;
                    }
                    case TIMESTAMP: {
                        TimestampWritable tsw = ((TimestampObjectInspector)poi).getPrimitiveWritableObject(o);
                        result = new OTimestamp(tsw.getTimestamp().getTime());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown primitive type: '%s'", poi.getPrimitiveCategory()));
            }
            case LIST: {
                result = MapRDBSerDeUtils.serializeList(o, (ListObjectInspector)oi, mappings);
                break;
            }
            case MAP: {
                result = MapRDBSerDeUtils.serializeMap(o, (MapObjectInspector)oi, mappings);
                break;
            }
            case STRUCT: {
                result = MapRDBSerDeUtils.serializeStruct(o, (StructObjectInspector)oi, null, mappings);
                break;
            }
            case UNION: {
                result = MapRDBSerDeUtils.serializeUnion(o, (UnionObjectInspector)oi, mappings);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type in ObjectInspector!");
            }
        }
        return result;
    }

    private static Object serializeList(Object obj, ListObjectInspector loi, Map<String, String> mappings) {
        if (obj == null) {
            return null;
        }
        List field = loi.getList(obj);
        ArrayList<Object> ar = new ArrayList<Object>();
        for (Object elem : field) {
            ar.add(MapRDBSerDeUtils.serializeField(elem, loi.getListElementObjectInspector(), mappings));
        }
        return ar;
    }

    private static Object serializeUnion(Object obj, UnionObjectInspector oi, Map<String, String> mappings) {
        if (obj == null) {
            return null;
        }
        return MapRDBSerDeUtils.serializeField(obj, (ObjectInspector)oi.getObjectInspectors().get(oi.getTag(obj)), mappings);
    }

    private static Object serializeMap(Object obj, MapObjectInspector moi, Map<String, String> mappings) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map m = moi.getMap(obj);
        for (Map.Entry entry : m.entrySet()) {
            map.put(MapRDBSerDeUtils.serializeField(entry.getKey(), moi.getMapKeyObjectInspector(), mappings).toString(), MapRDBSerDeUtils.serializeField(entry.getValue(), moi.getMapValueObjectInspector(), mappings));
        }
        return map;
    }
}

