/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.serde;

import com.mapr.db.rowcol.DBDocumentImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDeUtils;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBSerDe
extends AbstractSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(MapRDBSerDe.class);
    private List<String> columnNames;
    private StructTypeInfo rowTypeInfo;
    private StructObjectInspector objectInspector;
    private List<Object> row = new ArrayList<Object>();
    private Map<String, String> mappings;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        LOG.info("Initializing SerDe");
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.mappings = new HashMap<String, String>();
        this.mappings.put(tbl.getProperty("maprdb.column.id").toLowerCase(), "_id");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Columns: {}, Types: {}", (Object)columnNameProperty, (Object)columnTypeProperty);
        }
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnNames = MapRDBSerDe.normalizeColNames(this.columnNames);
        ArrayList columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        assert (this.columnNames.size() == columnTypes.size());
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, columnTypes);
        this.objectInspector = (StructObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)this.rowTypeInfo);
    }

    private static List<String> normalizeColNames(List<String> columnNames) {
        ArrayList<String> normalizedColNames = new ArrayList<String>();
        for (String columnName : columnNames) {
            normalizedColNames.add(columnName.toLowerCase());
        }
        return normalizedColNames;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        Document doc = MapRDBSerDeUtils.serializeStruct(obj, (StructObjectInspector)objInspector, this.columnNames, this.mappings);
        return new DocumentWritable(doc);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (!(blob instanceof DocumentWritable)) {
            throw new SerDeException(String.format("%s requires a Writable object, not %s", ((Object)((Object)this)).getClass(), blob.getClass()));
        }
        this.row.clear();
        Document doc = MapRDBSerDe.normalizeKeys(((DocumentWritable)blob).getDocument());
        ArrayList structFieldNames = this.rowTypeInfo.getAllStructFieldNames();
        for (String fieldName : structFieldNames) {
            Object value;
            try {
                TypeInfo fieldTypeInfo = this.rowTypeInfo.getStructFieldTypeInfo(fieldName);
                String mapRMapping = this.mappings.containsKey(fieldName) ? this.mappings.get(fieldName) : fieldName;
                value = MapRDBSerDeUtils.deserializeField(doc.getValue(mapRMapping), fieldTypeInfo);
            }
            catch (Exception e) {
                LOG.warn(String.format("Could not find the appropriate field for name %s", fieldName));
                value = null;
            }
            this.row.add(value);
        }
        return this.row;
    }

    private static Document normalizeKeys(Document doc) {
        DBDocumentImpl normalizedDoc = new DBDocumentImpl();
        for (Map.Entry entry : doc) {
            normalizedDoc.set(((String)entry.getKey()).toLowerCase(), (Value)entry.getValue());
        }
        return normalizedDoc;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return DocumentWritable.class;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

