/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.input;

import com.mapr.db.mapreduce.TableInputFormat;
import com.mapr.db.mapreduce.impl.TableSplit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.maprdb.json.shims.MapRDBJsonSplit;
import org.apache.hadoop.hive.maprdb.json.shims.RecordReaderWrapper;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMapRDBJsonInputFormat
extends TableInputFormat
implements InputFormat<NullWritable, DocumentWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMapRDBJsonInputFormat.class);

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        List splits;
        super.setConf((Configuration)jobConf);
        Job context = new Job((Configuration)jobConf);
        try {
            splits = this.getSplits((JobContext)context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)context);
        org.apache.hadoop.mapred.InputSplit[] inputSplits = null;
        if (splits != null) {
            inputSplits = new org.apache.hadoop.mapred.InputSplit[splits.size()];
            for (int i = 0; i < inputSplits.length; ++i) {
                inputSplits[i] = new MapRDBJsonSplit((TableSplit)splits.get(i), tablePaths[0]);
            }
        }
        if (LOG.isDebugEnabled()) {
            if (inputSplits != null) {
                long[] splitSizes = new long[inputSplits.length];
                for (int i = 0; i < inputSplits.length; ++i) {
                    splitSizes[i] = inputSplits[i].getLength();
                }
                LOG.debug("getSplits() => split number: {}, split size: {}", (Object)inputSplits.length, (Object)Arrays.toString(splitSizes));
            } else {
                LOG.debug("getSplits() => 0 splits");
            }
        }
        return inputSplits;
    }

    public org.apache.hadoop.mapred.RecordReader<NullWritable, DocumentWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        MapRDBJsonSplit fileSplit = (MapRDBJsonSplit)split;
        TableSplit tableSplit = fileSplit.getTableSplit();
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext((Configuration)jobConf, (Progressable)reporter);
        try {
            this.setConf(tac.getConfiguration());
            RecordReader recordReader = this.createRecordReader((InputSplit)tableSplit, tac);
            recordReader.initialize((InputSplit)fileSplit, tac);
            return new RecordReaderWrapper(recordReader);
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to initialize RecordReader", e);
        }
    }
}

