/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.WorkerException;

class WarehousePartitionHelper
implements PartitionHelper {
    private final Warehouse warehouse;
    private final Path tablePath;
    private final LinkedHashMap<String, String> partitions;
    private final List<String> partitionColumns;

    WarehousePartitionHelper(Configuration configuration, Path tablePath, List<String> partitionColumns) throws MetaException {
        this.tablePath = tablePath;
        this.partitionColumns = partitionColumns;
        this.partitions = new LinkedHashMap(partitionColumns.size());
        for (String partitionColumn : partitionColumns) {
            this.partitions.put(partitionColumn, null);
        }
        this.warehouse = new Warehouse(configuration);
    }

    @Override
    public Path getPathForPartition(List<String> partitionValues) throws WorkerException {
        if (partitionValues.size() != this.partitionColumns.size()) {
            throw new IllegalArgumentException("Incorrect number of partition values. columns=" + this.partitionColumns + ",values=" + partitionValues);
        }
        if (this.partitionColumns.isEmpty()) {
            return this.tablePath;
        }
        for (int columnIndex = 0; columnIndex < partitionValues.size(); ++columnIndex) {
            String partitionColumn = this.partitionColumns.get(columnIndex);
            String partitionValue = partitionValues.get(columnIndex);
            this.partitions.put(partitionColumn, partitionValue);
        }
        try {
            return this.warehouse.getPartitionPath(this.tablePath, this.partitions);
        }
        catch (MetaException e) {
            throw new WorkerException("Unable to determine partition path. tablePath=" + this.tablePath + ",partition=" + partitionValues, e);
        }
    }

    @Override
    public void createPartitionIfNotExists(List<String> newPartitionValues) throws WorkerException {
        throw new UnsupportedOperationException("You require a connection to the meta store to do this.");
    }

    @Override
    public void close() throws IOException {
    }
}

