/*
 * Decompiled with CFR 0.152.
 */
package io.druid.math.expr;

import com.google.common.math.LongMath;
import io.druid.math.expr.BinaryOpExprBase;
import io.druid.math.expr.Expr;
import java.util.Map;

class BinPowExpr
extends BinaryOpExprBase {
    BinPowExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    public Number eval(Map<String, Number> bindings) {
        Number rightVal;
        Number leftVal = this.left.eval(bindings);
        if (this.isLong(leftVal, rightVal = this.right.eval(bindings))) {
            return LongMath.pow((long)leftVal.longValue(), (int)rightVal.intValue());
        }
        return Math.pow(leftVal.doubleValue(), rightVal.doubleValue());
    }
}

