/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.guava.DefaultingHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CountingMap<K>
extends DefaultingHashMap<K, AtomicLong> {
    public CountingMap() {
        super((Supplier)new Supplier<AtomicLong>(){

            public AtomicLong get() {
                return new AtomicLong(0L);
            }
        });
    }

    public long add(K key, long value) {
        return ((AtomicLong)this.get(key)).addAndGet(value);
    }

    public Map<K, Long> snapshot() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.entrySet()) {
            builder.put(entry.getKey(), (Object)((AtomicLong)entry.getValue()).get());
        }
        return builder.build();
    }
}

