/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.fs.FSStatsAggregator;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;
    ExplainConfiguration config = new ExplainConfiguration();

    public ExplainSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        FetchTask fetchTask;
        int childCount = ast.getChildCount();
        for (int i = 1; i < childCount; ++i) {
            int explainOptions = ast.getChild(i).getType();
            if (explainOptions == 130) {
                this.config.setFormatted(true);
                continue;
            }
            if (explainOptions == 115) {
                this.config.setExtended(true);
                continue;
            }
            if (explainOptions == 90) {
                this.config.setDependency(true);
                continue;
            }
            if (explainOptions == 176) {
                this.config.setLogical(true);
                continue;
            }
            if (explainOptions == 39) {
                this.config.setAuthorize(true);
                continue;
            }
            if (explainOptions == 32) {
                this.config.setAnalyze(ExplainConfiguration.AnalyzeState.RUNNING);
                this.config.setExplainRootPath(this.ctx.getMRTmpPath());
                continue;
            }
            if (explainOptions == 318) {
                this.config.setVectorization(true);
                if (i + 1 >= childCount) continue;
                int vectorizationOption = ast.getChild(i + 1).getType();
                if (vectorizationOption == 832) {
                    this.config.setVectorizationOnly(true);
                    if (++i + 1 >= childCount) break;
                    vectorizationOption = ast.getChild(i + 1).getType();
                }
                if (vectorizationOption == 948) {
                    this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.SUMMARY);
                    ++i;
                    continue;
                }
                if (vectorizationOption == 833) {
                    this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.OPERATOR);
                    ++i;
                    continue;
                }
                if (vectorizationOption == 757) {
                    this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.EXPRESSION);
                    ++i;
                    continue;
                }
                if (vectorizationOption != 737) continue;
                this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.DETAIL);
                ++i;
                continue;
            }
            if (explainOptions != 38) continue;
            this.config.setAst(true);
        }
        this.ctx.setExplainConfig(this.config);
        ASTNode input = (ASTNode)ast.getChild(0);
        if (this.config.getAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            String query = this.ctx.getTokenRewriteStream().toString(input.getTokenStartIndex(), input.getTokenStopIndex());
            this.LOG.info("Explain analyze (running phase) for query " + query);
            Context runCtx = null;
            try {
                runCtx = new Context(this.conf);
                runCtx.setExplainConfig(this.config);
                Driver driver = new Driver(this.conf, runCtx);
                CommandProcessorResponse ret = driver.run(query);
                if (ret.getResponseCode() == 0) {
                    while (driver.getResults(new ArrayList())) {
                    }
                } else {
                    throw new SemanticException(ret.getErrorMessage(), ret.getException());
                }
                this.config.setOpIdToRuntimeNumRows(this.aggregateStats(this.config.getExplainRootPath()));
            }
            catch (IOException e1) {
                throw new SemanticException(e1);
            }
            catch (CommandNeedRetryException e) {
                throw new SemanticException(e);
            }
            this.ctx.resetOpContext();
            this.ctx.resetStream();
            TaskFactory.resetId();
            this.LOG.info("Explain analyze (analyzing phase) for query " + query);
            this.config.setAnalyze(ExplainConfiguration.AnalyzeState.ANALYZING);
        }
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        if (!HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_IN_TEST, false)) {
            this.inputs = sem.getInputs();
            this.outputs = sem.getOutputs();
        }
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        List<Task<Serializable>> tasks = sem.getAllRootTasks();
        if (tasks == null) {
            tasks = Collections.emptyList();
        }
        if ((fetchTask = sem.getFetchTask()) != null) {
            ((FetchWork)fetchTask.getWork()).initializeForFetch(this.ctx.getOpContext());
        }
        ParseContext pCtx = null;
        if (sem instanceof SemanticAnalyzer) {
            pCtx = ((SemanticAnalyzer)sem).getParseContext();
        }
        this.config.setUserLevelExplain(!this.config.isExtended() && !this.config.isFormatted() && !this.config.isDependency() && !this.config.isLogical() && !this.config.isAuthorize() && HiveConf.getBoolVar(this.ctx.getConf(), HiveConf.ConfVars.HIVE_EXPLAIN_USER) && HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez"));
        ExplainWork work = new ExplainWork(this.ctx.getResFile(), pCtx, tasks, fetchTask, input, sem, this.config, this.ctx.getCboInfo());
        work.setAppendTaskType(HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEEXPLAINDEPENDENCYAPPENDTASKTYPES));
        ExplainTask explTask = (ExplainTask)TaskFactory.get(work, this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    private Map<String, Long> aggregateStats(Path localTmpPath) {
        HashMap<String, Long> opIdToRuntimeNumRows = new HashMap<String, Long>();
        FileStatus[] statuses = null;
        try {
            FileSystem fs = localTmpPath.getFileSystem((Configuration)this.conf);
            statuses = fs.listStatus(localTmpPath, FileUtils.HIDDEN_FILES_PATH_FILTER);
        }
        catch (IOException e) {
            this.LOG.warn(e.toString());
        }
        if (statuses != null) {
            for (FileStatus status : statuses) {
                if (!status.isDir()) continue;
                StatsCollectionContext scc = new StatsCollectionContext(this.conf);
                String[] names = status.getPath().toString().split("/");
                String opId = names[names.length - 1];
                scc.setStatsTmpDir(status.getPath().toString());
                FSStatsAggregator statsAggregator = new FSStatsAggregator();
                if (!statsAggregator.connect(scc)) {
                    opIdToRuntimeNumRows.put(opId, -1L);
                } else {
                    String value = statsAggregator.aggregateStats("", "runTimeNumRows");
                    opIdToRuntimeNumRows.put(opId, Long.parseLong(value));
                }
                if (statsAggregator == null) continue;
                statsAggregator.closeConnection(scc);
            }
        }
        return opIdToRuntimeNumRows;
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }

    @Override
    public boolean skipAuthorization() {
        List<Task<? extends Serializable>> rootTasks = this.getRootTasks();
        assert (rootTasks != null && rootTasks.size() == 1);
        Task<? extends Serializable> task = rootTasks.get(0);
        return task instanceof ExplainTask && ((ExplainWork)((ExplainTask)task).getWork()).isAuthorize();
    }
}

