/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.HdfsUtils;
import org.apache.hadoop.hive.ql.io.TableUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcidUtils {
    public static final String CONF_ACID_KEY = "hive.doing.acid";
    public static final String BASE_PREFIX = "base_";
    public static final PathFilter baseFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BASE_PREFIX);
        }
    };
    public static final String DELTA_PREFIX = "delta_";
    public static final String DELETE_DELTA_PREFIX = "delete_delta_";
    public static final String DELTA_SIDE_FILE_SUFFIX = "_flush_length";
    public static final PathFilter deltaFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELTA_PREFIX);
        }
    };
    public static final PathFilter deleteEventDeltaDirFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.DELETE_DELTA_PREFIX);
        }
    };
    public static final String BUCKET_PREFIX = "bucket_";
    public static final PathFilter bucketFileFilter = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith(AcidUtils.BUCKET_PREFIX) && !path.getName().endsWith(AcidUtils.DELTA_SIDE_FILE_SUFFIX);
        }
    };
    public static final String BUCKET_DIGITS = "%05d";
    public static final String LEGACY_FILE_BUCKET_DIGITS = "%06d";
    public static final String DELTA_DIGITS = "%07d";
    public static final String STATEMENT_DIGITS = "%04d";
    public static final int MAX_STATEMENTS_PER_TXN = 10000;
    public static final Pattern BUCKET_DIGIT_PATTERN = Pattern.compile("[0-9]{5}$");
    public static final Pattern LEGACY_BUCKET_DIGIT_PATTERN = Pattern.compile("^[0-9]{6}");
    public static final PathFilter originalBucketFilter = new PathFilter(){

        public boolean accept(Path path) {
            return ORIGINAL_PATTERN.matcher(path.getName()).matches();
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(AcidUtils.class);
    private static final Pattern ORIGINAL_PATTERN = Pattern.compile("[0-9]+_[0-9]+");
    public static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();

    private AcidUtils() {
    }

    public static Path createBucketFile(Path subdir, int bucket) {
        return new Path(subdir, BUCKET_PREFIX + String.format(BUCKET_DIGITS, bucket));
    }

    public static String deltaSubdir(long min, long max) {
        return DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    public static String deltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    @VisibleForTesting
    static String deleteDeltaSubdir(long min, long max) {
        return DELETE_DELTA_PREFIX + String.format(DELTA_DIGITS, min) + "_" + String.format(DELTA_DIGITS, max);
    }

    @VisibleForTesting
    static String deleteDeltaSubdir(long min, long max, int statementId) {
        return AcidUtils.deleteDeltaSubdir(min, max) + "_" + String.format(STATEMENT_DIGITS, statementId);
    }

    public static String baseDir(long txnId) {
        return BASE_PREFIX + String.format(DELTA_DIGITS, txnId);
    }

    public static Path createFilename(Path directory, AcidOutputFormat.Options options) {
        if (options.getOldStyle()) {
            return new Path(directory, String.format(LEGACY_FILE_BUCKET_DIGITS, options.getBucket()) + "_0");
        }
        String subdir = options.isWritingBase() ? BASE_PREFIX + String.format(DELTA_DIGITS, options.getMaximumTransactionId()) : (options.getStatementId() == -1 ? (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId()) : AcidUtils.deltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId())) : (options.isWritingDeleteDelta() ? AcidUtils.deleteDeltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId(), options.getStatementId()) : AcidUtils.deltaSubdir(options.getMinimumTransactionId(), options.getMaximumTransactionId(), options.getStatementId())));
        return AcidUtils.createBucketFile(new Path(directory, subdir), options.getBucket());
    }

    static long parseBase(Path path) {
        String filename = path.getName();
        if (filename.startsWith(BASE_PREFIX)) {
            return Long.parseLong(filename.substring(BASE_PREFIX.length()));
        }
        throw new IllegalArgumentException(filename + " does not start with " + BASE_PREFIX);
    }

    public static AcidOutputFormat.Options parseBaseOrDeltaBucketFilename(Path bucketFile, Configuration conf) {
        AcidOutputFormat.Options result = new AcidOutputFormat.Options(conf);
        String filename = bucketFile.getName();
        if (ORIGINAL_PATTERN.matcher(filename).matches()) {
            int bucket = Integer.parseInt(filename.substring(0, filename.indexOf(95)));
            result.setOldStyle(true).minimumTransactionId(0L).maximumTransactionId(0L).bucket(bucket).writingBase(true);
        } else if (filename.startsWith(BUCKET_PREFIX)) {
            int bucket = Integer.parseInt(filename.substring(filename.indexOf(95) + 1));
            if (bucketFile.getParent().getName().startsWith(BASE_PREFIX)) {
                result.setOldStyle(false).minimumTransactionId(0L).maximumTransactionId(AcidUtils.parseBase(bucketFile.getParent())).bucket(bucket).writingBase(true);
            } else if (bucketFile.getParent().getName().startsWith(DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELTA_PREFIX);
                result.setOldStyle(false).minimumTransactionId(parsedDelta.minTransaction).maximumTransactionId(parsedDelta.maxTransaction).bucket(bucket);
            } else if (bucketFile.getParent().getName().startsWith(DELETE_DELTA_PREFIX)) {
                ParsedDelta parsedDelta = AcidUtils.parsedDelta(bucketFile.getParent(), DELETE_DELTA_PREFIX);
                result.setOldStyle(false).minimumTransactionId(parsedDelta.minTransaction).maximumTransactionId(parsedDelta.maxTransaction).bucket(bucket);
            }
        } else {
            result.setOldStyle(true).bucket(-1).minimumTransactionId(0L).maximumTransactionId(0L);
        }
        return result;
    }

    public static DataOperationType toDataOperationType(Operation op) {
        switch (op) {
            case NOT_ACID: {
                return DataOperationType.UNSET;
            }
            case INSERT: {
                return DataOperationType.INSERT;
            }
            case UPDATE: {
                return DataOperationType.UPDATE;
            }
            case DELETE: {
                return DataOperationType.DELETE;
            }
        }
        throw new IllegalArgumentException("Unexpected Operation: " + (Object)((Object)op));
    }

    public static Path[] getPaths(List<ParsedDelta> deltas) {
        Path[] result = new Path[deltas.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = deltas.get(i).getPath();
        }
        return result;
    }

    public static List<AcidInputFormat.DeltaMetaData> serializeDeltas(List<ParsedDelta> deltas) {
        ArrayList<AcidInputFormat.DeltaMetaData> result = new ArrayList<AcidInputFormat.DeltaMetaData>(deltas.size());
        AcidInputFormat.DeltaMetaData last = null;
        for (ParsedDelta parsedDelta : deltas) {
            if (last != null && last.getMinTxnId() == parsedDelta.getMinTransaction() && last.getMaxTxnId() == parsedDelta.getMaxTransaction()) {
                last.getStmtIds().add(parsedDelta.getStatementId());
                continue;
            }
            last = new AcidInputFormat.DeltaMetaData(parsedDelta.getMinTransaction(), parsedDelta.getMaxTransaction(), new ArrayList<Integer>());
            result.add(last);
            if (parsedDelta.statementId < 0) continue;
            last.getStmtIds().add(parsedDelta.getStatementId());
        }
        return result;
    }

    public static Path[] deserializeDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deltas) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>(deltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deltas) {
            if (dmd.getStmtIds().isEmpty()) {
                results.add(new Path(root, AcidUtils.deltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId())));
                continue;
            }
            for (Integer stmtId : dmd.getStmtIds()) {
                results.add(new Path(root, AcidUtils.deltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId(), stmtId)));
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    public static Path[] deserializeDeleteDeltas(Path root, List<AcidInputFormat.DeltaMetaData> deleteDeltas) throws IOException {
        ArrayList<Path> results = new ArrayList<Path>(deleteDeltas.size());
        for (AcidInputFormat.DeltaMetaData dmd : deleteDeltas) {
            if (dmd.getStmtIds().isEmpty()) {
                results.add(new Path(root, AcidUtils.deleteDeltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId())));
                continue;
            }
            for (Integer stmtId : dmd.getStmtIds()) {
                results.add(new Path(root, AcidUtils.deleteDeltaSubdir(dmd.getMinTxnId(), dmd.getMaxTxnId(), stmtId)));
            }
        }
        return results.toArray(new Path[results.size()]);
    }

    public static ParsedDelta parsedDelta(Path deltaDir) {
        String deltaDirName = deltaDir.getName();
        if (deltaDirName.startsWith(DELETE_DELTA_PREFIX)) {
            return AcidUtils.parsedDelta(deltaDir, DELETE_DELTA_PREFIX);
        }
        return AcidUtils.parsedDelta(deltaDir, DELTA_PREFIX);
    }

    private static ParsedDelta parseDelta(FileStatus path, String deltaPrefix) {
        ParsedDelta p = AcidUtils.parsedDelta(path.getPath(), deltaPrefix);
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        return new ParsedDelta(p.getMinTransaction(), p.getMaxTransaction(), path, p.statementId, isDeleteDelta);
    }

    public static ParsedDelta parsedDelta(Path deltaDir, String deltaPrefix) {
        String filename = deltaDir.getName();
        boolean isDeleteDelta = deltaPrefix.equals(DELETE_DELTA_PREFIX);
        if (filename.startsWith(deltaPrefix)) {
            long max;
            String rest = filename.substring(deltaPrefix.length());
            int split = rest.indexOf(95);
            int split2 = rest.indexOf(95, split + 1);
            long min = Long.parseLong(rest.substring(0, split));
            long l = max = split2 == -1 ? Long.parseLong(rest.substring(split + 1)) : Long.parseLong(rest.substring(split + 1, split2));
            if (split2 == -1) {
                return new ParsedDelta(min, max, null, isDeleteDelta);
            }
            int statementId = Integer.parseInt(rest.substring(split2 + 1));
            return new ParsedDelta(min, max, null, statementId, isDeleteDelta);
        }
        throw new IllegalArgumentException(deltaDir + " does not start with " + deltaPrefix);
    }

    public static boolean isAcid(Path directory, Configuration conf) throws IOException {
        FileSystem fs = directory.getFileSystem(conf);
        for (FileStatus file : fs.listStatus(directory)) {
            String filename = file.getPath().getName();
            if (!filename.startsWith(BASE_PREFIX) && !filename.startsWith(DELTA_PREFIX) && !filename.startsWith(DELETE_DELTA_PREFIX) || !file.isDir()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList) throws IOException {
        return AcidUtils.getAcidState(directory, conf, txnList, false, false);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList, boolean useFileIds, boolean ignoreEmptyFiles) throws IOException {
        return AcidUtils.getAcidState(directory, conf, txnList, Ref.from(useFileIds), ignoreEmptyFiles);
    }

    public static Directory getAcidState(Path directory, Configuration conf, ValidTxnList txnList, Ref<Boolean> useFileIds, boolean ignoreEmptyFiles) throws IOException {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId;
        ArrayList<FileStatus> obsolete;
        ArrayList<FileStatus> originalDirectories;
        ArrayList<ParsedDelta> working;
        ArrayList<ParsedDelta> deltas;
        FileSystem fs;
        block17: {
            fs = directory.getFileSystem(conf);
            deltas = new ArrayList<ParsedDelta>();
            working = new ArrayList<ParsedDelta>();
            originalDirectories = new ArrayList<FileStatus>();
            obsolete = new ArrayList<FileStatus>();
            childrenWithId = null;
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    childrenWithId = SHIMS.listLocatedHdfsStatus(fs, directory, hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block17;
                    useFileIds.value = false;
                }
            }
        }
        TxnBase bestBase = new TxnBase();
        final ArrayList<HadoopShims.HdfsFileStatusWithId> original = new ArrayList<HadoopShims.HdfsFileStatusWithId>();
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : childrenWithId) {
                AcidUtils.getChildState(hdfsFileStatusWithId.getFileStatus(), hdfsFileStatusWithId, txnList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles);
            }
        } else {
            List<FileStatus> children = HdfsUtils.listLocatedStatus(fs, directory, hiddenFileFilter);
            for (FileStatus child : children) {
                AcidUtils.getChildState(child, null, txnList, working, originalDirectories, original, obsolete, bestBase, ignoreEmptyFiles);
            }
        }
        if (bestBase.status != null) {
            for (HadoopShims.HdfsFileStatusWithId hdfsFileStatusWithId : original) {
                obsolete.add(hdfsFileStatusWithId.getFileStatus());
            }
            obsolete.addAll(originalDirectories);
            original.clear();
            originalDirectories.clear();
        } else {
            for (FileStatus fileStatus : originalDirectories) {
                AcidUtils.findOriginals(fs, fileStatus, original, useFileIds);
            }
        }
        Collections.sort(working);
        long current = bestBase.txn;
        int lastStmtId = -1;
        ParsedDelta prev = null;
        for (ParsedDelta next : working) {
            if (next.maxTransaction > current) {
                if (txnList.isTxnRangeValid(current + 1L, next.maxTransaction) == ValidTxnList.RangeResponse.NONE) continue;
                deltas.add(next);
                current = next.maxTransaction;
                lastStmtId = next.statementId;
                prev = next;
                continue;
            }
            if (next.maxTransaction == current && lastStmtId >= 0) {
                deltas.add(next);
                prev = next;
                continue;
            }
            if (prev != null && next.maxTransaction == prev.maxTransaction && next.minTransaction == prev.minTransaction && next.statementId == prev.statementId) {
                deltas.add(next);
                prev = next;
                continue;
            }
            obsolete.add(next.path);
        }
        if (bestBase.oldestBase != null && bestBase.status == null) {
            long[] exceptions = txnList.getInvalidTransactions();
            String minOpenTxn = exceptions != null && exceptions.length > 0 ? Long.toString(exceptions[0]) : "x";
            throw new IOException(ErrorMsg.ACID_NOT_ENOUGH_HISTORY.format(Long.toString(txnList.getHighWatermark()), minOpenTxn, bestBase.oldestBase.toString()));
        }
        final Path base = bestBase.status == null ? null : bestBase.status.getPath();
        LOG.debug("in directory " + directory.toUri().toString() + " base = " + base + " deltas = " + deltas.size());
        return new Directory(){

            @Override
            public Path getBaseDirectory() {
                return base;
            }

            @Override
            public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles() {
                return original;
            }

            @Override
            public List<ParsedDelta> getCurrentDirectories() {
                return deltas;
            }

            @Override
            public List<FileStatus> getObsolete() {
                return obsolete;
            }
        };
    }

    private static boolean isValidBase(long baseTxnId, ValidTxnList txnList) {
        if (baseTxnId == Long.MIN_VALUE) {
            return true;
        }
        return txnList.isValidBase(baseTxnId);
    }

    private static void getChildState(FileStatus child, HadoopShims.HdfsFileStatusWithId childWithId, ValidTxnList txnList, List<ParsedDelta> working, List<FileStatus> originalDirectories, List<HadoopShims.HdfsFileStatusWithId> original, List<FileStatus> obsolete, TxnBase bestBase, boolean ignoreEmptyFiles) throws IOException {
        Path p = child.getPath();
        String fn = p.getName();
        if (fn.startsWith(BASE_PREFIX) && child.isDir()) {
            long txn = AcidUtils.parseBase(p);
            if (bestBase.oldestBaseTxnId > txn) {
                bestBase.oldestBase = p;
                bestBase.oldestBaseTxnId = txn;
            }
            if (bestBase.status == null) {
                if (AcidUtils.isValidBase(txn, txnList)) {
                    bestBase.status = child;
                    bestBase.txn = txn;
                }
            } else if (bestBase.txn < txn) {
                if (AcidUtils.isValidBase(txn, txnList)) {
                    obsolete.add(bestBase.status);
                    bestBase.status = child;
                    bestBase.txn = txn;
                }
            } else {
                obsolete.add(child);
            }
        } else if ((fn.startsWith(DELTA_PREFIX) || fn.startsWith(DELETE_DELTA_PREFIX)) && child.isDir()) {
            String deltaPrefix = fn.startsWith(DELTA_PREFIX) ? DELTA_PREFIX : DELETE_DELTA_PREFIX;
            ParsedDelta delta = AcidUtils.parseDelta(child, deltaPrefix);
            if (txnList.isTxnRangeValid(delta.minTransaction, delta.maxTransaction) != ValidTxnList.RangeResponse.NONE) {
                working.add(delta);
            }
        } else if (child.isDir()) {
            originalDirectories.add(child);
        } else if (!ignoreEmptyFiles || child.getLen() != 0L) {
            original.add(AcidUtils.createOriginalObj(childWithId, child));
        }
    }

    public static HadoopShims.HdfsFileStatusWithId createOriginalObj(HadoopShims.HdfsFileStatusWithId childWithId, FileStatus child) {
        return childWithId != null ? childWithId : new HdfsFileStatusWithoutId(child);
    }

    private static void findOriginals(FileSystem fs, FileStatus stat, List<HadoopShims.HdfsFileStatusWithId> original, Ref<Boolean> useFileIds) throws IOException {
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId;
        block11: {
            assert (stat.isDir());
            childrenWithId = null;
            Boolean val = (Boolean)useFileIds.value;
            if (val == null || val.booleanValue()) {
                try {
                    childrenWithId = SHIMS.listLocatedHdfsStatus(fs, stat.getPath(), hiddenFileFilter);
                    if (val == null) {
                        useFileIds.value = true;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Failed to get files with ID; using regular API: " + t.getMessage());
                    if (val != null || !(t instanceof UnsupportedOperationException)) break block11;
                    useFileIds.value = false;
                }
            }
        }
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId child : childrenWithId) {
                if (child.getFileStatus().isDir()) {
                    AcidUtils.findOriginals(fs, child.getFileStatus(), original, useFileIds);
                    continue;
                }
                original.add(child);
            }
        } else {
            List<FileStatus> children = HdfsUtils.listLocatedStatus(fs, stat.getPath(), hiddenFileFilter);
            for (FileStatus child : children) {
                if (child.isDir()) {
                    AcidUtils.findOriginals(fs, child, original, useFileIds);
                    continue;
                }
                original.add(AcidUtils.createOriginalObj(null, child));
            }
        }
    }

    public static boolean isTablePropertyTransactional(Properties props) {
        String resultStr = props.getProperty("transactional");
        if (resultStr == null) {
            resultStr = props.getProperty("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional");
        if (resultStr == null) {
            resultStr = parameters.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static boolean isTablePropertyTransactional(Configuration conf) {
        String resultStr = conf.get("transactional");
        if (resultStr == null) {
            resultStr = conf.get("transactional".toUpperCase());
        }
        return resultStr != null && resultStr.equalsIgnoreCase("true");
    }

    public static void setTransactionalTableScan(Map<String, String> parameters, boolean isAcidTable) {
        parameters.put(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, Boolean.toString(isAcidTable));
    }

    public static void setTransactionalTableScan(Configuration conf, boolean isAcidTable) {
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN, isAcidTable);
    }

    public static boolean isAcidTable(Table table) {
        if (table == null) {
            return false;
        }
        String tableIsTransactional = table.getProperty("transactional");
        if (tableIsTransactional == null) {
            tableIsTransactional = table.getProperty("transactional".toUpperCase());
        }
        return tableIsTransactional != null && tableIsTransactional.equalsIgnoreCase("true");
    }

    public static void setAcidOperationalProperties(Configuration conf, AcidOperationalProperties properties) {
        if (properties != null) {
            HiveConf.setIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES, properties.toInt());
        }
    }

    public static void setAcidOperationalProperties(Map<String, String> parameters, AcidOperationalProperties properties) {
        if (properties != null) {
            parameters.put(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, properties.toString());
        }
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Table table) {
        String transactionalProperties = table.getProperty("transactional_properties");
        if (transactionalProperties == null) {
            return AcidOperationalProperties.getLegacy();
        }
        return AcidOperationalProperties.parseString(transactionalProperties);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Configuration conf) {
        return AcidOperationalProperties.parseInt(HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES));
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Properties props) {
        String resultStr = props.getProperty("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getLegacy();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static AcidOperationalProperties getAcidOperationalProperties(Map<String, String> parameters) {
        String resultStr = parameters.get("transactional_properties");
        if (resultStr == null) {
            return AcidOperationalProperties.getLegacy();
        }
        return AcidOperationalProperties.parseString(resultStr);
    }

    public static boolean isAcidTable(ASTNode tree, HiveConf conf) throws SemanticException {
        return AcidUtils.isAcidTable(TableUtils.findTable(tree, conf));
    }

    private static class HdfsFileStatusWithoutId
    implements HadoopShims.HdfsFileStatusWithId {
        private final FileStatus fs;

        public HdfsFileStatusWithoutId(FileStatus fs) {
            this.fs = fs;
        }

        @Override
        public FileStatus getFileStatus() {
            return this.fs;
        }

        @Override
        public Long getFileId() {
            return null;
        }
    }

    private static class TxnBase {
        private FileStatus status;
        private long txn = 0L;
        private long oldestBaseTxnId = Long.MAX_VALUE;
        private Path oldestBase = null;

        private TxnBase() {
        }
    }

    public static class ParsedDelta
    implements Comparable<ParsedDelta> {
        private final long minTransaction;
        private final long maxTransaction;
        private final FileStatus path;
        private final int statementId;
        private final boolean isDeleteDelta;

        ParsedDelta(long min, long max, FileStatus path, boolean isDeleteDelta) {
            this(min, max, path, -1, isDeleteDelta);
        }

        ParsedDelta(long min, long max, FileStatus path, int statementId, boolean isDeleteDelta) {
            this.minTransaction = min;
            this.maxTransaction = max;
            this.path = path;
            this.statementId = statementId;
            this.isDeleteDelta = isDeleteDelta;
        }

        public long getMinTransaction() {
            return this.minTransaction;
        }

        public long getMaxTransaction() {
            return this.maxTransaction;
        }

        public Path getPath() {
            return this.path.getPath();
        }

        public int getStatementId() {
            return this.statementId == -1 ? 0 : this.statementId;
        }

        public boolean isDeleteDelta() {
            return this.isDeleteDelta;
        }

        @Override
        public int compareTo(ParsedDelta parsedDelta) {
            if (this.minTransaction != parsedDelta.minTransaction) {
                if (this.minTransaction < parsedDelta.minTransaction) {
                    return -1;
                }
                return 1;
            }
            if (this.maxTransaction != parsedDelta.maxTransaction) {
                if (this.maxTransaction < parsedDelta.maxTransaction) {
                    return 1;
                }
                return -1;
            }
            if (this.statementId != parsedDelta.statementId) {
                if (this.statementId < parsedDelta.statementId) {
                    return -1;
                }
                return 1;
            }
            return this.path.compareTo((Object)parsedDelta.path);
        }
    }

    public static interface Directory {
        public Path getBaseDirectory();

        public List<HadoopShims.HdfsFileStatusWithId> getOriginalFiles();

        public List<ParsedDelta> getCurrentDirectories();

        public List<FileStatus> getObsolete();
    }

    public static class AcidOperationalProperties {
        private int description = 0;
        public static final int SPLIT_UPDATE_BIT = 1;
        public static final String SPLIT_UPDATE_STRING = "split_update";
        public static final int HASH_BASED_MERGE_BIT = 2;
        public static final String HASH_BASED_MERGE_STRING = "hash_merge";
        public static final String DEFAULT_VALUE_STRING = "default";
        public static final String LEGACY_VALUE_STRING = "legacy";

        private AcidOperationalProperties() {
        }

        public static AcidOperationalProperties getLegacy() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            return obj;
        }

        public static AcidOperationalProperties getDefault() {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            obj.setSplitUpdate(true);
            obj.setHashBasedMerge(false);
            return obj;
        }

        public static AcidOperationalProperties parseString(String propertiesStr) {
            String[] options;
            if (propertiesStr == null) {
                return AcidOperationalProperties.getLegacy();
            }
            if (propertiesStr.equalsIgnoreCase(DEFAULT_VALUE_STRING)) {
                return AcidOperationalProperties.getDefault();
            }
            if (propertiesStr.equalsIgnoreCase(LEGACY_VALUE_STRING)) {
                return AcidOperationalProperties.getLegacy();
            }
            AcidOperationalProperties obj = new AcidOperationalProperties();
            block8: for (String option : options = propertiesStr.split("\\|")) {
                if (option.trim().length() == 0) continue;
                switch (option) {
                    case "split_update": {
                        obj.setSplitUpdate(true);
                        continue block8;
                    }
                    case "hash_merge": {
                        obj.setHashBasedMerge(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value " + option + " for ACID operational properties!");
                    }
                }
            }
            return obj;
        }

        public static AcidOperationalProperties parseInt(int properties) {
            AcidOperationalProperties obj = new AcidOperationalProperties();
            if ((properties & 1) > 0) {
                obj.setSplitUpdate(true);
            }
            if ((properties & 2) > 0) {
                obj.setHashBasedMerge(true);
            }
            return obj;
        }

        public AcidOperationalProperties setSplitUpdate(boolean isSplitUpdate) {
            this.description = isSplitUpdate ? this.description | 1 : this.description & 0xFFFFFFFE;
            return this;
        }

        public AcidOperationalProperties setHashBasedMerge(boolean isHashBasedMerge) {
            this.description = isHashBasedMerge ? this.description | 2 : this.description & 0xFFFFFFFD;
            return this;
        }

        public boolean isSplitUpdate() {
            return (this.description & 1) > 0;
        }

        public boolean isHashBasedMerge() {
            return (this.description & 2) > 0;
        }

        public int toInt() {
            return this.description;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            if (this.isSplitUpdate()) {
                str.append("|split_update");
            }
            if (this.isHashBasedMerge()) {
                str.append("|hash_merge");
            }
            return str.toString();
        }
    }

    public static class AcidBaseFileInfo {
        private final HadoopShims.HdfsFileStatusWithId fileId;
        private final AcidBaseFileType acidBaseFileType;

        public AcidBaseFileInfo(HadoopShims.HdfsFileStatusWithId fileId, AcidBaseFileType acidBaseFileType) {
            this.fileId = fileId;
            this.acidBaseFileType = acidBaseFileType;
        }

        public boolean isCompactedBase() {
            return this.acidBaseFileType == AcidBaseFileType.COMPACTED_BASE;
        }

        public boolean isOriginal() {
            return this.acidBaseFileType == AcidBaseFileType.ORIGINAL_BASE;
        }

        public boolean isInsertDelta() {
            return this.acidBaseFileType == AcidBaseFileType.INSERT_DELTA;
        }

        public HadoopShims.HdfsFileStatusWithId getHdfsFileStatusWithId() {
            return this.fileId;
        }
    }

    public static enum AcidBaseFileType {
        COMPACTED_BASE,
        ORIGINAL_BASE,
        INSERT_DELTA;

    }

    public static enum Operation {
        NOT_ACID,
        INSERT,
        UPDATE,
        DELETE;

    }
}

