/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.MapRDbJsonFetchByIdWork;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.mapred.JobConf;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDbJsonFetchByIdOperator
extends FetchOperator {
    static final Logger LOG = LoggerFactory.getLogger((String)MapRDbJsonFetchByIdOperator.class.getName());

    MapRDbJsonFetchByIdOperator(FetchWork work, JobConf job, Operator<?> operator) throws HiveException {
        super(work, job, operator, new ArrayList<VirtualColumn>());
    }

    @Override
    public InspectableObject getNextRow() throws IOException {
        try {
            MapRDbJsonFetchByIdWork mapRWork = (MapRDbJsonFetchByIdWork)this.work;
            if (mapRWork.isEmpty()) {
                return null;
            }
            Table table = MapRDBImpl.getTable((String)mapRWork.getMapRDbTableName());
            Document document = table.findById(mapRWork.getSearchValue());
            this.inspectable.o = new DocumentWritable(document);
            this.currSerDe = this.tableSerDe;
            this.inspectable.oi = this.currSerDe.getObjectInspector();
            this.inspectable.o = this.currSerDe.deserialize(new DocumentWritable(document));
            return this.inspectable;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

