/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json.shims;

import java.io.IOException;
import org.apache.hadoop.hive.maprdb.json.shims.DocumentWritable;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.ojai.Document;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriterWrapper
implements org.apache.hadoop.mapred.RecordWriter<NullWritable, DocumentWritable>,
FileSinkOperator.RecordWriter {
    private static final Logger LOG = LoggerFactory.getLogger(RecordWriterWrapper.class);
    private final RecordWriter<Value, Document> recordWriter;
    private final TaskAttemptContext tac;

    public RecordWriterWrapper(RecordWriter<Value, Document> recordWriter, TaskAttemptContext tac) {
        this.recordWriter = recordWriter;
        this.tac = tac;
    }

    public void write(NullWritable key, DocumentWritable value) throws IOException {
        Document document = value.getDocument();
        try {
            this.recordWriter.write((Object)document.getId(), (Object)document);
        }
        catch (InterruptedException e) {
            throw new IOException("Error writing key/value pair", e);
        }
    }

    public void close(Reporter reporter) throws IOException {
        try {
            LOG.info("Closing Record Writer");
            this.recordWriter.close(this.tac);
        }
        catch (InterruptedException e) {
            throw new IOException("Error writing key/value pair", e);
        }
    }

    @Override
    public void write(Writable w) throws IOException {
        this.write(null, (DocumentWritable)w);
    }

    @Override
    public void close(boolean abort) throws IOException {
        this.close(null);
    }
}

