/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Cipher;
import com.jcraft.jsch.HASH;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SignatureDSA;
import com.jcraft.jsch.SignatureRSA;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;

class IdentityFile
implements Identity {
    String identity;
    byte[] key;
    byte[] iv;
    private JSch jsch;
    private HASH hash;
    private byte[] encoded_data;
    private Cipher cipher;
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private byte[] n_array;
    private byte[] e_array;
    private byte[] d_array;
    private String algname;
    private static final int ERROR = 0;
    private static final int RSA = 1;
    private static final int DSS = 2;
    private static final int UNKNOWN = 3;
    private static final int OPENSSH = 0;
    private static final int FSECURE = 1;
    private static final int PUTTY = 2;
    private int type;
    private int keytype;
    private byte[] publickeyblob;
    private boolean encrypted;

    static IdentityFile newInstance(String string, String string2, JSch jSch) throws JSchException {
        byte[] byArray;
        byte[] byArray2;
        block15: {
            int n;
            byArray2 = null;
            byArray = null;
            File file = null;
            FileInputStream fileInputStream = null;
            try {
                file = new File(string);
                fileInputStream = new FileInputStream(string);
                byArray2 = new byte[(int)file.length()];
                int n2 = 0;
                while ((n = fileInputStream.read(byArray2, n2, byArray2.length - n2)) > 0) {
                    n2 += n;
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
            String string3 = string2;
            if (string2 == null) {
                string3 = string + ".pub";
            }
            try {
                int n3;
                file = new File(string3);
                fileInputStream = new FileInputStream(string3);
                byArray = new byte[(int)file.length()];
                n = 0;
                while ((n3 = fileInputStream.read(byArray, n, byArray.length - n)) > 0) {
                    n += n3;
                }
                fileInputStream.close();
            }
            catch (Exception exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                if (string2 == null) break block15;
                if (exception instanceof Throwable) {
                    throw new JSchException(exception.toString(), exception);
                }
                throw new JSchException(exception.toString());
            }
        }
        return IdentityFile.newInstance(string, byArray2, byArray, jSch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IdentityFile newInstance(String string, byte[] byArray, byte[] byArray2, JSch jSch) throws JSchException {
        IdentityFile identityFile;
        try {
            identityFile = new IdentityFile(string, byArray, byArray2, jSch);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Util.bzero(byArray);
            throw throwable;
        }
        Util.bzero(byArray);
        return identityFile;
    }

    /*
     * Unable to fully structure code
     */
    private IdentityFile(String var1_1, byte[] var2_2, byte[] var3_3, JSch var4_4) throws JSchException {
        block50: {
            super();
            this.algname = "ssh-rsa";
            this.type = 0;
            this.keytype = 0;
            this.publickeyblob = null;
            this.encrypted = true;
            this.identity = var1_1;
            this.jsch = var4_4;
            try {
                block51: {
                    var5_5 = Class.forName(JSch.getConfig("3des-cbc"));
                    this.cipher = (Cipher)var5_5.newInstance();
                    this.key = new byte[this.cipher.getBlockSize()];
                    this.iv = new byte[this.cipher.getIVSize()];
                    var5_5 = Class.forName(JSch.getConfig("md5"));
                    this.hash = (HASH)var5_5.newInstance();
                    this.hash.init();
                    var6_7 = var2_2;
                    var7_8 = var6_7.length;
                    var8_9 = 0;
                    while (var8_9 < var7_8) {
                        if (var6_7[var8_9] == 66 && var6_7[var8_9 + 1] == 69 && var6_7[var8_9 + 2] == 71 && var6_7[var8_9 + 3] == 73) {
                            if (var6_7[var8_9 += 6] == 68 && var6_7[var8_9 + 1] == 83 && var6_7[var8_9 + 2] == 65) {
                                this.type = 2;
                            } else if (var6_7[var8_9] == 82 && var6_7[var8_9 + 1] == 83 && var6_7[var8_9 + 2] == 65) {
                                this.type = 1;
                            } else if (var6_7[var8_9] == 83 && var6_7[var8_9 + 1] == 83 && var6_7[var8_9 + 2] == 72) {
                                this.type = 3;
                                this.keytype = 1;
                            } else {
                                throw new JSchException("invalid privatekey: " + this.identity);
                            }
                            var8_9 += 3;
                            continue;
                        }
                        if (var6_7[var8_9] == 65 && var6_7[var8_9 + 1] == 69 && var6_7[var8_9 + 2] == 83 && var6_7[var8_9 + 3] == 45 && var6_7[var8_9 + 4] == 50 && var6_7[var8_9 + 5] == 53 && var6_7[var8_9 + 6] == 54 && var6_7[var8_9 + 7] == 45) {
                            var8_9 += 8;
                            if (Session.checkCipher(JSch.getConfig("aes256-cbc"))) {
                                var5_5 = Class.forName(JSch.getConfig("aes256-cbc"));
                                this.cipher = (Cipher)var5_5.newInstance();
                                this.key = new byte[this.cipher.getBlockSize()];
                                this.iv = new byte[this.cipher.getIVSize()];
                                continue;
                            }
                            throw new JSchException("privatekey: aes256-cbc is not available " + this.identity);
                        }
                        if (var6_7[var8_9] == 67 && var6_7[var8_9 + 1] == 66 && var6_7[var8_9 + 2] == 67 && var6_7[var8_9 + 3] == 44) {
                            var8_9 += 4;
                            var9_10 = 0;
                            while (var9_10 < this.iv.length) {
                                this.iv[var9_10] = (byte)((this.a2b(var6_7[var8_9++]) << 4 & 240) + (this.a2b(var6_7[var8_9++]) & 15));
                                ++var9_10;
                            }
                            continue;
                        }
                        if (var6_7[var8_9] == 13 && var8_9 + 1 < var6_7.length && var6_7[var8_9 + 1] == 10) {
                            ++var8_9;
                            continue;
                        }
                        if (var6_7[var8_9] == 10 && var8_9 + 1 < var6_7.length) {
                            if (var6_7[var8_9 + 1] == 10) {
                                var8_9 += 2;
                                break;
                            }
                            if (var6_7[var8_9 + 1] == 13 && var8_9 + 2 < var6_7.length && var6_7[var8_9 + 2] == 10) {
                                var8_9 += 3;
                                break;
                            }
                            var9_10 = 0;
                            var10_11 = var8_9 + 1;
                            while (var10_11 < var6_7.length) {
                                if (var6_7[var10_11] == 10) break;
                                if (var6_7[var10_11] == 58) {
                                    var9_10 = 1;
                                    break;
                                }
                                ++var10_11;
                            }
                            if (var9_10 == 0) {
                                ++var8_9;
                                this.encrypted = false;
                                break;
                            }
                        }
                        ++var8_9;
                    }
                    if (this.type == 0) {
                        throw new JSchException("invalid privatekey: " + this.identity);
                    }
                    var9_10 = var8_9;
                    while (var8_9 < var7_8) {
                        if (var6_7[var8_9] == 10) {
                            var10_11 = var6_7[var8_9 - 1] == 13 ? 1 : 0;
                            System.arraycopy(var6_7, var8_9 + 1, var6_7, var8_9 - (var10_11 != 0 ? 1 : 0), var7_8 - var8_9 - 1 - (var10_11 != 0 ? 1 : 0));
                            if (var10_11 != 0) {
                                --var7_8;
                            }
                            --var7_8;
                            continue;
                        }
                        if (var6_7[var8_9] == 45) break;
                        ++var8_9;
                    }
                    this.encoded_data = Util.fromBase64(var6_7, var9_10, var8_9 - var9_10);
                    if (this.encoded_data.length > 4 && this.encoded_data[0] == 63 && this.encoded_data[1] == 111 && this.encoded_data[2] == -7 && this.encoded_data[3] == -21) {
                        var10_12 = new Buffer(this.encoded_data);
                        var10_12.getInt();
                        var10_12.getInt();
                        var11_15 = var10_12.getString();
                        var12_17 = var10_12.getString();
                        var13_18 = new String(var12_17);
                        if (var13_18.equals("3des-cbc")) {
                            var10_12.getInt();
                            var14_19 = new byte[this.encoded_data.length - var10_12.getOffSet()];
                            var10_12.getByte(var14_19);
                            this.encoded_data = var14_19;
                            this.encrypted = true;
                            throw new JSchException("unknown privatekey format: " + this.identity);
                        }
                        if (var13_18.equals("none")) {
                            var10_12.getInt();
                            this.encrypted = false;
                            var14_20 = new byte[this.encoded_data.length - var10_12.getOffSet()];
                            var10_12.getByte(var14_20);
                            this.encoded_data = var14_20;
                        }
                    }
                    if (var3_3 == null) {
                        return;
                    }
                    var6_7 = var3_3;
                    var7_8 = var6_7.length;
                    if (var6_7.length <= 4 || var6_7[0] != 45 || var6_7[1] != 45 || var6_7[2] != 45 || var6_7[3] != 45) break block51;
                    var8_9 = 0;
                    while (var7_8 > ++var8_9 && var6_7[var8_9] != 10) {
                    }
                    if (var7_8 > var8_9) ** GOTO lbl140
                    return;
lbl-1000:
                    // 1 sources

                    {
                        if (var6_7[var8_9] == 10) {
                            var10_14 = false;
                            var11_16 = var8_9 + 1;
                            while (var11_16 < var7_8) {
                                if (var6_7[var11_16] == 10) break;
                                if (var6_7[var11_16] == 58) {
                                    var10_14 = true;
                                    break;
                                }
                                ++var11_16;
                            }
                            if (!var10_14) {
                                ++var8_9;
                                break;
                            }
                        }
                        ++var8_9;
lbl140:
                        // 2 sources

                        ** while (var8_9 < var7_8)
                    }
lbl141:
                    // 2 sources

                    if (var7_8 <= var8_9) {
                        return;
                    }
                    var9_10 = var8_9;
                    while (var8_9 < var7_8) {
                        if (var6_7[var8_9] == 10) {
                            System.arraycopy(var6_7, var8_9 + 1, var6_7, var8_9, var7_8 - var8_9 - 1);
                            --var7_8;
                            continue;
                        }
                        if (var6_7[var8_9] == 45) break;
                        ++var8_9;
                    }
                    this.publickeyblob = Util.fromBase64(var6_7, var9_10, var8_9 - var9_10);
                    if (this.type == 3 && this.publickeyblob.length > 8) {
                        if (this.publickeyblob[8] == 100) {
                            this.type = 2;
                        } else if (this.publickeyblob[8] == 114) {
                            this.type = 1;
                        }
                    }
                    break block50;
                }
                if (var6_7[0] != 115 || var6_7[1] != 115 || var6_7[2] != 104 || var6_7[3] != 45) {
                    return;
                }
                var8_9 = 0;
                while (var8_9 < var7_8) {
                    if (var6_7[var8_9] == 32) break;
                    ++var8_9;
                }
                if (++var8_9 >= var7_8) {
                    return;
                }
                var9_10 = var8_9;
                while (var8_9 < var7_8) {
                    if (var6_7[var8_9] == 32 || var6_7[var8_9] == 10) break;
                    ++var8_9;
                }
                this.publickeyblob = Util.fromBase64(var6_7, var9_10, var8_9 - var9_10);
                if (this.publickeyblob.length < 11) {
                    if (JSch.getLogger().isEnabled(2)) {
                        JSch.getLogger().log(2, "failed to parse the public key");
                    }
                    this.publickeyblob = null;
                }
            }
            catch (Exception var5_6) {
                if (var5_6 instanceof JSchException) {
                    throw (JSchException)var5_6;
                }
                if (var5_6 instanceof Throwable) {
                    throw new JSchException(var5_6.toString(), var5_6);
                }
                throw new JSchException(var5_6.toString());
            }
        }
    }

    public String getAlgName() {
        if (this.type == 1) {
            return "ssh-rsa";
        }
        return "ssh-dss";
    }

    public boolean setPassphrase(byte[] byArray) throws JSchException {
        try {
            if (this.encrypted) {
                if (byArray == null) {
                    return false;
                }
                byte[] byArray2 = byArray;
                int n = this.hash.getBlockSize();
                byte[] byArray3 = new byte[this.key.length / n * n + (this.key.length % n == 0 ? 0 : n)];
                byte[] byArray4 = null;
                if (this.keytype == 0) {
                    int n2 = 0;
                    while (n2 + n <= byArray3.length) {
                        if (byArray4 != null) {
                            this.hash.update(byArray4, 0, byArray4.length);
                        }
                        this.hash.update(byArray2, 0, byArray2.length);
                        this.hash.update(this.iv, 0, this.iv.length > 8 ? 8 : this.iv.length);
                        byArray4 = this.hash.digest();
                        System.arraycopy(byArray4, 0, byArray3, n2, byArray4.length);
                        n2 += byArray4.length;
                    }
                    System.arraycopy(byArray3, 0, this.key, 0, this.key.length);
                } else if (this.keytype == 1) {
                    int n3 = 0;
                    while (n3 + n <= byArray3.length) {
                        if (byArray4 != null) {
                            this.hash.update(byArray4, 0, byArray4.length);
                        }
                        this.hash.update(byArray2, 0, byArray2.length);
                        byArray4 = this.hash.digest();
                        System.arraycopy(byArray4, 0, byArray3, n3, byArray4.length);
                        n3 += byArray4.length;
                    }
                    System.arraycopy(byArray3, 0, this.key, 0, this.key.length);
                }
                Util.bzero(byArray2);
            }
            if (this.decrypt()) {
                this.encrypted = false;
                return true;
            }
            this.prv_array = null;
            this.pub_array = null;
            this.G_array = null;
            this.Q_array = null;
            this.P_array = null;
            return false;
        }
        catch (Exception exception) {
            if (exception instanceof JSchException) {
                throw (JSchException)exception;
            }
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    public byte[] getPublicKeyBlob() {
        if (this.publickeyblob != null) {
            return this.publickeyblob;
        }
        if (this.type == 1) {
            return this.getPublicKeyBlob_rsa();
        }
        return this.getPublicKeyBlob_dss();
    }

    byte[] getPublicKeyBlob_rsa() {
        if (this.e_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-rsa".length() + 4 + this.e_array.length + 4 + this.n_array.length + 4);
        buffer.putString("ssh-rsa".getBytes());
        buffer.putString(this.e_array);
        buffer.putString(this.n_array);
        return buffer.buffer;
    }

    byte[] getPublicKeyBlob_dss() {
        if (this.P_array == null) {
            return null;
        }
        Buffer buffer = new Buffer("ssh-dss".length() + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buffer.putString("ssh-dss".getBytes());
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        return buffer.buffer;
    }

    public byte[] getSignature(byte[] byArray) {
        if (this.type == 1) {
            return this.getSignature_rsa(byArray);
        }
        return this.getSignature_dss(byArray);
    }

    byte[] getSignature_rsa(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.rsa"));
            SignatureRSA signatureRSA = (SignatureRSA)clazz.newInstance();
            signatureRSA.init();
            signatureRSA.setPrvKey(this.d_array, this.n_array);
            signatureRSA.update(byArray);
            byte[] byArray2 = signatureRSA.sign();
            Buffer buffer = new Buffer("ssh-rsa".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-rsa".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    byte[] getSignature_dss(byte[] byArray) {
        try {
            Class<?> clazz = Class.forName(JSch.getConfig("signature.dss"));
            SignatureDSA signatureDSA = (SignatureDSA)clazz.newInstance();
            signatureDSA.init();
            signatureDSA.setPrvKey(this.prv_array, this.P_array, this.Q_array, this.G_array);
            signatureDSA.update(byArray);
            byte[] byArray2 = signatureDSA.sign();
            Buffer buffer = new Buffer("ssh-dss".length() + 4 + byArray2.length + 4);
            buffer.putString("ssh-dss".getBytes());
            buffer.putString(byArray2);
            return buffer.buffer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean decrypt() {
        if (this.type == 1) {
            return this.decrypt_rsa();
        }
        return this.decrypt_dss();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_rsa() {
        try {
            int n;
            int n2;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    n2 = 0;
                    while (n2 < this.iv.length) {
                        this.iv[n2] = 0;
                        ++n2;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.n_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n3 = buffer.getInt();
                if (byArray.length != n3 + 4) {
                    return false;
                }
                this.e_array = buffer.getMPIntBits();
                this.d_array = buffer.getMPIntBits();
                this.n_array = buffer.getMPIntBits();
                byte[] byArray2 = buffer.getMPIntBits();
                byte[] byArray3 = buffer.getMPIntBits();
                byte[] byArray4 = buffer.getMPIntBits();
                return true;
            }
            n2 = 0;
            int n4 = 0;
            if (byArray[n2] != 48) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n6 = ++n2;
            ++n2;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n4;
            int n7 = ++n2;
            ++n2;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.n_array = new byte[n4];
            System.arraycopy(byArray, n2, this.n_array, 0, n4);
            n2 += n4;
            int n8 = ++n2;
            ++n2;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.e_array = new byte[n4];
            System.arraycopy(byArray, n2, this.e_array, 0, n4);
            n2 += n4;
            int n9 = ++n2;
            ++n2;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.d_array = new byte[n4];
            System.arraycopy(byArray, n2, this.d_array, 0, n4);
            n2 += n4;
            int n10 = ++n2;
            ++n2;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray5 = new byte[n4];
            System.arraycopy(byArray, n2, byArray5, 0, n4);
            n2 += n4;
            int n11 = ++n2;
            ++n2;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray6 = new byte[n4];
            System.arraycopy(byArray, n2, byArray6, 0, n4);
            n2 += n4;
            int n12 = ++n2;
            ++n2;
            n4 = byArray[n12] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray7 = new byte[n4];
            System.arraycopy(byArray, n2, byArray7, 0, n4);
            n2 += n4;
            int n13 = ++n2;
            ++n2;
            n4 = byArray[n13] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray8 = new byte[n4];
            System.arraycopy(byArray, n2, byArray8, 0, n4);
            n2 += n4;
            int n14 = ++n2;
            ++n2;
            n4 = byArray[n14] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            byte[] byArray9 = new byte[n4];
            System.arraycopy(byArray, n2, byArray9, 0, n4);
            n2 += n4;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean decrypt_dss() {
        try {
            int n;
            int n2;
            byte[] byArray;
            if (this.encrypted) {
                if (this.keytype == 0) {
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                } else {
                    if (this.keytype != 1) return false;
                    n2 = 0;
                    while (n2 < this.iv.length) {
                        this.iv[n2] = 0;
                        ++n2;
                    }
                    this.cipher.init(1, this.key, this.iv);
                    byArray = new byte[this.encoded_data.length];
                    this.cipher.update(this.encoded_data, 0, this.encoded_data.length, byArray, 0);
                }
            } else {
                if (this.P_array != null) {
                    return true;
                }
                byArray = this.encoded_data;
            }
            if (this.keytype == 1) {
                Buffer buffer = new Buffer(byArray);
                int n3 = buffer.getInt();
                if (byArray.length != n3 + 4) {
                    return false;
                }
                this.P_array = buffer.getMPIntBits();
                this.G_array = buffer.getMPIntBits();
                this.Q_array = buffer.getMPIntBits();
                this.pub_array = buffer.getMPIntBits();
                this.prv_array = buffer.getMPIntBits();
                return true;
            }
            n2 = 0;
            int n4 = 0;
            if (byArray[n2] != 48) {
                return false;
            }
            int n5 = ++n2;
            ++n2;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            if (byArray[n2] != 2) {
                return false;
            }
            int n6 = ++n2;
            ++n2;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            n2 += n4;
            int n7 = ++n2;
            ++n2;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.P_array = new byte[n4];
            System.arraycopy(byArray, n2, this.P_array, 0, n4);
            n2 += n4;
            int n8 = ++n2;
            ++n2;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.Q_array = new byte[n4];
            System.arraycopy(byArray, n2, this.Q_array, 0, n4);
            n2 += n4;
            int n9 = ++n2;
            ++n2;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.G_array = new byte[n4];
            System.arraycopy(byArray, n2, this.G_array, 0, n4);
            n2 += n4;
            int n10 = ++n2;
            ++n2;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.pub_array = new byte[n4];
            System.arraycopy(byArray, n2, this.pub_array, 0, n4);
            n2 += n4;
            int n11 = ++n2;
            ++n2;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n = n4 & 0x7F;
                n4 = 0;
                while (n-- > 0) {
                    n4 = (n4 << 8) + (byArray[n2++] & 0xFF);
                }
            }
            this.prv_array = new byte[n4];
            System.arraycopy(byArray, n2, this.prv_array, 0, n4);
            n2 += n4;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getName() {
        return this.identity;
    }

    private byte a2b(byte by) {
        if (48 <= by && by <= 57) {
            return (byte)(by - 48);
        }
        if (97 <= by && by <= 122) {
            return (byte)(by - 97 + 10);
        }
        return (byte)(by - 65 + 10);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IdentityFile)) {
            return super.equals(object);
        }
        IdentityFile identityFile = (IdentityFile)object;
        return this.getName().equals(identityFile.getName());
    }

    public void clear() {
        Util.bzero(this.encoded_data);
        Util.bzero(this.prv_array);
        Util.bzero(this.d_array);
        Util.bzero(this.key);
        Util.bzero(this.iv);
    }

    public void finalize() {
        this.clear();
    }
}

