/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.segment.loading.SegmentLoaderConfig;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DataSegmentChangeCallback;
import io.druid.server.coordination.DataSegmentChangeHandler;
import io.druid.server.coordination.DataSegmentChangeRequest;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.coordination.ServerManager;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;

public class ZkCoordinator
implements DataSegmentChangeHandler {
    private static final EmittingLogger log = new EmittingLogger(ZkCoordinator.class);
    private final Object lock = new Object();
    private final ObjectMapper jsonMapper;
    private final ZkPathsConfig zkPaths;
    private final SegmentLoaderConfig config;
    private final DruidServerMetadata me;
    private final CuratorFramework curator;
    private final DataSegmentAnnouncer announcer;
    private final ServerManager serverManager;
    private final ScheduledExecutorService exec;
    private final ConcurrentSkipListSet<DataSegment> segmentsToDelete;
    private volatile PathChildrenCache loadQueueCache;
    private volatile boolean started = false;

    @Inject
    public ZkCoordinator(ObjectMapper jsonMapper, SegmentLoaderConfig config, ZkPathsConfig zkPaths, DruidServerMetadata me, DataSegmentAnnouncer announcer, CuratorFramework curator, ServerManager serverManager, ScheduledExecutorFactory factory) {
        this.jsonMapper = jsonMapper;
        this.zkPaths = zkPaths;
        this.config = config;
        this.me = me;
        this.curator = curator;
        this.announcer = announcer;
        this.serverManager = serverManager;
        this.exec = factory.create(1, "ZkCoordinator-Exec--%d");
        this.segmentsToDelete = new ConcurrentSkipListSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Starting zkCoordinator for server[%s]", new Object[]{this.me.getName()});
            String loadQueueLocation = ZKPaths.makePath((String)this.zkPaths.getLoadQueuePath(), (String)this.me.getName());
            String servedSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getServedSegmentsPath(), (String)this.me.getName());
            String liveSegmentsLocation = ZKPaths.makePath((String)this.zkPaths.getLiveSegmentsPath(), (String)this.me.getName());
            this.loadQueueCache = new PathChildrenCache(this.curator, loadQueueLocation, true, true, Execs.multiThreaded((int)this.config.getNumLoadingThreads(), (String)"ZkCoordinator-%s"));
            try {
                this.curator.newNamespaceAwareEnsurePath(loadQueueLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(servedSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.curator.newNamespaceAwareEnsurePath(liveSegmentsLocation).ensure(this.curator.getZookeeperClient());
                this.loadLocalCache();
                this.loadQueueCache.getListenable().addListener((Object)new PathChildrenCacheListener(){

                    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                        ChildData child = event.getData();
                        switch (event.getType()) {
                            case CHILD_ADDED: {
                                final String path = child.getPath();
                                final DataSegmentChangeRequest request = (DataSegmentChangeRequest)ZkCoordinator.this.jsonMapper.readValue(child.getData(), DataSegmentChangeRequest.class);
                                log.info("New request[%s] with zNode[%s].", new Object[]{request.asString(), path});
                                try {
                                    request.go(ZkCoordinator.this.getDataSegmentChangeHandler(), new DataSegmentChangeCallback(){
                                        boolean hasRun = false;

                                        @Override
                                        public void execute() {
                                            try {
                                                if (!this.hasRun) {
                                                    ZkCoordinator.this.curator.delete().guaranteed().forPath(path);
                                                    log.info("Completed request [%s]", new Object[]{request.asString()});
                                                    this.hasRun = true;
                                                }
                                            }
                                            catch (Exception e) {
                                                try {
                                                    ZkCoordinator.this.curator.delete().guaranteed().forPath(path);
                                                }
                                                catch (Exception e1) {
                                                    log.error((Throwable)e1, "Failed to delete zNode[%s], but ignoring exception.", new Object[]{path});
                                                }
                                                log.error((Throwable)e, "Exception while removing zNode[%s]", new Object[]{path});
                                                throw Throwables.propagate((Throwable)e);
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    try {
                                        ZkCoordinator.this.curator.delete().guaranteed().forPath(path);
                                    }
                                    catch (Exception e1) {
                                        log.error((Throwable)e1, "Failed to delete zNode[%s], but ignoring exception.", new Object[]{path});
                                    }
                                    log.makeAlert((Throwable)e, "Segment load/unload: uncaught exception.", new Object[0]).addData("node", (Object)path).addData("nodeProperties", (Object)request).emit();
                                }
                                break;
                            }
                            case CHILD_REMOVED: {
                                log.info("zNode[%s] was removed", new Object[]{event.getData().getPath()});
                                break;
                            }
                            default: {
                                log.info("Ignoring event[%s]", new Object[]{event});
                            }
                        }
                    }
                });
                this.loadQueueCache.start();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw Throwables.propagate((Throwable)e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        log.info("Stopping ZkCoordinator for [%s]", new Object[]{this.me});
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                this.loadQueueCache.close();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                this.loadQueueCache = null;
                this.started = false;
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void loadLocalCache() {
        final long start = System.currentTimeMillis();
        File baseDir = this.config.getInfoDir();
        if (!baseDir.exists() && !this.config.getInfoDir().mkdirs()) {
            return;
        }
        ArrayList cachedSegments = Lists.newArrayList();
        File[] segmentsToLoad = baseDir.listFiles();
        for (int i = 0; i < segmentsToLoad.length; ++i) {
            File file = segmentsToLoad[i];
            log.info("Loading segment cache file [%d/%d][%s].", new Object[]{i, segmentsToLoad.length, file});
            try {
                DataSegment segment = (DataSegment)this.jsonMapper.readValue(file, DataSegment.class);
                if (this.serverManager.isSegmentCached(segment)) {
                    cachedSegments.add(segment);
                    continue;
                }
                log.warn("Unable to find cache file for %s. Deleting lookup entry", new Object[]{segment.getIdentifier()});
                File segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier());
                if (segmentInfoCacheFile.delete()) continue;
                log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
                continue;
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to load segment from segmentInfo file", new Object[0]).addData("file", (Object)file).emit();
            }
        }
        this.addSegments(cachedSegments, new DataSegmentChangeCallback(){

            @Override
            public void execute() {
                log.info("Cache load took %,d ms", new Object[]{System.currentTimeMillis() - start});
            }
        });
    }

    public DataSegmentChangeHandler getDataSegmentChangeHandler() {
        return this;
    }

    private void loadSegment(DataSegment segment, DataSegmentChangeCallback callback) throws SegmentLoadingException {
        File segmentInfoCacheFile;
        boolean loaded;
        try {
            loaded = this.serverManager.loadSegment(segment);
        }
        catch (Exception e) {
            this.removeSegment(segment, callback);
            throw new SegmentLoadingException((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getIdentifier()});
        }
        if (loaded && !(segmentInfoCacheFile = new File(this.config.getInfoDir(), segment.getIdentifier())).exists()) {
            try {
                this.jsonMapper.writeValue(segmentInfoCacheFile, (Object)segment);
            }
            catch (IOException e) {
                this.removeSegment(segment, callback);
                throw new SegmentLoadingException((Throwable)e, "Failed to write to disk segment info cache file[%s]", new Object[]{segmentInfoCacheFile});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(DataSegment segment, DataSegmentChangeCallback callback) {
        block11: {
            try {
                log.info("Loading segment %s", new Object[]{segment.getIdentifier()});
                if (this.segmentsToDelete.contains(segment)) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.segmentsToDelete.remove(segment);
                    }
                }
                this.loadSegment(segment, callback);
                if (this.announcer.isAnnounced(segment)) break block11;
                try {
                    this.announcer.announceSegment(segment);
                }
                catch (IOException e) {
                    throw new SegmentLoadingException((Throwable)e, "Failed to announce segment[%s]", new Object[]{segment.getIdentifier()});
                }
            }
            catch (SegmentLoadingException e) {
                log.makeAlert((Throwable)e, "Failed to load segment for dataSource", new Object[0]).addData("segment", (Object)segment).emit();
            }
            finally {
                callback.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSegments(Collection<DataSegment> segments, final DataSegmentChangeCallback callback) {
        ExecutorService loadingExecutor = null;
        try (final BackgroundSegmentAnnouncer backgroundSegmentAnnouncer = new BackgroundSegmentAnnouncer(this.announcer, this.exec, this.config.getAnnounceIntervalMillis());){
            backgroundSegmentAnnouncer.startAnnouncing();
            loadingExecutor = Execs.multiThreaded((int)this.config.getNumBootstrapThreads(), (String)"ZkCoordinator-loading-%s");
            final int numSegments = segments.size();
            final CountDownLatch latch = new CountDownLatch(numSegments);
            final AtomicInteger counter = new AtomicInteger(0);
            final CopyOnWriteArrayList failedSegments = new CopyOnWriteArrayList();
            for (final DataSegment segment : segments) {
                loadingExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        block7: {
                            try {
                                log.info("Loading segment[%d/%d][%s]", new Object[]{counter.getAndIncrement(), numSegments, segment.getIdentifier()});
                                ZkCoordinator.this.loadSegment(segment, callback);
                                if (ZkCoordinator.this.announcer.isAnnounced(segment)) break block7;
                                try {
                                    backgroundSegmentAnnouncer.announceSegment(segment);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                                }
                            }
                            catch (SegmentLoadingException e) {
                                log.error((Throwable)e, "[%s] failed to load", new Object[]{segment.getIdentifier()});
                                failedSegments.add(segment);
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }
                });
            }
            try {
                latch.await();
                if (failedSegments.size() > 0) {
                    log.makeAlert("%,d errors seen while loading segments", new Object[]{failedSegments.size()}).addData("failedSegments", failedSegments);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.makeAlert((Throwable)e, "LoadingInterrupted", new Object[0]);
            }
            backgroundSegmentAnnouncer.finishAnnouncing();
        }
        catch (SegmentLoadingException e) {
            log.makeAlert((Throwable)e, "Failed to load segments -- likely problem with announcing.", new Object[0]).addData("numSegments", (Object)segments.size()).emit();
        }
        finally {
            callback.execute();
            if (loadingExecutor != null) {
                loadingExecutor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSegment(final DataSegment segment, DataSegmentChangeCallback callback) {
        try {
            this.announcer.unannounceSegment(segment);
            this.segmentsToDelete.add(segment);
            log.info("Completely removing [%s] in [%,d] millis", new Object[]{segment.getIdentifier(), this.config.getDropSegmentDelayMillis()});
            this.exec.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = ZkCoordinator.this.lock;
                        synchronized (object) {
                            if (ZkCoordinator.this.segmentsToDelete.remove(segment)) {
                                ZkCoordinator.this.serverManager.dropSegment(segment);
                                File segmentInfoCacheFile = new File(ZkCoordinator.this.config.getInfoDir(), segment.getIdentifier());
                                if (!segmentInfoCacheFile.delete()) {
                                    log.warn("Unable to delete segmentInfoCacheFile[%s]", new Object[]{segmentInfoCacheFile});
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        log.makeAlert((Throwable)e, "Failed to remove segment! Possible resource leak!", new Object[0]).addData("segment", (Object)segment).emit();
                    }
                }
            }, (long)this.config.getDropSegmentDelayMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.makeAlert((Throwable)e, "Failed to remove segment", new Object[0]).addData("segment", (Object)segment).emit();
        }
        finally {
            callback.execute();
        }
    }

    public Collection<DataSegment> getPendingDeleteSnapshot() {
        return ImmutableList.copyOf(this.segmentsToDelete);
    }

    private static class BackgroundSegmentAnnouncer
    implements AutoCloseable {
        private static final EmittingLogger log = new EmittingLogger(BackgroundSegmentAnnouncer.class);
        private final int intervalMillis;
        private final DataSegmentAnnouncer announcer;
        private final ScheduledExecutorService exec;
        private final LinkedBlockingQueue<DataSegment> queue;
        private final SettableFuture<Boolean> doneAnnouncing;
        private final Object lock = new Object();
        private volatile boolean finished = false;
        private volatile ScheduledFuture startedAnnouncing = null;
        private volatile ScheduledFuture nextAnnoucement = null;

        public BackgroundSegmentAnnouncer(DataSegmentAnnouncer announcer, ScheduledExecutorService exec, int intervalMillis) {
            this.announcer = announcer;
            this.exec = exec;
            this.intervalMillis = intervalMillis;
            this.queue = Queues.newLinkedBlockingQueue();
            this.doneAnnouncing = SettableFuture.create();
        }

        public void announceSegment(DataSegment segment) throws InterruptedException {
            if (this.finished) {
                throw new ISE("Announce segment called after finishAnnouncing", new Object[0]);
            }
            this.queue.put(segment);
        }

        public void startAnnouncing() {
            if (this.intervalMillis <= 0) {
                return;
            }
            log.info("Starting background segment announcing task", new Object[0]);
            this.nextAnnoucement = this.startedAnnouncing = this.exec.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = BackgroundSegmentAnnouncer.this.lock;
                    synchronized (object) {
                        try {
                            if (!BackgroundSegmentAnnouncer.this.finished || !BackgroundSegmentAnnouncer.this.queue.isEmpty()) {
                                LinkedList segments = Lists.newLinkedList();
                                BackgroundSegmentAnnouncer.this.queue.drainTo(segments);
                                try {
                                    BackgroundSegmentAnnouncer.this.announcer.announceSegments(segments);
                                    BackgroundSegmentAnnouncer.this.nextAnnoucement = BackgroundSegmentAnnouncer.this.exec.schedule(this, (long)BackgroundSegmentAnnouncer.this.intervalMillis, TimeUnit.MILLISECONDS);
                                }
                                catch (IOException e) {
                                    BackgroundSegmentAnnouncer.this.doneAnnouncing.setException((Throwable)new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{segments}));
                                }
                            } else {
                                BackgroundSegmentAnnouncer.this.doneAnnouncing.set((Object)true);
                            }
                        }
                        catch (Exception e) {
                            BackgroundSegmentAnnouncer.this.doneAnnouncing.setException((Throwable)e);
                        }
                    }
                }
            }, (long)this.intervalMillis, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishAnnouncing() throws SegmentLoadingException {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                try {
                    LinkedList segments = Lists.newLinkedList();
                    this.queue.drainTo(segments);
                    this.announcer.announceSegments(segments);
                }
                catch (Exception e) {
                    throw new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{this.queue});
                }
                try {
                    if (this.startedAnnouncing != null) {
                        this.startedAnnouncing.cancel(false);
                    }
                    if (this.doneAnnouncing.isDone()) {
                        this.doneAnnouncing.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                }
                catch (ExecutionException e) {
                    throw new SegmentLoadingException(e.getCause(), "Background Announcing Task Failed", new Object[0]);
                }
            }
            log.info("Completed background segment announcing", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                if (this.nextAnnoucement != null) {
                    this.nextAnnoucement.cancel(false);
                }
            }
        }
    }
}

