/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.query.Query;
import io.druid.query.QueryWatcher;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

public class QueryManager
implements QueryWatcher {
    private final SetMultimap<String, ListenableFuture> queries = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());
    private final SetMultimap<String, String> queryDatasources = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    public boolean cancelQuery(String id) {
        this.queryDatasources.removeAll((Object)id);
        Set futures = this.queries.removeAll((Object)id);
        boolean success = true;
        for (ListenableFuture future : futures) {
            success = success && future.cancel(true);
        }
        return success;
    }

    public void registerQuery(Query query, final ListenableFuture future) {
        final String id = query.getId();
        final List datasources = query.getDataSource().getNames();
        this.queries.put((Object)id, (Object)future);
        this.queryDatasources.putAll((Object)id, (Iterable)datasources);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                QueryManager.this.queries.remove((Object)id, (Object)future);
                for (String datasource : datasources) {
                    QueryManager.this.queryDatasources.remove((Object)id, (Object)datasource);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public Set<String> getQueryDatasources(String queryId) {
        return this.queryDatasources.get((Object)queryId);
    }
}

