/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.calcite.linq4j.Ord;
import org.apache.hive.druid.org.apache.calcite.linq4j.function.Predicate1;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollation;
import org.apache.hive.druid.org.apache.calcite.rel.RelCollations;
import org.apache.hive.druid.org.apache.calcite.rel.RelFieldCollation;
import org.apache.hive.druid.org.apache.calcite.rel.core.Filter;
import org.apache.hive.druid.org.apache.calcite.rel.core.Join;
import org.apache.hive.druid.org.apache.calcite.rel.core.Project;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hive.druid.org.apache.calcite.rex.RexBuilder;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexCorrelVariable;
import org.apache.hive.druid.org.apache.calcite.rex.RexDynamicParam;
import org.apache.hive.druid.org.apache.calcite.rex.RexFieldAccess;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexLocalRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.rex.RexOver;
import org.apache.hive.druid.org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexProgram;
import org.apache.hive.druid.org.apache.calcite.rex.RexRangeRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexShuttle;
import org.apache.hive.druid.org.apache.calcite.rex.RexSubQuery;
import org.apache.hive.druid.org.apache.calcite.rex.RexVariable;
import org.apache.hive.druid.org.apache.calcite.rex.RexVisitor;
import org.apache.hive.druid.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.hive.druid.org.apache.calcite.sql.SqlAggFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.hive.druid.org.apache.calcite.util.ControlFlowException;
import org.apache.hive.druid.org.apache.calcite.util.Litmus;
import org.apache.hive.druid.org.apache.calcite.util.Pair;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.mapping.Mappings;

public class RexUtil {
    private static final Function<? super RexNode, ? extends RexNode> ADD_NOT = new Function<RexNode, RexNode>(){

        @Override
        public RexNode apply(RexNode input) {
            return new RexCall(input.getType(), SqlStdOperatorTable.NOT, ImmutableList.of(input));
        }
    };
    private static final Predicate1<RexNode> IS_FLAT_PREDICATE = new Predicate1<RexNode>(){

        @Override
        public boolean apply(RexNode v1) {
            return RexUtil.isFlat(v1);
        }
    };
    private static final Function<Object, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String apply(Object input) {
            return input.toString();
        }
    };
    private static final Function<RexNode, RelDataType> TYPE_FN = new Function<RexNode, RelDataType>(){

        @Override
        public RelDataType apply(RexNode input) {
            return input.getType();
        }
    };
    private static final Function<RelDataType, RelDataTypeFamily> FAMILY_FN = new Function<RelDataType, RelDataTypeFamily>(){

        @Override
        public RelDataTypeFamily apply(RelDataType input) {
            return input.getFamily();
        }
    };

    private RexUtil() {
    }

    public static double getSelectivity(RexNode exp) {
        if (exp == null || exp.isAlwaysTrue()) {
            return 1.0;
        }
        return 0.1;
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, RelDataType rhsRowType) {
        List<RelDataTypeField> fieldList = rhsRowType.getFieldList();
        int n = fieldList.size();
        assert (n == lhsRowType.getFieldCount()) : "field count: lhs [" + lhsRowType + "] rhs [" + rhsRowType + "]";
        ArrayList<RexNode> rhsExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : fieldList) {
            rhsExps.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return RexUtil.generateCastExpressions(rexBuilder, lhsRowType, rhsExps);
    }

    public static List<RexNode> generateCastExpressions(RexBuilder rexBuilder, RelDataType lhsRowType, List<RexNode> rhsExps) {
        List<RelDataTypeField> lhsFields = lhsRowType.getFieldList();
        ArrayList<RexNode> castExps = new ArrayList<RexNode>();
        for (Pair<RelDataTypeField, RexNode> pair : Pair.zip(lhsFields, rhsExps, true)) {
            RexNode rhsExp;
            RelDataType rhsType;
            RelDataTypeField lhsField = (RelDataTypeField)pair.left;
            RelDataType lhsType = lhsField.getType();
            if (lhsType.equals(rhsType = (rhsExp = (RexNode)pair.right).getType())) {
                castExps.add(rhsExp);
                continue;
            }
            castExps.add(rexBuilder.makeCast(lhsType, rhsExp));
        }
        return castExps;
    }

    public static boolean isNullLiteral(RexNode node, boolean allowCast) {
        if (node instanceof RexLiteral) {
            RexLiteral literal = (RexLiteral)node;
            if (literal.getTypeName() == SqlTypeName.NULL) {
                assert (null == literal.getValue());
                return true;
            }
            return false;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            if (RexUtil.isNullLiteral((RexNode)call.operands.get(0), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case CAST: {
                return RexUtil.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public static boolean isLiteral(RexNode node, boolean allowCast) {
        assert (node != null);
        if (node instanceof RexLiteral) {
            return true;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            if (RexUtil.isLiteral((RexNode)call.operands.get(0), false)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isReferenceOrAccess(RexNode node, boolean allowCast) {
        assert (node != null);
        if (node instanceof RexInputRef || node instanceof RexFieldAccess) {
            return true;
        }
        if (allowCast && node.isA(SqlKind.CAST)) {
            RexCall call = (RexCall)node;
            return RexUtil.isReferenceOrAccess((RexNode)call.operands.get(0), false);
        }
        return false;
    }

    public static boolean isNullabilityCast(RelDataTypeFactory typeFactory, RexNode node) {
        switch (node.getKind()) {
            case CAST: {
                RexCall call = (RexCall)node;
                RexNode arg0 = call.getOperands().get(0);
                return SqlTypeUtil.equalSansNullability(typeFactory, arg0.getType(), call.getType());
            }
        }
        return false;
    }

    public static boolean isConstant(RexNode node) {
        return node.accept(ConstantFinder.INSTANCE);
    }

    public static boolean isDeterministic(RexNode e) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (!call.getOperator().isDeterministic()) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            };
            e.accept(visitor);
            return true;
        }
        catch (Util.FoundOne ex) {
            Util.swallow(ex, null);
            return false;
        }
    }

    public static RexCall findOperatorCall(final SqlOperator operator, RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator().equals(operator)) {
                        throw new Util.FoundOne(call);
                    }
                    return (Void)super.visitCall(call);
                }
            };
            node.accept(visitor);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (RexCall)e.getNode();
        }
    }

    public static boolean containsInputRef(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    throw new Util.FoundOne(inputRef);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean containsFieldAccess(RexNode node) {
        try {
            RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                    throw new Util.FoundOne(fieldAccess);
                }
            };
            node.accept(visitor);
            return false;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return true;
        }
    }

    public static boolean requiresDecimalExpansion(RexNode expr, boolean recurse) {
        if (!(expr instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)expr;
        boolean localCheck = true;
        switch (call.getKind()) {
            case REINTERPRET: 
            case IS_NULL: {
                localCheck = false;
                break;
            }
            case CAST: {
                RelDataType lhsType = call.getType();
                RelDataType rhsType = ((RexNode)call.operands.get(0)).getType();
                if (rhsType.getSqlTypeName() == SqlTypeName.NULL) {
                    return false;
                }
                if (SqlTypeUtil.inCharFamily(lhsType) || SqlTypeUtil.inCharFamily(rhsType)) {
                    localCheck = false;
                    break;
                }
                if (!SqlTypeUtil.isDecimal(lhsType) || lhsType == rhsType) break;
                return true;
            }
            default: {
                localCheck = call.getOperator().requiresDecimalExpansion();
            }
        }
        if (localCheck) {
            if (SqlTypeUtil.isDecimal(call.getType())) {
                return true;
            }
            for (int i = 0; i < call.operands.size(); ++i) {
                if (!SqlTypeUtil.isDecimal(((RexNode)call.operands.get(i)).getType())) continue;
                return true;
            }
        }
        return recurse && RexUtil.requiresDecimalExpansion(call.operands, true);
    }

    public static boolean requiresDecimalExpansion(List<RexNode> operands, boolean recurse) {
        for (RexNode operand : operands) {
            RexCall call;
            if (!(operand instanceof RexCall) || !RexUtil.requiresDecimalExpansion(call = (RexCall)operand, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresDecimalExpansion(RexProgram program, boolean recurse) {
        List<RexNode> exprList = program.getExprList();
        for (RexNode expr : exprList) {
            if (!RexUtil.requiresDecimalExpansion(expr, recurse)) continue;
            return true;
        }
        return false;
    }

    public static boolean canReinterpretOverflow(RexCall call) {
        assert (call.isA(SqlKind.REINTERPRET)) : "call is not a reinterpret";
        return call.operands.size() > 1;
    }

    public static boolean containNoCommonExprs(List<RexNode> exprs, Litmus litmus) {
        ExpressionNormalizer visitor = new ExpressionNormalizer(false);
        for (RexNode expr : exprs) {
            try {
                expr.accept(visitor);
            }
            catch (ExpressionNormalizer.SubExprExistsException e) {
                Util.swallow(e, null);
                return litmus.fail(null, new Object[0]);
            }
        }
        return litmus.succeed();
    }

    public static boolean containNoForwardRefs(List<RexNode> exprs, RelDataType inputRowType, Litmus litmus) {
        ForwardRefFinder visitor = new ForwardRefFinder(inputRowType);
        for (int i = 0; i < exprs.size(); ++i) {
            RexNode expr = exprs.get(i);
            visitor.setLimit(i);
            try {
                expr.accept(visitor);
                continue;
            }
            catch (ForwardRefFinder.IllegalForwardRefException e) {
                Util.swallow(e, null);
                return litmus.fail("illegal forward reference in {}", expr);
            }
        }
        return litmus.succeed();
    }

    static boolean containNoNonTrivialAggs(List<RexNode> exprs, Litmus litmus) {
        for (RexNode expr : exprs) {
            RexCall rexCall;
            if (!(expr instanceof RexCall) || !((rexCall = (RexCall)expr).getOperator() instanceof SqlAggFunction)) continue;
            for (RexNode operand : rexCall.operands) {
                if (operand instanceof RexLocalRef || operand instanceof RexLiteral) continue;
                return litmus.fail("contains non trivial agg: {}", operand);
            }
        }
        return litmus.succeed();
    }

    public static boolean containComplexExprs(List<RexNode> exprs) {
        for (RexNode expr : exprs) {
            if (!(expr instanceof RexCall)) continue;
            for (RexNode operand : ((RexCall)expr).operands) {
                if (RexUtil.isAtomic(operand)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAtomic(RexNode expr) {
        return expr instanceof RexLiteral || expr instanceof RexVariable;
    }

    public static boolean isCallTo(RexNode expr, SqlOperator op) {
        return expr instanceof RexCall && ((RexCall)expr).getOperator() == op;
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<RexNode> exprs) {
        return RexUtil.createStructType(typeFactory, exprs, null, null);
    }

    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names, SqlValidatorUtil.Suggester suggester) {
        if (names != null && suggester != null) {
            names = SqlValidatorUtil.uniquify(names, suggester, typeFactory.getTypeSystem().isSchemaCaseSensitive());
        }
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int i = 0; i < exprs.size(); ++i) {
            String name;
            if (names == null || (name = names.get(i)) == null) {
                name = "$f" + i;
            }
            builder.add(name, exprs.get(i).getType());
        }
        return builder.build();
    }

    @Deprecated
    public static RelDataType createStructType(RelDataTypeFactory typeFactory, List<? extends RexNode> exprs, List<String> names) {
        return RexUtil.createStructType(typeFactory, exprs, names, null);
    }

    public static boolean compatibleTypes(List<RexNode> exprs, RelDataType type, Litmus litmus) {
        List<RelDataTypeField> fields = type.getFieldList();
        if (exprs.size() != fields.size()) {
            return litmus.fail("rowtype mismatches expressions", new Object[0]);
        }
        for (int i = 0; i < fields.size(); ++i) {
            RelDataType fieldType;
            RelDataType exprType = exprs.get(i).getType();
            if (RelOptUtil.eq("type1", exprType, "type2", fieldType = fields.get(i).getType(), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static Pair<String, String> makeKey(RexNode expr) {
        return Pair.of(expr.toString(), expr.getType().getFullTypeString());
    }

    public static boolean containIdentity(List<? extends RexNode> exprs, RelDataType rowType, Litmus litmus) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        if (exprs.size() < fields.size()) {
            return litmus.fail("exprs/rowType length mismatch", new Object[0]);
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (!(exprs.get(i) instanceof RexInputRef)) {
                return litmus.fail("expr[{}] is not a RexInputRef", i);
            }
            RexInputRef inputRef = (RexInputRef)exprs.get(i);
            if (inputRef.getIndex() != i) {
                return litmus.fail("expr[{}] has ordinal {}", i, inputRef.getIndex());
            }
            if (RelOptUtil.eq("type1", exprs.get(i).getType(), "type2", fields.get(i).getType(), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType inputRowType) {
        return inputRowType.getFieldCount() == exps.size() && RexUtil.containIdentity(exps, inputRowType, Litmus.IGNORE);
    }

    public static RexNode composeConjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenAnd(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(true);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, list);
    }

    public static ImmutableList<RexNode> flattenAnd(Iterable<? extends RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder<RexNode> builder = ImmutableList.builder();
        HashSet<String> digests = Sets.newHashSet();
        for (RexNode rexNode : nodes) {
            if (rexNode == null) continue;
            RexUtil.addAnd(builder, digests, rexNode);
        }
        return builder.build();
    }

    private static void addAnd(ImmutableList.Builder<RexNode> builder, Set<String> digests, RexNode node) {
        switch (node.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addAnd(builder, digests, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysTrue() && digests.add(node.toString())) {
            builder.add((Object)node);
        }
    }

    public static RexNode composeDisjunction(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean nullOnEmpty) {
        ImmutableList<RexNode> list = RexUtil.flattenOr(nodes);
        switch (list.size()) {
            case 0: {
                return nullOnEmpty ? null : rexBuilder.makeLiteral(false);
            }
            case 1: {
                return (RexNode)list.get(0);
            }
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, list);
    }

    public static ImmutableList<RexNode> flattenOr(Iterable<? extends RexNode> nodes) {
        if (nodes instanceof Collection && ((Collection)nodes).isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder<RexNode> builder = ImmutableList.builder();
        HashSet<String> digests = Sets.newHashSet();
        for (RexNode rexNode : nodes) {
            RexUtil.addOr(builder, digests, rexNode);
        }
        return builder.build();
    }

    private static void addOr(ImmutableList.Builder<RexNode> builder, Set<String> digests, RexNode node) {
        switch (node.getKind()) {
            case OR: {
                for (RexNode operand : ((RexCall)node).getOperands()) {
                    RexUtil.addOr(builder, digests, operand);
                }
                return;
            }
        }
        if (!node.isAlwaysFalse() && digests.add(node.toString())) {
            builder.add((Object)node);
        }
    }

    public static List<RelCollation> apply(Mappings.TargetMapping mapping, List<RelCollation> collationList) {
        ArrayList<RelCollation> newCollationList = new ArrayList<RelCollation>();
        for (RelCollation collation : collationList) {
            RelCollation newCollation;
            RelFieldCollation fieldCollation;
            RelFieldCollation newFieldCollation;
            ArrayList<RelFieldCollation> newFieldCollationList = new ArrayList<RelFieldCollation>();
            Iterator<RelFieldCollation> iterator = collation.getFieldCollations().iterator();
            while (iterator.hasNext() && (newFieldCollation = RexUtil.apply(mapping, fieldCollation = iterator.next())) != null) {
                newFieldCollationList.add(newFieldCollation);
            }
            if (newFieldCollationList.isEmpty() || newCollationList.contains(newCollation = RelCollations.of(newFieldCollationList))) continue;
            newCollationList.add(newCollation);
        }
        return newCollationList;
    }

    public static RelCollation apply(Mappings.TargetMapping mapping, RelCollation collation) {
        List<RelFieldCollation> fieldCollations = RexUtil.applyFields(mapping, collation.getFieldCollations());
        return fieldCollations.equals(collation.getFieldCollations()) ? collation : RelCollations.of(fieldCollations);
    }

    public static RelFieldCollation apply(Mappings.TargetMapping mapping, RelFieldCollation fieldCollation) {
        int target = mapping.getTargetOpt(fieldCollation.getFieldIndex());
        if (target < 0) {
            return null;
        }
        return fieldCollation.copy(target);
    }

    public static List<RelFieldCollation> applyFields(Mappings.TargetMapping mapping, List<RelFieldCollation> fieldCollations) {
        ArrayList<RelFieldCollation> newFieldCollations = new ArrayList<RelFieldCollation>();
        for (RelFieldCollation fieldCollation : fieldCollations) {
            newFieldCollations.add(RexUtil.apply(mapping, fieldCollation));
        }
        return newFieldCollations;
    }

    public static RexNode apply(Mappings.TargetMapping mapping, RexNode node) {
        return node.accept(RexPermuteInputsShuttle.of(mapping));
    }

    public static Iterable<RexNode> apply(Mappings.TargetMapping mapping, Iterable<? extends RexNode> nodes) {
        final RexPermuteInputsShuttle shuttle = RexPermuteInputsShuttle.of(mapping);
        return Iterables.transform(nodes, new Function<RexNode, RexNode>(){

            @Override
            public RexNode apply(RexNode input) {
                return input.accept(shuttle);
            }
        });
    }

    public static <T extends RexNode> T[] apply(RexVisitor<T> shuttle, T[] exprs) {
        RexNode[] newExprs = (RexNode[])exprs.clone();
        for (int i = 0; i < newExprs.length; ++i) {
            RexNode expr = newExprs[i];
            if (expr == null) continue;
            newExprs[i] = (RexNode)expr.accept(shuttle);
        }
        return newExprs;
    }

    public static void apply(RexVisitor<Void> visitor, RexNode[] exprs, RexNode expr) {
        for (RexNode e : exprs) {
            e.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static void apply(RexVisitor<Void> visitor, List<? extends RexNode> exprs, RexNode expr) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(visitor);
        }
        if (expr != null) {
            expr.accept(visitor);
        }
    }

    public static RexNode flatten(RexBuilder rexBuilder, RexNode node) {
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator op = call.getOperator();
            List<RexNode> flattenedOperands = RexUtil.flatten(call.getOperands(), op);
            if (!RexUtil.isFlat(call.getOperands(), op)) {
                return rexBuilder.makeCall(call.getType(), op, flattenedOperands);
            }
        }
        return node;
    }

    public static List<RexNode> flatten(List<? extends RexNode> exprs, SqlOperator op) {
        if (RexUtil.isFlat(exprs, op)) {
            return exprs;
        }
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RexUtil.flattenRecurse(list, exprs, op);
        return list;
    }

    private static boolean isFlat(List<? extends RexNode> exprs, final SqlOperator op) {
        return !RexUtil.isAssociative(op) || !RexUtil.exists(exprs, new Predicate1<RexNode>(){

            @Override
            public boolean apply(RexNode expr) {
                return RexUtil.isCallTo(expr, op);
            }
        });
    }

    public static boolean isFlat(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return true;
        }
        RexCall call = (RexCall)expr;
        return RexUtil.isFlat(call.getOperands(), call.getOperator()) && RexUtil.all(call.getOperands(), IS_FLAT_PREDICATE);
    }

    private static void flattenRecurse(List<RexNode> list, List<? extends RexNode> exprs, SqlOperator op) {
        for (RexNode rexNode : exprs) {
            if (rexNode instanceof RexCall && ((RexCall)rexNode).getOperator() == op) {
                RexUtil.flattenRecurse(list, ((RexCall)rexNode).getOperands(), op);
                continue;
            }
            list.add(rexNode);
        }
    }

    public static RexNode toCnf(RexBuilder rexBuilder, RexNode rex) {
        return new CnfHelper(rexBuilder, -1).toCnf(rex);
    }

    public static RexNode toCnf(RexBuilder rexBuilder, int maxCnfNodeCount, RexNode rex) {
        return new CnfHelper(rexBuilder, maxCnfNodeCount).toCnf(rex);
    }

    public static RexNode toDnf(RexBuilder rexBuilder, RexNode rex) {
        return new DnfHelper(rexBuilder).toDnf(rex);
    }

    private static boolean isAssociative(SqlOperator op) {
        return op.getKind() == SqlKind.AND || op.getKind() == SqlKind.OR;
    }

    public static <E> boolean exists(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (!predicate.apply(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(List<? extends E> list, Predicate1<E> predicate) {
        for (E e : list) {
            if (predicate.apply(e)) continue;
            return false;
        }
        return true;
    }

    public static RexNode shift(RexNode node, int offset) {
        return node.accept(new RexShiftShuttle(offset));
    }

    public static Iterable<RexNode> shift(Iterable<RexNode> nodes, int offset) {
        return new RexShiftShuttle(offset).apply(nodes);
    }

    public static RexNode shift(RexNode node, final int start, final int offset) {
        return node.accept(new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef input) {
                int index = input.getIndex();
                if (index < start) {
                    return input;
                }
                return new RexInputRef(index + offset, input.getType());
            }
        });
    }

    public static RexNode pullFactors(RexBuilder rexBuilder, RexNode node) {
        return new CnfHelper(rexBuilder, -1).pull(node);
    }

    @Deprecated
    public static List<RexNode> fixUp(RexBuilder rexBuilder, List<RexNode> nodes, RelDataType rowType) {
        List<RelDataType> typeList = RelOptUtil.getFieldTypeList(rowType);
        return RexUtil.fixUp(rexBuilder, nodes, typeList);
    }

    public static List<RexNode> fixUp(RexBuilder rexBuilder, List<RexNode> nodes, List<RelDataType> fieldTypes) {
        return new FixNullabilityShuttle(rexBuilder, fieldTypes).apply(nodes);
    }

    public static List<RelDataType> types(List<? extends RexNode> nodes) {
        return Lists.transform(nodes, TYPE_FN);
    }

    public static List<RelDataTypeFamily> families(List<RelDataType> types) {
        return Lists.transform(types, FAMILY_FN);
    }

    public static boolean removeAll(List<RexNode> targets, RexNode e) {
        int count = 0;
        Iterator<RexNode> iterator = targets.iterator();
        while (iterator.hasNext()) {
            RexNode next = iterator.next();
            if (!RexUtil.eq(next, e)) continue;
            ++count;
            iterator.remove();
        }
        return count > 0;
    }

    public static boolean eq(RexNode e1, RexNode e2) {
        return e1 == e2 || e1.toString().equals(e2.toString());
    }

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e) {
        return RexUtil.simplify(rexBuilder, e, false);
    }

    public static RexNode simplify(RexBuilder rexBuilder, RexNode e, boolean unknownAsFalse) {
        switch (e.getKind()) {
            case AND: {
                return RexUtil.simplifyAnd(rexBuilder, (RexCall)e, unknownAsFalse);
            }
            case OR: {
                return RexUtil.simplifyOr(rexBuilder, (RexCall)e);
            }
            case NOT: {
                return RexUtil.simplifyNot(rexBuilder, (RexCall)e);
            }
            case CASE: {
                return RexUtil.simplifyCase(rexBuilder, (RexCall)e, unknownAsFalse);
            }
            case IS_NULL: {
                return ((RexCall)e).getOperands().get(0).getType().isNullable() ? e : rexBuilder.makeLiteral(false);
            }
            case IS_NOT_NULL: {
                return ((RexCall)e).getOperands().get(0).getType().isNullable() ? e : rexBuilder.makeLiteral(true);
            }
            case IS_TRUE: 
            case IS_NOT_TRUE: 
            case IS_FALSE: 
            case IS_NOT_FALSE: {
                assert (e instanceof RexCall);
                return RexUtil.simplifyIs(rexBuilder, (RexCall)e);
            }
        }
        return e;
    }

    public static RexNode simplifyAnds(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes) {
        return RexUtil.simplifyAnds(rexBuilder, nodes, false);
    }

    public static RexNode simplifyAnds(RexBuilder rexBuilder, Iterable<? extends RexNode> nodes, boolean unknownAsFalse) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        for (RexNode rexNode : nodes) {
            RelOptUtil.decomposeConjunction(rexNode, terms, notTerms);
        }
        RexUtil.simplifyList(rexBuilder, terms);
        RexUtil.simplifyList(rexBuilder, notTerms);
        if (unknownAsFalse) {
            return RexUtil.simplifyAnd2ForUnknownAsFalse(rexBuilder, terms, notTerms);
        }
        return RexUtil.simplifyAnd2(rexBuilder, terms, notTerms);
    }

    private static void simplifyList(RexBuilder rexBuilder, List<RexNode> terms) {
        for (int i = 0; i < terms.size(); ++i) {
            terms.set(i, RexUtil.simplify(rexBuilder, terms.get(i)));
        }
    }

    private static RexNode simplifyNot(RexBuilder rexBuilder, RexCall call) {
        RexNode a = call.getOperands().get(0);
        switch (a.getKind()) {
            case NOT: {
                return RexUtil.simplify(rexBuilder, ((RexCall)a).getOperands().get(0));
            }
        }
        SqlKind negateKind = a.getKind().negate();
        if (a.getKind() != negateKind) {
            return RexUtil.simplify(rexBuilder, rexBuilder.makeCall(RexUtil.op(negateKind), ImmutableList.of(((RexCall)a).getOperands().get(0))));
        }
        SqlKind negateKind2 = a.getKind().negateNullSafe();
        if (a.getKind() != negateKind2) {
            return RexUtil.simplify(rexBuilder, rexBuilder.makeCall(RexUtil.op(negateKind2), ((RexCall)a).getOperands()));
        }
        if (a.getKind() == SqlKind.AND) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands));
        }
        if (a.getKind() == SqlKind.OR) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : ((RexCall)a).getOperands()) {
                newOperands.add(RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, operand)));
            }
            return RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands));
        }
        return call;
    }

    public static RexNode not(RexNode e) {
        switch (e.getKind()) {
            case NOT: {
                return ((RexCall)e).getOperands().get(0);
            }
        }
        return new RexCall(e.getType(), SqlStdOperatorTable.NOT, ImmutableList.of(e));
    }

    private static RexNode simplifyIs(RexBuilder rexBuilder, RexCall call) {
        SqlKind kind = call.getKind();
        RexNode a = call.getOperands().get(0);
        if (!a.getType().isNullable()) {
            switch (kind) {
                case IS_NULL: 
                case IS_NOT_NULL: {
                    return rexBuilder.makeLiteral(kind == SqlKind.IS_NOT_NULL);
                }
                case IS_TRUE: 
                case IS_NOT_FALSE: {
                    return RexUtil.simplify(rexBuilder, a);
                }
                case IS_NOT_TRUE: 
                case IS_FALSE: {
                    return RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, a));
                }
            }
        }
        switch (a.getKind()) {
            case NOT: {
                return RexUtil.simplify(rexBuilder, rexBuilder.makeCall(RexUtil.op(kind.negate()), ((RexCall)a).getOperands().get(0)));
            }
        }
        RexNode a2 = RexUtil.simplify(rexBuilder, a);
        if (a != a2) {
            return rexBuilder.makeCall(RexUtil.op(kind), ImmutableList.of(a2));
        }
        return call;
    }

    private static SqlOperator op(SqlKind kind) {
        switch (kind) {
            case IS_FALSE: {
                return SqlStdOperatorTable.IS_FALSE;
            }
            case IS_TRUE: {
                return SqlStdOperatorTable.IS_TRUE;
            }
            case IS_UNKNOWN: {
                return SqlStdOperatorTable.IS_UNKNOWN;
            }
            case IS_NULL: {
                return SqlStdOperatorTable.IS_NULL;
            }
            case IS_NOT_FALSE: {
                return SqlStdOperatorTable.IS_NOT_FALSE;
            }
            case IS_NOT_TRUE: {
                return SqlStdOperatorTable.IS_NOT_TRUE;
            }
            case IS_NOT_NULL: {
                return SqlStdOperatorTable.IS_NOT_NULL;
            }
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
        }
        throw new AssertionError((Object)kind);
    }

    /*
     * WARNING - void declaration
     */
    private static RexNode simplifyCase(RexBuilder rexBuilder, RexCall call, boolean unknownAsFalse) {
        ArrayList<RexNode> newOperands;
        List<RexNode> operands;
        block22: {
            operands = call.getOperands();
            newOperands = new ArrayList<RexNode>();
            HashSet<String> values = new HashSet<String>();
            for (int i = 0; i < operands.size(); ++i) {
                RexNode operand = operands.get(i);
                if (RexUtil.isCasePredicate(call, i)) {
                    if (operand.isAlwaysTrue()) {
                        newOperands.add(operands.get(++i));
                        if (unknownAsFalse && RexUtil.isNull(operands.get(i))) {
                            values.add(rexBuilder.makeLiteral(false).toString());
                            break;
                        }
                        values.add(operands.get(i).toString());
                        break;
                    }
                    if (operand.isAlwaysFalse() || RexUtil.isNull(operand)) {
                        ++i;
                        continue;
                    }
                } else if (unknownAsFalse && RexUtil.isNull(operand)) {
                    values.add(rexBuilder.makeLiteral(false).toString());
                } else {
                    values.add(operand.toString());
                }
                newOperands.add(operand);
            }
            assert (newOperands.size() % 2 == 1);
            if (newOperands.size() == 1 || values.size() == 1) {
                if (!call.getType().equals(((RexNode)newOperands.get(newOperands.size() - 1)).getType())) {
                    return rexBuilder.makeCast(call.getType(), (RexNode)newOperands.get(newOperands.size() - 1));
                }
                return (RexNode)newOperands.get(newOperands.size() - 1);
            }
            if (call.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                Object disjunction;
                ArrayList<RexNode> terms;
                List<Pair<RexNode, RexNode>> pairs = RexUtil.casePairs(rexBuilder, newOperands);
                if (unknownAsFalse) {
                    void var8_11;
                    Pair<RexNode, RexNode> pair;
                    void var8_10;
                    terms = new ArrayList();
                    boolean bl = false;
                    while (var8_10 < pairs.size() && (pair = pairs.get((int)var8_10)).getValue().isAlwaysTrue()) {
                        terms.add(pair.getKey());
                        ++var8_10;
                    }
                    while (var8_11 < pairs.size() && ((pair = pairs.get((int)var8_11)).getValue().isAlwaysFalse() || RexUtil.isNull(pair.getValue()))) {
                        ++var8_11;
                    }
                    if (var8_11 == pairs.size()) {
                        disjunction = RexUtil.composeDisjunction(rexBuilder, terms, false);
                        if (!call.getType().equals(((RexNode)disjunction).getType())) {
                            return rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                        }
                        return disjunction;
                    }
                }
                for (Ord ord : Ord.zip(pairs)) {
                    if (!((RexNode)((Pair)ord.e).getKey()).getType().isNullable() && (((RexNode)((Pair)ord.e).getValue()).isAlwaysTrue() || ((RexNode)((Pair)ord.e).getValue()).isAlwaysFalse() || unknownAsFalse && RexUtil.isNull((RexNode)((Pair)ord.e).getValue()))) continue;
                    break block22;
                }
                terms = new ArrayList<RexNode>();
                ArrayList arrayList = new ArrayList();
                for (Ord ord : Ord.zip(pairs)) {
                    if (((RexNode)((Pair)ord.e).getValue()).isAlwaysTrue()) {
                        terms.add(RexUtil.andNot(rexBuilder, (RexNode)((Pair)ord.e).getKey(), arrayList));
                        continue;
                    }
                    arrayList.add(((Pair)ord.e).getKey());
                }
                disjunction = RexUtil.composeDisjunction(rexBuilder, terms, false);
                if (!call.getType().equals(((RexNode)disjunction).getType())) {
                    return rexBuilder.makeCast(call.getType(), (RexNode)disjunction);
                }
                return disjunction;
            }
        }
        if (newOperands.equals(operands)) {
            return call;
        }
        return call.clone(call.getType(), newOperands);
    }

    private static List<Pair<RexNode, RexNode>> casePairs(RexBuilder rexBuilder, List<RexNode> operands) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < operands.size() - 1; i += 2) {
            builder.add(Pair.of(operands.get(i), operands.get(i + 1)));
        }
        builder.add(Pair.of(rexBuilder.makeLiteral(true), Util.last(operands)));
        return builder.build();
    }

    public static RexNode simplifyAnd(RexBuilder rexBuilder, RexCall e, boolean unknownAsFalse) {
        ArrayList<RexNode> terms = new ArrayList<RexNode>();
        ArrayList<RexNode> notTerms = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, terms, notTerms);
        RexUtil.simplifyList(rexBuilder, terms);
        RexUtil.simplifyList(rexBuilder, notTerms);
        if (unknownAsFalse) {
            return RexUtil.simplifyAnd2ForUnknownAsFalse(rexBuilder, terms, notTerms);
        }
        return RexUtil.simplifyAnd2(rexBuilder, terms, notTerms);
    }

    public static RexNode simplifyAnd2(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse()) continue;
            return rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return RexUtil.simplify(rexBuilder, terms.get(0));
        }
        for (RexNode notDisjunction : notTerms) {
            List<RexNode> terms2 = RelOptUtil.conjunctions(notDisjunction);
            if (!terms.containsAll(terms2)) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction)));
        }
        return RexUtil.composeConjunction(rexBuilder, terms, false);
    }

    public static RexNode simplifyAnd2ForUnknownAsFalse(RexBuilder rexBuilder, List<RexNode> terms, List<RexNode> notTerms) {
        for (RexNode term : terms) {
            if (!term.isAlwaysFalse()) continue;
            return rexBuilder.makeLiteral(false);
        }
        if (terms.isEmpty() && notTerms.isEmpty()) {
            return rexBuilder.makeLiteral(true);
        }
        if (terms.size() == 1 && notTerms.isEmpty()) {
            return RexUtil.simplify(rexBuilder, terms.get(0), true);
        }
        ArrayListMultimap<String, Pair<String, RexNode>> equalityTerms = ArrayListMultimap.create();
        HashMap<String, String> equalityConstantTerms = new HashMap<String, String>();
        HashSet<String> negatedTerms = new HashSet<String>();
        HashSet<String> nullOperands = new HashSet<String>();
        LinkedHashSet<RexNode> notNullOperands = new LinkedHashSet<RexNode>();
        HashSet<String> comparedOperands = new HashSet<String>();
        block8: for (int i = 0; i < terms.size(); ++i) {
            RexCall call;
            RexNode term = terms.get(i);
            if (!RexUtil.isDeterministic(term)) continue;
            while (term.getKind() == SqlKind.EQUALS) {
                call = (RexCall)term;
                if (call.getOperands().get(0).isAlwaysTrue()) {
                    term = call.getOperands().get(1);
                    terms.set(i, term);
                    continue;
                }
                if (!call.getOperands().get(1).isAlwaysTrue()) break;
                term = call.getOperands().get(0);
                terms.set(i, term);
            }
            switch (term.getKind()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    RexNode negatedTerm;
                    call = (RexCall)term;
                    RexNode left = call.getOperands().get(0);
                    comparedOperands.add(left.toString());
                    if (left.getKind() == SqlKind.CAST) {
                        RexCall leftCast = (RexCall)left;
                        comparedOperands.add(leftCast.getOperands().get(0).toString());
                    }
                    RexNode right = call.getOperands().get(1);
                    comparedOperands.add(right.toString());
                    if (right.getKind() == SqlKind.CAST) {
                        RexCall rightCast = (RexCall)right;
                        comparedOperands.add(rightCast.getOperands().get(0).toString());
                    }
                    if (term.getKind() == SqlKind.EQUALS) {
                        String prevLiteral;
                        String literal;
                        boolean leftRef = RexUtil.isReferenceOrAccess(left, true);
                        boolean rightRef = RexUtil.isReferenceOrAccess(right, true);
                        if (right instanceof RexLiteral && leftRef) {
                            literal = right.toString();
                            prevLiteral = equalityConstantTerms.put(left.toString(), literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return rexBuilder.makeLiteral(false);
                            }
                        } else if (left instanceof RexLiteral && rightRef) {
                            literal = left.toString();
                            prevLiteral = equalityConstantTerms.put(right.toString(), literal);
                            if (prevLiteral != null && !literal.equals(prevLiteral)) {
                                return rexBuilder.makeLiteral(false);
                            }
                        } else if (leftRef && rightRef) {
                            equalityTerms.put(left.toString(), Pair.of(right.toString(), term));
                        }
                    }
                    if ((negatedTerm = RexUtil.negate(rexBuilder, call)) == null) continue block8;
                    negatedTerms.add(negatedTerm.toString());
                    RexNode invertNegatedTerm = RexUtil.invert(rexBuilder, (RexCall)negatedTerm);
                    if (invertNegatedTerm == null) continue block8;
                    negatedTerms.add(invertNegatedTerm.toString());
                    continue block8;
                }
                case IN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(0)).toString());
                    continue block8;
                }
                case BETWEEN: {
                    comparedOperands.add(((RexNode)((RexCall)term).operands.get(1)).toString());
                    continue block8;
                }
                case IS_NOT_NULL: {
                    notNullOperands.add(((RexCall)term).getOperands().get(0));
                    terms.remove(i);
                    --i;
                    continue block8;
                }
                case IS_NULL: {
                    nullOperands.add(((RexCall)term).getOperands().get(0).toString());
                }
            }
        }
        if (!Collections.disjoint(nullOperands, comparedOperands)) {
            return rexBuilder.makeLiteral(false);
        }
        for (String ref1 : equalityTerms.keySet()) {
            String literal1 = (String)equalityConstantTerms.get(ref1);
            if (literal1 == null) continue;
            Collection references = equalityTerms.get(ref1);
            for (Pair ref2 : references) {
                String literal2 = (String)equalityConstantTerms.get(ref2.left);
                if (literal2 == null) continue;
                if (!literal1.equals(literal2)) {
                    return rexBuilder.makeLiteral(false);
                }
                terms.remove(ref2.right);
            }
        }
        for (RexNode operand : notNullOperands) {
            if (comparedOperands.contains(operand.toString())) continue;
            terms.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand));
        }
        HashSet<String> termsSet = new HashSet<String>(RexUtil.strings(terms));
        for (RexNode notDisjunction : notTerms) {
            List<String> terms2Set;
            if (!RexUtil.isDeterministic(notDisjunction) || !termsSet.containsAll(terms2Set = RexUtil.strings(RelOptUtil.conjunctions(notDisjunction)))) continue;
            return rexBuilder.makeLiteral(false);
        }
        for (RexNode notDisjunction : notTerms) {
            terms.add(RexUtil.simplify(rexBuilder, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, notDisjunction), true));
        }
        for (String negatedTerm : negatedTerms) {
            if (!termsSet.contains(negatedTerm)) continue;
            return rexBuilder.makeLiteral(false);
        }
        return RexUtil.composeConjunction(rexBuilder, terms, false);
    }

    public static RexNode negate(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                SqlOperator op = RexUtil.op(call.getKind().negateNullSafe());
                return rexBuilder.makeCall(op, call.getOperands());
            }
        }
        return null;
    }

    public static RexNode invert(RexBuilder rexBuilder, RexCall call) {
        switch (call.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                SqlOperator op = RexUtil.op(call.getKind().reverse());
                return rexBuilder.makeCall(op, Lists.reverse(call.getOperands()));
            }
        }
        return null;
    }

    public static RexNode simplifyOr(RexBuilder rexBuilder, RexCall call) {
        assert (call.getKind() == SqlKind.OR);
        List<RexNode> terms = RelOptUtil.disjunctions(call);
        return RexUtil.simplifyOrs(rexBuilder, terms);
    }

    public static RexNode simplifyOrs(RexBuilder rexBuilder, List<RexNode> terms) {
        block3: for (int i = 0; i < terms.size(); ++i) {
            RexNode term = RexUtil.simplify(rexBuilder, terms.get(i));
            switch (term.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.isNullLiteral(term)) {
                        if (RexLiteral.booleanValue(term)) {
                            return term;
                        }
                        terms.remove(i);
                        --i;
                        continue block3;
                    }
                }
                default: {
                    terms.set(i, term);
                }
            }
        }
        return RexUtil.composeDisjunction(rexBuilder, terms, false);
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, RexNode ... notTerms) {
        return RexUtil.andNot(rexBuilder, e, Arrays.asList(notTerms));
    }

    public static RexNode andNot(RexBuilder rexBuilder, RexNode e, Iterable<? extends RexNode> notTerms) {
        switch (e.getKind()) {
            case EQUALS: {
                final RexCall call = (RexCall)e;
                if (!(call.getOperands().get(1) instanceof RexLiteral)) break;
                notTerms = Iterables.filter(notTerms, new Predicate<RexNode>(){

                    @Override
                    public boolean apply(RexNode input) {
                        switch (input.getKind()) {
                            case EQUALS: {
                                RexCall call2 = (RexCall)input;
                                if (!call2.getOperands().get(0).equals(call.getOperands().get(0)) || !(call2.getOperands().get(1) instanceof RexLiteral)) break;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
        }
        return RexUtil.composeConjunction(rexBuilder, Iterables.concat(ImmutableList.of(e), Iterables.transform(notTerms, RexUtil.notFn(rexBuilder))), false);
    }

    public static boolean isCasePredicate(RexCall call, int i) {
        assert (call.getKind() == SqlKind.CASE);
        return i < call.operands.size() - 1 && (call.operands.size() - i) % 2 == 1;
    }

    public static Function<RexNode, RexNode> notFn(final RexBuilder rexBuilder) {
        return new Function<RexNode, RexNode>(){

            @Override
            public RexNode apply(RexNode input) {
                return input.isAlwaysTrue() ? rexBuilder.makeLiteral(false) : (input.isAlwaysFalse() ? rexBuilder.makeLiteral(true) : (input.getKind() == SqlKind.NOT ? (RexNode)((RexCall)input).operands.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, input)));
            }
        };
    }

    public static boolean containsCorrelation(RexNode condition) {
        try {
            condition.accept(CorrelationFinder.INSTANCE);
            return false;
        }
        catch (Util.FoundOne e) {
            return true;
        }
    }

    public static List<String> strings(List<RexNode> list) {
        return Lists.transform(list, TO_STRING);
    }

    public static class ExprSimplifier
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final boolean unknownAsFalse;
        private final Map<RexNode, Boolean> unknownAsFalseMap;

        public ExprSimplifier(RexBuilder rexBuilder, boolean unknownAsFalse) {
            this.rexBuilder = rexBuilder;
            this.unknownAsFalse = unknownAsFalse;
            this.unknownAsFalseMap = new HashMap<RexNode, Boolean>();
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode simplifiedNode;
            RexNode node;
            Boolean unknownAsFalseCall = this.unknownAsFalse;
            if (unknownAsFalseCall.booleanValue()) {
                switch (call.getKind()) {
                    case AND: 
                    case CASE: {
                        unknownAsFalseCall = this.unknownAsFalseMap.get(call);
                        if (unknownAsFalseCall != null) break;
                        unknownAsFalseCall = true;
                        break;
                    }
                    default: {
                        unknownAsFalseCall = false;
                    }
                }
                for (RexNode operand : call.operands) {
                    this.unknownAsFalseMap.put(operand, unknownAsFalseCall);
                }
            }
            if ((node = super.visitCall(call)) == (simplifiedNode = RexUtil.simplify(this.rexBuilder, node, unknownAsFalseCall))) {
                return node;
            }
            if (simplifiedNode.getType().equals(call.getType())) {
                return simplifiedNode;
            }
            return this.rexBuilder.makeCast(call.getType(), simplifiedNode, true);
        }
    }

    public static class SubQueryFinder
    extends RexVisitorImpl<Void> {
        public static final SubQueryFinder INSTANCE = new SubQueryFinder();
        public static final Predicate<Project> PROJECT_PREDICATE = new Predicate<Project>(){

            @Override
            public boolean apply(Project project) {
                for (RexNode node : project.getProjects()) {
                    try {
                        node.accept(INSTANCE);
                    }
                    catch (Util.FoundOne e) {
                        return true;
                    }
                }
                return false;
            }
        };
        public static final Predicate<Filter> FILTER_PREDICATE = new Predicate<Filter>(){

            @Override
            public boolean apply(Filter filter) {
                try {
                    filter.getCondition().accept(INSTANCE);
                    return false;
                }
                catch (Util.FoundOne e) {
                    return true;
                }
            }
        };
        public static final Predicate<Join> JOIN_PREDICATE = new Predicate<Join>(){

            @Override
            public boolean apply(Join join) {
                try {
                    join.getCondition().accept(INSTANCE);
                    return false;
                }
                catch (Util.FoundOne e) {
                    return true;
                }
            }
        };

        private SubQueryFinder() {
            super(true);
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            throw new Util.FoundOne(subQuery);
        }

        public static RexSubQuery find(Iterable<RexNode> nodes) {
            for (RexNode node : nodes) {
                try {
                    node.accept(INSTANCE);
                }
                catch (Util.FoundOne e) {
                    return (RexSubQuery)e.getNode();
                }
            }
            return null;
        }

        public static RexSubQuery find(RexNode node) {
            try {
                node.accept(INSTANCE);
                return null;
            }
            catch (Util.FoundOne e) {
                return (RexSubQuery)e.getNode();
            }
        }
    }

    public static class FixNullabilityShuttle
    extends RexShuttle {
        private final List<RelDataType> typeList;
        private final RexBuilder rexBuilder;

        public FixNullabilityShuttle(RexBuilder rexBuilder, List<RelDataType> typeList) {
            this.typeList = typeList;
            this.rexBuilder = rexBuilder;
        }

        @Override
        public RexNode visitInputRef(RexInputRef ref) {
            RelDataType rightType = this.typeList.get(ref.getIndex());
            RelDataType refType = ref.getType();
            if (refType == rightType) {
                return ref;
            }
            RelDataType refType2 = this.rexBuilder.getTypeFactory().createTypeWithNullability(refType, rightType.isNullable());
            if (refType2 == rightType) {
                return new RexInputRef(ref.getIndex(), refType2);
            }
            throw new AssertionError((Object)("mismatched type " + ref + " " + rightType));
        }
    }

    private static class CorrelationFinder
    extends RexVisitorImpl<Void> {
        static final CorrelationFinder INSTANCE = new CorrelationFinder();

        private CorrelationFinder() {
            super(true);
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable var) {
            throw Util.FoundOne.NULL;
        }
    }

    private static class RexShiftShuttle
    extends RexShuttle {
        private final int offset;

        public RexShiftShuttle(int offset) {
            this.offset = offset;
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            return new RexInputRef(input.getIndex() + this.offset, input.getType());
        }
    }

    private static class DnfHelper {
        final RexBuilder rexBuilder;

        private DnfHelper(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode toDnf(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headDnf = this.toDnf(head);
                    List<RexNode> headDnfs = RelOptUtil.disjunctions(headDnf);
                    RexNode tail = this.and(Util.skip(operands));
                    RexNode tailDnf = this.toDnf(tail);
                    List<RexNode> tailDnfs = RelOptUtil.disjunctions(tailDnf);
                    ArrayList<RexNode> list = Lists.newArrayList();
                    for (RexNode h : headDnfs) {
                        for (RexNode t : tailDnfs) {
                            list.add(this.and(ImmutableList.of(h, t)));
                        }
                    }
                    return this.or(list);
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    return this.or(this.toDnfs(operands));
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toDnf(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.and(Lists.transform(RexUtil.flattenOr(operands), ADD_NOT)));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toDnf(this.or(Lists.transform(RexUtil.flattenAnd(operands), ADD_NOT)));
                        }
                    }
                    return rex;
                }
            }
            return rex;
        }

        private List<RexNode> toDnfs(List<RexNode> nodes) {
            ArrayList<RexNode> list = Lists.newArrayList();
            block3: for (RexNode node : nodes) {
                RexNode dnf = this.toDnf(node);
                switch (dnf.getKind()) {
                    case OR: {
                        list.addAll(((RexCall)dnf).getOperands());
                        continue block3;
                    }
                }
                list.add(dnf);
            }
            return list;
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes, false);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes, false);
        }
    }

    private static class CnfHelper {
        final RexBuilder rexBuilder;
        int currentCount;
        final int maxNodeCount;

        private CnfHelper(RexBuilder rexBuilder, int maxNodeCount) {
            this.rexBuilder = rexBuilder;
            this.maxNodeCount = maxNodeCount;
        }

        public RexNode toCnf(RexNode rex) {
            try {
                this.currentCount = 0;
                return this.toCnf2(rex);
            }
            catch (OverflowError e) {
                Util.swallow(e, null);
                return rex;
            }
        }

        private RexNode toCnf2(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    this.incrementAndCheck();
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    ArrayList<RexNode> cnfOperands = Lists.newArrayList();
                    block13: for (RexNode node : operands) {
                        RexNode cnf = this.toCnf2(node);
                        switch (cnf.getKind()) {
                            case AND: {
                                this.incrementAndCheck();
                                cnfOperands.addAll(((RexCall)cnf).getOperands());
                                continue block13;
                            }
                        }
                        this.incrementAndCheck();
                        cnfOperands.add(cnf);
                    }
                    return this.and(cnfOperands);
                }
                case OR: {
                    this.incrementAndCheck();
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    RexNode head = (RexNode)operands.get(0);
                    RexNode headCnf = this.toCnf2(head);
                    List<RexNode> headCnfs = RelOptUtil.conjunctions(headCnf);
                    RexNode tail = this.or(Util.skip(operands));
                    RexNode tailCnf = this.toCnf2(tail);
                    List<RexNode> tailCnfs = RelOptUtil.conjunctions(tailCnf);
                    ArrayList<RexNode> list = Lists.newArrayList();
                    for (RexNode h : headCnfs) {
                        for (RexNode t : tailCnfs) {
                            list.add(this.or(ImmutableList.of(h, t)));
                        }
                    }
                    return this.and(list);
                }
                case NOT: {
                    RexNode arg = ((RexCall)rex).getOperands().get(0);
                    switch (arg.getKind()) {
                        case NOT: {
                            return this.toCnf2(((RexCall)arg).getOperands().get(0));
                        }
                        case OR: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf2(this.and(Lists.transform(RexUtil.flattenOr(operands), ADD_NOT)));
                        }
                        case AND: {
                            List<RexNode> operands = ((RexCall)arg).getOperands();
                            return this.toCnf2(this.or(Lists.transform(RexUtil.flattenAnd(operands), ADD_NOT)));
                        }
                    }
                    this.incrementAndCheck();
                    return rex;
                }
            }
            this.incrementAndCheck();
            return rex;
        }

        private void incrementAndCheck() {
            if (this.maxNodeCount >= 0 && ++this.currentCount > this.maxNodeCount) {
                throw OverflowError.INSTANCE;
            }
        }

        private RexNode pull(RexNode rex) {
            switch (rex.getKind()) {
                case AND: {
                    ImmutableList<RexNode> operands = RexUtil.flattenAnd(((RexCall)rex).getOperands());
                    return this.and(this.pullList(operands));
                }
                case OR: {
                    ImmutableList<RexNode> operands = RexUtil.flattenOr(((RexCall)rex).getOperands());
                    Map<String, RexNode> factors = this.commonFactors(operands);
                    if (factors.isEmpty()) {
                        return this.or(operands);
                    }
                    ArrayList<RexNode> list = Lists.newArrayList();
                    for (RexNode operand : operands) {
                        list.add(this.removeFactor(factors, operand));
                    }
                    return this.and(Iterables.concat(factors.values(), ImmutableList.of(this.or(list))));
                }
            }
            return rex;
        }

        private List<RexNode> pullList(List<RexNode> nodes) {
            ArrayList<RexNode> list = Lists.newArrayList();
            block3: for (RexNode node : nodes) {
                RexNode pulled = this.pull(node);
                switch (pulled.getKind()) {
                    case AND: {
                        list.addAll(((RexCall)pulled).getOperands());
                        continue block3;
                    }
                }
                list.add(pulled);
            }
            return list;
        }

        private Map<String, RexNode> commonFactors(List<RexNode> nodes) {
            HashMap<String, RexNode> map = Maps.newHashMap();
            int i = 0;
            for (RexNode node : nodes) {
                if (i++ == 0) {
                    for (RexNode conjunction : RelOptUtil.conjunctions(node)) {
                        map.put(conjunction.toString(), conjunction);
                    }
                    continue;
                }
                map.keySet().retainAll(RexUtil.strings(RelOptUtil.conjunctions(node)));
            }
            return map;
        }

        private RexNode removeFactor(Map<String, RexNode> factors, RexNode node) {
            ArrayList<RexNode> list = Lists.newArrayList();
            for (RexNode operand : RelOptUtil.conjunctions(node)) {
                if (factors.containsKey(operand.toString())) continue;
                list.add(operand);
            }
            return this.and(list);
        }

        private RexNode and(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeConjunction(this.rexBuilder, nodes, false);
        }

        private RexNode or(Iterable<? extends RexNode> nodes) {
            return RexUtil.composeDisjunction(this.rexBuilder, nodes, false);
        }

        private static class OverflowError
        extends ControlFlowException {
            protected static final OverflowError INSTANCE = new OverflowError();

            private OverflowError() {
            }
        }
    }

    public static class FieldAccessFinder
    extends RexVisitorImpl<Void> {
        private final List<RexFieldAccess> fieldAccessList = new ArrayList<RexFieldAccess>();

        public FieldAccessFinder() {
            super(true);
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            this.fieldAccessList.add(fieldAccess);
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            for (RexNode operand : call.operands) {
                operand.accept(this);
            }
            return null;
        }

        public List<RexFieldAccess> getFieldAccessList() {
            return this.fieldAccessList;
        }
    }

    private static class ForwardRefFinder
    extends RexVisitorImpl<Void> {
        private int limit = -1;
        private final RelDataType inputRowType;

        public ForwardRefFinder(RelDataType inputRowType) {
            super(true);
            this.inputRowType = inputRowType;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            super.visitInputRef(inputRef);
            if (inputRef.getIndex() >= this.inputRowType.getFieldCount()) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        @Override
        public Void visitLocalRef(RexLocalRef inputRef) {
            super.visitLocalRef(inputRef);
            if (inputRef.getIndex() >= this.limit) {
                throw new IllegalForwardRefException();
            }
            return null;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        static class IllegalForwardRefException
        extends ControlFlowException {
            IllegalForwardRefException() {
            }
        }
    }

    private static class ExpressionNormalizer
    extends RexVisitorImpl<RexNode> {
        final Map<String, RexNode> mapDigestToExpr = new HashMap<String, RexNode>();
        final boolean allowDups;

        protected ExpressionNormalizer(boolean allowDups) {
            super(true);
            this.allowDups = allowDups;
        }

        protected RexNode register(RexNode expr) {
            String key = expr.toString();
            RexNode previous = this.mapDigestToExpr.put(key, expr);
            if (!this.allowDups && previous != null) {
                throw new SubExprExistsException(expr);
            }
            return expr;
        }

        protected RexNode lookup(RexNode expr) {
            return this.mapDigestToExpr.get(expr.toString());
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.register(inputRef);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            return this.register(literal);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.register(correlVariable);
        }

        @Override
        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> normalizedOperands = new ArrayList<RexNode>();
            int diffCount = 0;
            for (RexNode operand : call.getOperands()) {
                operand.accept(this);
                RexNode normalizedOperand = this.lookup(operand);
                normalizedOperands.add(normalizedOperand);
                if (normalizedOperand == operand) continue;
                ++diffCount;
            }
            if (diffCount > 0) {
                call = call.clone(call.getType(), normalizedOperands);
            }
            return this.register(call);
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.register(dynamicParam);
        }

        @Override
        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return this.register(rangeRef);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode expr = fieldAccess.getReferenceExpr();
            expr.accept(this);
            RexNode normalizedExpr = this.lookup(expr);
            if (normalizedExpr != expr) {
                fieldAccess = new RexFieldAccess(normalizedExpr, fieldAccess.getField());
            }
            return this.register(fieldAccess);
        }

        private static class SubExprExistsException
        extends ControlFlowException {
            SubExprExistsException(RexNode expr) {
                Util.discard(expr);
            }
        }
    }

    static class ConstantFinder
    implements RexVisitor<Boolean> {
        static final ConstantFinder INSTANCE = new ConstantFinder();

        ConstantFinder() {
        }

        @Override
        public Boolean visitLiteral(RexLiteral literal) {
            return true;
        }

        @Override
        public Boolean visitInputRef(RexInputRef inputRef) {
            return false;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            return false;
        }

        @Override
        public Boolean visitOver(RexOver over) {
            return false;
        }

        @Override
        public Boolean visitSubQuery(RexSubQuery subQuery) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return false;
        }

        @Override
        public Boolean visitDynamicParam(RexDynamicParam dynamicParam) {
            return true;
        }

        @Override
        public Boolean visitCall(RexCall call) {
            return call.getOperator().isDeterministic() && RexVisitorImpl.visitArrayAnd(this, call.getOperands());
        }

        @Override
        public Boolean visitRangeRef(RexRangeRef rangeRef) {
            return false;
        }

        @Override
        public Boolean visitFieldAccess(RexFieldAccess fieldAccess) {
            return fieldAccess.getReferenceExpr().accept(this);
        }
    }
}

