/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.io.druid.client.DruidDataSource;
import org.apache.hive.druid.io.druid.client.DruidServer;
import org.apache.hive.druid.io.druid.client.InventoryView;
import org.apache.hive.druid.io.druid.server.security.Access;
import org.apache.hive.druid.io.druid.server.security.Action;
import org.apache.hive.druid.io.druid.server.security.AuthorizationInfo;
import org.apache.hive.druid.io.druid.server.security.Resource;
import org.apache.hive.druid.io.druid.server.security.ResourceType;

public class InventoryViewUtils {
    public static Set<DruidDataSource> getDataSources(InventoryView serverInventoryView) {
        TreeSet<DruidDataSource> dataSources = Sets.newTreeSet(new Comparator<DruidDataSource>(){

            @Override
            public int compare(DruidDataSource druidDataSource, DruidDataSource druidDataSource1) {
                return druidDataSource.getName().compareTo(druidDataSource1.getName());
            }
        });
        dataSources.addAll(Lists.newArrayList(Iterables.concat(Iterables.transform(serverInventoryView.getInventory(), new Function<DruidServer, Iterable<DruidDataSource>>(){

            @Override
            public Iterable<DruidDataSource> apply(DruidServer input) {
                return input.getDataSources();
            }
        }))));
        return dataSources;
    }

    public static Set<DruidDataSource> getSecuredDataSources(InventoryView inventoryView, final AuthorizationInfo authorizationInfo) {
        if (authorizationInfo == null) {
            throw new ISE("Invalid to call a secured method with null AuthorizationInfo!!", new Object[0]);
        }
        final HashMap resourceAccessMap = new HashMap();
        return ImmutableSet.copyOf(Iterables.filter(InventoryViewUtils.getDataSources(inventoryView), new Predicate<DruidDataSource>(){

            @Override
            public boolean apply(DruidDataSource input) {
                Action action;
                Resource resource = new Resource(input.getName(), ResourceType.DATASOURCE);
                Pair<Resource, Action> key = new Pair<Resource, Action>(resource, action = Action.READ);
                if (resourceAccessMap.containsKey(key)) {
                    return ((Access)resourceAccessMap.get(key)).isAllowed();
                }
                Access access = authorizationInfo.isAuthorized((Resource)key.lhs, (Action)((Object)key.rhs));
                resourceAccessMap.put(key, access);
                return access.isAllowed();
            }
        }));
    }
}

