/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.plumber;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Stopwatch;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.metamx.common.Granularity;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.concurrent.ScheduledExecutors;
import org.apache.hive.druid.com.metamx.emitter.EmittingLogger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.client.cache.Cache;
import org.apache.hive.druid.io.druid.client.cache.CacheConfig;
import org.apache.hive.druid.io.druid.common.guava.ThreadRenamingCallable;
import org.apache.hive.druid.io.druid.common.guava.ThreadRenamingRunnable;
import org.apache.hive.druid.io.druid.common.utils.VMUtils;
import org.apache.hive.druid.io.druid.concurrent.Execs;
import org.apache.hive.druid.io.druid.concurrent.TaskThreadPriority;
import org.apache.hive.druid.io.druid.data.input.Committer;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.hive.druid.io.druid.query.QuerySegmentWalker;
import org.apache.hive.druid.io.druid.query.SegmentDescriptor;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.io.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.io.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.io.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.hive.druid.io.druid.segment.realtime.FireHydrant;
import org.apache.hive.druid.io.druid.segment.realtime.SegmentPublisher;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SinkQuerySegmentWalker;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Plumber;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.RejectionPolicy;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.SegmentHandoffNotifier;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.Sink;
import org.apache.hive.druid.io.druid.segment.realtime.plumber.VersioningPolicy;
import org.apache.hive.druid.io.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class RealtimePlumber
implements Plumber {
    private static final EmittingLogger log = new EmittingLogger(RealtimePlumber.class);
    private static final int WARN_DELAY = 1000;
    private final DataSchema schema;
    private final RealtimeTuningConfig config;
    private final RejectionPolicy rejectionPolicy;
    private final FireDepartmentMetrics metrics;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentPusher dataSegmentPusher;
    private final SegmentPublisher segmentPublisher;
    private final SegmentHandoffNotifier handoffNotifier;
    private final Object handoffCondition = new Object();
    private final Map<Long, Sink> sinks = Maps.newConcurrentMap();
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline = new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER);
    private final QuerySegmentWalker texasRanger;
    private final Cache cache;
    private volatile long nextFlush = 0L;
    private volatile boolean shuttingDown = false;
    private volatile boolean stopped = false;
    private volatile boolean cleanShutdown = true;
    private volatile ExecutorService persistExecutor = null;
    private volatile ExecutorService mergeExecutor = null;
    private volatile ScheduledExecutorService scheduledExecutor = null;
    private volatile IndexMerger indexMerger;
    private volatile IndexIO indexIO;
    private static final String COMMIT_METADATA_KEY = "%commitMetadata%";
    private static final String COMMIT_METADATA_TIMESTAMP_KEY = "%commitMetadataTimestamp%";

    public RealtimePlumber(DataSchema schema, RealtimeTuningConfig config, FireDepartmentMetrics metrics, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ExecutorService queryExecutorService, DataSegmentPusher dataSegmentPusher, SegmentPublisher segmentPublisher, SegmentHandoffNotifier handoffNotifier, IndexMerger indexMerger, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, ObjectMapper objectMapper) {
        this.schema = schema;
        this.config = config;
        this.rejectionPolicy = config.getRejectionPolicyFactory().create(config.getWindowPeriod());
        this.metrics = metrics;
        this.segmentAnnouncer = segmentAnnouncer;
        this.dataSegmentPusher = dataSegmentPusher;
        this.segmentPublisher = segmentPublisher;
        this.handoffNotifier = handoffNotifier;
        this.indexMerger = Preconditions.checkNotNull(indexMerger, "Null IndexMerger");
        this.indexIO = Preconditions.checkNotNull(indexIO, "Null IndexIO");
        this.cache = cache;
        this.texasRanger = new SinkQuerySegmentWalker(schema.getDataSource(), this.sinkTimeline, objectMapper, emitter, conglomerate, queryExecutorService, cache, cacheConfig);
        log.info("Creating plumber using rejectionPolicy[%s]", this.getRejectionPolicy());
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public RealtimeTuningConfig getConfig() {
        return this.config;
    }

    public RejectionPolicy getRejectionPolicy() {
        return this.rejectionPolicy;
    }

    public Map<Long, Sink> getSinks() {
        return this.sinks;
    }

    @Override
    public Object startJob() {
        this.computeBaseDir(this.schema).mkdirs();
        this.initializeExecutors();
        this.handoffNotifier.start();
        Object retVal = this.bootstrapSinksFromDisk();
        this.startPersistThread();
        this.mergeAndPush();
        this.resetNextFlush();
        return retVal;
    }

    @Override
    public int add(InputRow row, Supplier<Committer> committerSupplier) throws IndexSizeExceededException {
        Sink sink = this.getSink(row.getTimestampFromEpoch());
        if (sink == null) {
            return -1;
        }
        int numRows = sink.add(row);
        if (!sink.canAppendRow() || System.currentTimeMillis() > this.nextFlush) {
            this.persist(committerSupplier.get());
        }
        return numRows;
    }

    private Sink getSink(long timestamp) {
        if (!this.rejectionPolicy.accept(timestamp)) {
            return null;
        }
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        VersioningPolicy versioningPolicy = this.config.getVersioningPolicy();
        long truncatedTime = segmentGranularity.truncate(new DateTime(timestamp)).getMillis();
        Sink retVal = this.sinks.get(truncatedTime);
        if (retVal == null) {
            Interval sinkInterval = new Interval((ReadableInstant)new DateTime(truncatedTime), (ReadableInstant)segmentGranularity.increment(new DateTime(truncatedTime)));
            retVal = new Sink(sinkInterval, this.schema, this.config.getShardSpec(), versioningPolicy.getVersion(sinkInterval), this.config.getMaxRowsInMemory(), this.config.isReportParseExceptions());
            this.addSink(retVal);
        }
        return retVal;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        return this.texasRanger.getQueryRunnerForIntervals(query, query.getIntervals());
    }

    @Override
    public void persist(final Committer committer) {
        final ArrayList<Pair<FireHydrant, Interval>> indexesToPersist = Lists.newArrayList();
        for (Sink sink : this.sinks.values()) {
            if (!sink.swappable()) continue;
            indexesToPersist.add(Pair.of(sink.swap(), sink.getInterval()));
        }
        log.info("Submitting persist runnable for dataSource[%s]", this.schema.getDataSource());
        Stopwatch runExecStopwatch = Stopwatch.createStarted();
        final Stopwatch persistStopwatch = Stopwatch.createStarted();
        final ImmutableMap<String, Long> metadataElems = committer.getMetadata() == null ? null : ImmutableMap.of(COMMIT_METADATA_KEY, committer.getMetadata(), COMMIT_METADATA_TIMESTAMP_KEY, System.currentTimeMillis());
        this.persistExecutor.execute(new ThreadRenamingRunnable(String.format("%s-incremental-persist", this.schema.getDataSource())){

            @Override
            public void doRun() {
                long persistThreadCpuTime = VMUtils.safeGetThreadCpuTime();
                try {
                    for (Pair pair : indexesToPersist) {
                        RealtimePlumber.this.metrics.incrementRowOutputCount(RealtimePlumber.this.persistHydrant((FireHydrant)pair.lhs, RealtimePlumber.this.schema, (Interval)pair.rhs, metadataElems));
                    }
                    committer.run();
                }
                catch (Exception e) {
                    RealtimePlumber.this.metrics.incrementFailedPersists();
                    throw e;
                }
                finally {
                    RealtimePlumber.this.metrics.incrementPersistCpuTime(VMUtils.safeGetThreadCpuTime() - persistThreadCpuTime);
                    RealtimePlumber.this.metrics.incrementNumPersists();
                    RealtimePlumber.this.metrics.incrementPersistTimeMillis(persistStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    persistStopwatch.stop();
                }
            }
        });
        long startDelay = runExecStopwatch.elapsed(TimeUnit.MILLISECONDS);
        this.metrics.incrementPersistBackPressureMillis(startDelay);
        if (startDelay > 1000L) {
            log.warn("Ingestion was throttled for [%,d] millis because persists were pending.", startDelay);
        }
        runExecStopwatch.stop();
        this.resetNextFlush();
    }

    private void persistAndMerge(final long truncatedTime, final Sink sink) {
        String threadName = String.format("%s-%s-persist-n-merge", this.schema.getDataSource(), new DateTime(truncatedTime));
        this.mergeExecutor.execute(new ThreadRenamingRunnable(threadName){
            final Interval interval;
            Stopwatch mergeStopwatch;
            {
                super(x0);
                this.interval = sink.getInterval();
                this.mergeStopwatch = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRun() {
                try {
                    Object segment;
                    if (RealtimePlumber.this.sinks.get(truncatedTime) != sink) {
                        log.info("Sink[%s] was abandoned, bailing out of persist-n-merge.", sink);
                        return;
                    }
                    File persistDir = RealtimePlumber.this.computePersistDir(RealtimePlumber.this.schema, this.interval);
                    File mergedTarget = new File(persistDir, "merged");
                    File isPushedMarker = new File(persistDir, "isPushedMarker");
                    if (!isPushedMarker.exists()) {
                        RealtimePlumber.this.removeSegment(sink, mergedTarget);
                        if (mergedTarget.exists()) {
                            log.wtf("Merged target[%s] exists?!", mergedTarget);
                            return;
                        }
                    } else {
                        log.info("Already pushed sink[%s]", sink);
                        return;
                    }
                    Iterator<FireHydrant> iterator = sink.iterator();
                    while (iterator.hasNext()) {
                        FireHydrant hydrant;
                        FireHydrant fireHydrant = hydrant = iterator.next();
                        synchronized (fireHydrant) {
                            if (!hydrant.hasSwapped()) {
                                log.info("Hydrant[%s] hasn't swapped yet, swapping. Sink[%s]", hydrant, sink);
                                int rowCount = RealtimePlumber.this.persistHydrant(hydrant, RealtimePlumber.this.schema, this.interval, null);
                                RealtimePlumber.this.metrics.incrementRowOutputCount(rowCount);
                            }
                        }
                    }
                    long mergeThreadCpuTime = VMUtils.safeGetThreadCpuTime();
                    this.mergeStopwatch = Stopwatch.createStarted();
                    ArrayList<QueryableIndex> indexes = Lists.newArrayList();
                    for (FireHydrant fireHydrant : sink) {
                        segment = fireHydrant.getSegment();
                        QueryableIndex queryableIndex = segment.asQueryableIndex();
                        log.info("Adding hydrant[%s]", fireHydrant);
                        indexes.add(queryableIndex);
                    }
                    File mergedFile = RealtimePlumber.this.indexMerger.mergeQueryableIndex(indexes, RealtimePlumber.this.schema.getGranularitySpec().isRollup(), RealtimePlumber.this.schema.getAggregators(), mergedTarget, RealtimePlumber.this.config.getIndexSpec());
                    RealtimePlumber.this.metrics.incrementMergeCpuTime(VMUtils.safeGetThreadCpuTime() - mergeThreadCpuTime);
                    RealtimePlumber.this.metrics.incrementMergeTimeMillis(this.mergeStopwatch.elapsed(TimeUnit.MILLISECONDS));
                    QueryableIndex index = RealtimePlumber.this.indexIO.loadIndex(mergedFile);
                    log.info("Pushing [%s] to deep storage", sink.getSegment().getIdentifier());
                    segment = RealtimePlumber.this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions(Lists.newArrayList(index.getAvailableDimensions())));
                    log.info("Inserting [%s] to the metadata store", sink.getSegment().getIdentifier());
                    RealtimePlumber.this.segmentPublisher.publishSegment((DataSegment)segment);
                    if (!isPushedMarker.createNewFile()) {
                        log.makeAlert("Failed to create marker file for [%s]", RealtimePlumber.this.schema.getDataSource()).addData("interval", sink.getInterval()).addData("partitionNum", ((DataSegment)segment).getShardSpec().getPartitionNum()).addData("marker", isPushedMarker).emit();
                    }
                }
                catch (Exception e) {
                    RealtimePlumber.this.metrics.incrementFailedHandoffs();
                    log.makeAlert(e, "Failed to persist merged index[%s]", RealtimePlumber.this.schema.getDataSource()).addData("interval", this.interval).emit();
                    if (RealtimePlumber.this.shuttingDown) {
                        RealtimePlumber.this.cleanShutdown = false;
                        RealtimePlumber.this.abandonSegment(truncatedTime, sink);
                    }
                }
                finally {
                    if (this.mergeStopwatch != null) {
                        this.mergeStopwatch.stop();
                    }
                }
            }
        });
        this.handoffNotifier.registerSegmentHandoffCallback(new SegmentDescriptor(sink.getInterval(), sink.getVersion(), this.config.getShardSpec().getPartitionNum()), this.mergeExecutor, new Runnable(){

            @Override
            public void run() {
                RealtimePlumber.this.abandonSegment(sink.getInterval().getStartMillis(), sink);
                RealtimePlumber.this.metrics.incrementHandOffCount();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJob() {
        log.info("Shutting down...", new Object[0]);
        this.shuttingDown = true;
        for (Map.Entry<Long, Sink> entry : this.sinks.entrySet()) {
            this.persistAndMerge(entry.getKey(), entry.getValue());
        }
        long forceEndWaitTime = System.currentTimeMillis() + this.config.getHandoffConditionTimeout();
        while (!this.sinks.isEmpty()) {
            try {
                log.info("Cannot shut down yet! Sinks remaining: %s", Joiner.on(", ").join(Iterables.transform(this.sinks.values(), new Function<Sink, String>(){

                    @Override
                    public String apply(Sink input) {
                        return input.getSegment().getIdentifier();
                    }
                })));
                Object object = this.handoffCondition;
                synchronized (object) {
                    while (!this.sinks.isEmpty()) {
                        if (this.config.getHandoffConditionTimeout() == 0L) {
                            this.handoffCondition.wait();
                            continue;
                        }
                        long curr = System.currentTimeMillis();
                        if (forceEndWaitTime - curr > 0L) {
                            this.handoffCondition.wait(forceEndWaitTime - curr);
                            continue;
                        }
                        throw new ISE("Segment handoff wait timeout. [%s] segments might not have completed handoff.", this.sinks.size());
                    }
                }
            }
            catch (InterruptedException e) {
                throw Throwables.propagate(e);
            }
        }
        this.handoffNotifier.close();
        this.shutdownExecutors();
        this.stopped = true;
        if (!this.cleanShutdown) {
            throw new ISE("Exception occurred during persist and merge.", new Object[0]);
        }
    }

    private void resetNextFlush() {
        this.nextFlush = new DateTime().plus((ReadablePeriod)this.config.getIntermediatePersistPeriod()).getMillis();
    }

    protected void initializeExecutors() {
        int maxPendingPersists = this.config.getMaxPendingPersists();
        if (this.persistExecutor == null) {
            this.persistExecutor = Execs.newBlockingSingleThreaded("plumber_persist_%d", maxPendingPersists, TaskThreadPriority.getThreadPriorityFromTaskPriority(this.config.getPersistThreadPriority()));
        }
        if (this.mergeExecutor == null) {
            this.mergeExecutor = Execs.newBlockingSingleThreaded("plumber_merge_%d", 1, TaskThreadPriority.getThreadPriorityFromTaskPriority(this.config.getMergeThreadPriority()));
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Execs.scheduledSingleThreaded("plumber_scheduled_%d");
        }
    }

    protected void shutdownExecutors() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.persistExecutor.shutdown();
            this.mergeExecutor.shutdown();
        }
    }

    protected Object bootstrapSinksFromDisk() {
        VersioningPolicy versioningPolicy = this.config.getVersioningPolicy();
        File baseDir = this.computeBaseDir(this.schema);
        if (baseDir == null || !baseDir.exists()) {
            return null;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return null;
        }
        Object metadata = null;
        long latestCommitTime = 0L;
        for (File sinkDir : files) {
            Interval sinkInterval = new Interval((Object)sinkDir.getName().replace("_", "/"));
            File[] sinkFiles = sinkDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return Ints.tryParse(fileName) != null;
                }
            });
            Arrays.sort(sinkFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    try {
                        return Ints.compare(Integer.parseInt(o1.getName()), Integer.parseInt(o2.getName()));
                    }
                    catch (NumberFormatException e) {
                        log.error(e, "Couldn't compare as numbers? [%s][%s]", o1, o2);
                        return o1.compareTo(o2);
                    }
                }
            });
            boolean isCorrupted = false;
            ArrayList<FireHydrant> hydrants = Lists.newArrayList();
            for (File segmentDir : sinkFiles) {
                long timestamp;
                Object timestampObj;
                log.info("Loading previously persisted segment at [%s]", segmentDir);
                if (Ints.tryParse(segmentDir.getName()) == null) continue;
                QueryableIndex queryableIndex = null;
                try {
                    queryableIndex = this.indexIO.loadIndex(segmentDir);
                }
                catch (IOException e) {
                    log.error(e, "Problem loading segmentDir from disk.", new Object[0]);
                    isCorrupted = true;
                }
                if (isCorrupted) {
                    try {
                        File corruptSegmentDir = this.computeCorruptedFileDumpDir(segmentDir, this.schema);
                        log.info("Renaming %s to %s", segmentDir.getAbsolutePath(), corruptSegmentDir.getAbsolutePath());
                        FileUtils.copyDirectory((File)segmentDir, (File)corruptSegmentDir);
                        FileUtils.deleteDirectory((File)segmentDir);
                    }
                    catch (Exception e1) {
                        log.error(e1, "Failed to rename %s", segmentDir.getAbsolutePath());
                    }
                    continue;
                }
                Metadata segmentMetadata = queryableIndex.getMetadata();
                if (segmentMetadata != null && (timestampObj = segmentMetadata.get(COMMIT_METADATA_TIMESTAMP_KEY)) != null && (timestamp = ((Long)timestampObj).longValue()) > latestCommitTime) {
                    log.info("Found metaData [%s] with latestCommitTime [%s] greater than previous recorded [%s]", queryableIndex.getMetadata(), timestamp, latestCommitTime);
                    latestCommitTime = timestamp;
                    metadata = queryableIndex.getMetadata().get(COMMIT_METADATA_KEY);
                }
                hydrants.add(new FireHydrant(new QueryableIndexSegment(DataSegment.makeDataSegmentIdentifier(this.schema.getDataSource(), sinkInterval.getStart(), sinkInterval.getEnd(), versioningPolicy.getVersion(sinkInterval), this.config.getShardSpec()), queryableIndex), Integer.parseInt(segmentDir.getName())));
            }
            if (hydrants.isEmpty()) {
                log.warn("Found persisted segment directory with no intermediate segments present at %s, skipping sink creation.", sinkDir.getAbsolutePath());
                continue;
            }
            Sink currSink = new Sink(sinkInterval, this.schema, this.config.getShardSpec(), versioningPolicy.getVersion(sinkInterval), this.config.getMaxRowsInMemory(), this.config.isReportParseExceptions(), hydrants);
            this.addSink(currSink);
        }
        return metadata;
    }

    private void addSink(Sink sink) {
        this.sinks.put(sink.getInterval().getStartMillis(), sink);
        this.sinkTimeline.add(sink.getInterval(), sink.getVersion(), new SingleElementPartitionChunk<Sink>(sink));
        try {
            this.segmentAnnouncer.announceSegment(sink.getSegment());
        }
        catch (IOException e) {
            log.makeAlert(e, "Failed to announce new segment[%s]", this.schema.getDataSource()).addData("interval", sink.getInterval()).emit();
        }
    }

    protected void startPersistThread() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        DateTime truncatedNow = segmentGranularity.truncate(new DateTime());
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", new DateTime().plus((ReadableDuration)new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis)));
        ScheduledExecutors.scheduleAtFixedRate(this.scheduledExecutor, new Duration(System.currentTimeMillis(), segmentGranularity.increment(truncatedNow).getMillis() + windowMillis), new Duration((ReadableInstant)truncatedNow, (ReadableInstant)segmentGranularity.increment(truncatedNow)), (Callable<ScheduledExecutors.Signal>)new ThreadRenamingCallable<ScheduledExecutors.Signal>(String.format("%s-overseer-%d", this.schema.getDataSource(), this.config.getShardSpec().getPartitionNum())){

            @Override
            public ScheduledExecutors.Signal doCall() {
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                RealtimePlumber.this.mergeAndPush();
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    private void mergeAndPush() {
        Granularity segmentGranularity = this.schema.getGranularitySpec().getSegmentGranularity();
        Period windowPeriod = this.config.getWindowPeriod();
        long windowMillis = windowPeriod.toStandardDuration().getMillis();
        log.info("Starting merge and push.", new Object[0]);
        DateTime minTimestampAsDate = segmentGranularity.truncate(new DateTime(Math.max(windowMillis, this.rejectionPolicy.getCurrMaxTime().getMillis()) - windowMillis));
        long minTimestamp = minTimestampAsDate.getMillis();
        log.info("Found [%,d] segments. Attempting to hand off segments that start before [%s].", this.sinks.size(), minTimestampAsDate);
        ArrayList<Map.Entry<Long, Sink>> sinksToPush = Lists.newArrayList();
        for (Map.Entry<Long, Sink> entry : this.sinks.entrySet()) {
            Long intervalStart = entry.getKey();
            if (intervalStart < minTimestamp) {
                log.info("Adding entry [%s] for merge and push.", entry);
                sinksToPush.add(entry);
                continue;
            }
            log.info("Skipping persist and merge for entry [%s] : Start time [%s] >= [%s] min timestamp required in this run. Segment will be picked up in a future run.", entry, new DateTime((Object)intervalStart), minTimestampAsDate);
        }
        log.info("Found [%,d] sinks to persist and merge", sinksToPush.size());
        for (Map.Entry<Long, Sink> entry : sinksToPush) {
            this.persistAndMerge(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonSegment(long truncatedTime, Sink sink) {
        if (this.sinks.containsKey(truncatedTime)) {
            try {
                this.segmentAnnouncer.unannounceSegment(sink.getSegment());
                this.removeSegment(sink, this.computePersistDir(this.schema, sink.getInterval()));
                log.info("Removing sinkKey %d for segment %s", truncatedTime, sink.getSegment().getIdentifier());
                this.sinks.remove(truncatedTime);
                this.sinkTimeline.remove(sink.getInterval(), sink.getVersion(), new SingleElementPartitionChunk<Sink>(sink));
                for (FireHydrant hydrant : sink) {
                    this.cache.close(SinkQuerySegmentWalker.makeHydrantCacheIdentifier(hydrant));
                }
                Object object = this.handoffCondition;
                synchronized (object) {
                    this.handoffCondition.notifyAll();
                }
            }
            catch (Exception e) {
                log.makeAlert(e, "Unable to abandon old segment for dataSource[%s]", this.schema.getDataSource()).addData("interval", sink.getInterval()).emit();
            }
        }
    }

    protected File computeBaseDir(DataSchema schema) {
        return new File(this.config.getBasePersistDirectory(), schema.getDataSource());
    }

    protected File computeCorruptedFileDumpDir(File persistDir, DataSchema schema) {
        return new File(persistDir.getAbsolutePath().replace(schema.getDataSource(), "corrupted" + File.pathSeparator + schema.getDataSource()));
    }

    protected File computePersistDir(DataSchema schema, Interval interval) {
        return new File(this.computeBaseDir(schema), interval.toString().replace("/", "_"));
    }

    protected int persistHydrant(FireHydrant indexToPersist, DataSchema schema, Interval interval, Map<String, Object> metadataElems) {
        FireHydrant fireHydrant = indexToPersist;
        synchronized (fireHydrant) {
            if (indexToPersist.hasSwapped()) {
                log.info("DataSource[%s], Interval[%s], Hydrant[%s] already swapped. Ignoring request to persist.", schema.getDataSource(), interval, indexToPersist);
                return 0;
            }
            log.info("DataSource[%s], Interval[%s], Metadata [%s] persisting Hydrant[%s]", schema.getDataSource(), interval, metadataElems, indexToPersist);
            try {
                int numRows = indexToPersist.getIndex().size();
                IndexSpec indexSpec = this.config.getIndexSpec();
                indexToPersist.getIndex().getMetadata().putAll(metadataElems);
                File persistedFile = this.indexMerger.persist(indexToPersist.getIndex(), interval, new File(this.computePersistDir(schema, interval), String.valueOf(indexToPersist.getCount())), indexSpec);
                indexToPersist.swapSegment(new QueryableIndexSegment(indexToPersist.getSegment().getIdentifier(), this.indexIO.loadIndex(persistedFile)));
                return numRows;
            }
            catch (IOException e) {
                log.makeAlert("dataSource[%s] -- incremental persist failed", schema.getDataSource()).addData("interval", interval).addData("count", indexToPersist.getCount()).emit();
                throw Throwables.propagate(e);
            }
        }
    }

    private void removeSegment(Sink sink, File target) {
        if (target.exists()) {
            try {
                log.info("Deleting Index File[%s]", target);
                FileUtils.deleteDirectory((File)target);
            }
            catch (Exception e) {
                log.makeAlert(e, "Unable to remove file for dataSource[%s]", this.schema.getDataSource()).addData("file", target).addData("interval", sink.getInterval()).emit();
            }
        }
    }
}

