/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.RangeSet;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;

public class DimFilterUtils {
    static final byte NOOP_CACHE_ID = -4;
    static final byte SELECTOR_CACHE_ID = 0;
    static final byte AND_CACHE_ID = 1;
    static final byte OR_CACHE_ID = 2;
    static final byte NOT_CACHE_ID = 3;
    static final byte EXTRACTION_CACHE_ID = 4;
    static final byte REGEX_CACHE_ID = 5;
    static final byte SEARCH_QUERY_TYPE_ID = 6;
    static final byte JAVASCRIPT_CACHE_ID = 7;
    static final byte SPATIAL_CACHE_ID = 8;
    static final byte IN_CACHE_ID = 9;
    static final byte BOUND_CACHE_ID = 10;
    static final byte INTERVAL_CACHE_ID = 11;
    public static final byte STRING_SEPARATOR = -1;

    static byte[] computeCacheKey(byte cacheIdKey, List<DimFilter> filters) {
        if (filters.size() == 1) {
            return filters.get(0).getCacheKey();
        }
        byte[][] cacheKeys = new byte[filters.size()][];
        int totalSize = 0;
        int index = 0;
        for (DimFilter field : filters) {
            cacheKeys[index] = field.getCacheKey();
            totalSize += cacheKeys[index].length;
            ++index;
        }
        ByteBuffer retVal = ByteBuffer.allocate(1 + totalSize);
        retVal.put(cacheIdKey);
        for (byte[] cacheKey : cacheKeys) {
            retVal.put(cacheKey);
        }
        return retVal.array();
    }

    public static <T> Set<T> filterShards(DimFilter dimFilter, Iterable<T> input, Function<T, ShardSpec> converter) {
        return DimFilterUtils.filterShards(dimFilter, input, converter, new HashMap<String, Optional<RangeSet<String>>>());
    }

    public static <T> Set<T> filterShards(DimFilter dimFilter, Iterable<T> input, Function<T, ShardSpec> converter, Map<String, Optional<RangeSet<String>>> dimensionRangeCache) {
        LinkedHashSet<T> retSet = Sets.newLinkedHashSet();
        for (T obj : input) {
            ShardSpec shard = converter.apply(obj);
            boolean include = true;
            if (dimFilter != null && shard != null) {
                Map<String, Range<String>> domain = shard.getDomain();
                for (Map.Entry<String, Range<String>> entry : domain.entrySet()) {
                    Optional<RangeSet<String>> optFilterRangeSet = dimensionRangeCache.get(entry.getKey());
                    if (optFilterRangeSet == null) {
                        RangeSet<String> filterRangeSet = dimFilter.getDimensionRangeSet(entry.getKey());
                        optFilterRangeSet = Optional.fromNullable(filterRangeSet);
                        dimensionRangeCache.put(entry.getKey(), optFilterRangeSet);
                    }
                    if (!optFilterRangeSet.isPresent() || !optFilterRangeSet.get().subRangeSet(entry.getValue()).isEmpty()) continue;
                    include = false;
                }
            }
            if (!include) continue;
            retSet.add(obj);
        }
        return retSet;
    }
}

