/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.query.aggregation.PostAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;

public class HyperUniqueFinalizingPostAggregator
implements PostAggregator {
    private static final Comparator<Double> DOUBLE_COMPARATOR = Ordering.from(new Comparator<Double>(){

        @Override
        public int compare(Double lhs, Double rhs) {
            return Double.compare(lhs, rhs);
        }
    }).nullsFirst();
    private final String name;
    private final String fieldName;

    @JsonCreator
    public HyperUniqueFinalizingPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.fieldName = Preconditions.checkNotNull(fieldName, "fieldName is null");
        this.name = name == null ? fieldName : name;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet(this.fieldName);
    }

    @Override
    public Comparator<Double> getComparator() {
        return DOUBLE_COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        return HyperUniquesAggregatorFactory.estimateCardinality(combinedAggregators.get(this.fieldName));
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="fieldName")
    public String getFieldName() {
        return this.fieldName;
    }
}

