/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.metadata.storage.postgresql;

import com.google.inject.Inject;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.io.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.io.druid.metadata.SQLMetadataConnector;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.util.StringMapper;

public class PostgreSQLConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(PostgreSQLConnector.class);
    private static final String PAYLOAD_TYPE = "BYTEA";
    private static final String SERIAL_TYPE = "BIGSERIAL";
    public static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private final DBI dbi;
    private volatile Boolean canUpsert;

    @Inject
    public PostgreSQLConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables) {
        super(config, dbTables);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(this.getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        this.dbi = new DBI(datasource);
        log.info("Configured PostgreSQL as metadata storage", new Object[0]);
    }

    @Override
    protected String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    @Override
    protected String getSerialType() {
        return SERIAL_TYPE;
    }

    @Override
    protected int getStreamingFetchSize() {
        return 100;
    }

    protected boolean canUpsert(Handle handle) throws SQLException {
        if (this.canUpsert == null) {
            DatabaseMetaData metaData = handle.getConnection().getMetaData();
            this.canUpsert = metaData.getDatabaseMajorVersion() > 9 || metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() >= 5;
        }
        return this.canUpsert;
    }

    @Override
    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)handle.createQuery("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = 'public' AND tablename ILIKE :tableName").bind("tableName", tableName)).map(StringMapper.FIRST).list().isEmpty();
    }

    @Override
    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) throws Exception {
        return this.getDBI().withHandle(new HandleCallback<Void>(){

            @Override
            public Void withHandle(Handle handle) throws Exception {
                if (PostgreSQLConnector.this.canUpsert(handle)) {
                    ((Update)((Update)handle.createStatement(String.format("INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON CONFLICT (%2$s) DO UPDATE SET %3$s = EXCLUDED.%3$s", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(String.format("BEGIN;\nLOCK TABLE %1$s IN SHARE ROW EXCLUSIVE MODE;\nWITH upsert AS (UPDATE %1$s SET %3$s=:value WHERE %2$s=:key RETURNING *)\n    INSERT INTO %1$s (%2$s, %3$s) SELECT :key, :value WHERE NOT EXISTS (SELECT * FROM upsert)\n;COMMIT;", tableName, keyColumn, valueColumn)).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    @Override
    public DBI getDBI() {
        return this.dbi;
    }

    @Override
    protected boolean connectorIsTransientException(Throwable e) {
        if (e instanceof SQLException) {
            String sqlState = ((SQLException)e).getSQLState();
            return sqlState != null && (sqlState.startsWith("08") || sqlState.startsWith("53"));
        }
        return false;
    }
}

