/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.curator.discovery;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.com.metamx.common.lifecycle.LifecycleStop;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.io.druid.client.selector.DiscoverySelector;
import org.apache.hive.druid.io.druid.client.selector.Server;

public class ServerDiscoverySelector
implements DiscoverySelector<Server> {
    private static final Logger log = new Logger(ServerDiscoverySelector.class);
    private final ServiceProvider serviceProvider;
    private static final Function<ServiceInstance, Server> TO_SERVER = new Function<ServiceInstance, Server>(){

        @Override
        public Server apply(final ServiceInstance instance) {
            return new Server(){

                @Override
                public String getHost() {
                    return HostAndPort.fromParts(this.getAddress(), this.getPort()).toString();
                }

                @Override
                public String getAddress() {
                    return instance.getAddress();
                }

                @Override
                public int getPort() {
                    return instance.getPort();
                }

                @Override
                public String getScheme() {
                    return "http";
                }
            };
        }
    };

    public ServerDiscoverySelector(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    @Override
    public Server pick() {
        ServiceInstance instance;
        try {
            instance = this.serviceProvider.getInstance();
        }
        catch (Exception e) {
            log.info(e, "Exception getting instance", new Object[0]);
            return null;
        }
        if (instance == null) {
            log.error("No server instance found", new Object[0]);
            return null;
        }
        return TO_SERVER.apply(instance);
    }

    public Collection<Server> getAll() {
        try {
            return Collections2.transform(this.serviceProvider.getAllInstances(), TO_SERVER);
        }
        catch (Exception e) {
            log.info(e, "Unable to get all instances", new Object[0]);
            return Collections.emptyList();
        }
    }

    @LifecycleStart
    public void start() throws Exception {
        this.serviceProvider.start();
    }

    @LifecycleStop
    public void stop() throws IOException {
        this.serviceProvider.close();
    }
}

