/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.RE;
import org.apache.hive.druid.com.metamx.common.guava.BaseSequence;
import org.apache.hive.druid.com.metamx.common.guava.CloseQuietly;
import org.apache.hive.druid.com.metamx.common.guava.Sequence;
import org.apache.hive.druid.com.metamx.common.guava.Sequences;
import org.apache.hive.druid.com.metamx.common.logger.Logger;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEmitter;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceMetricEvent;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.com.metamx.http.client.Request;
import org.apache.hive.druid.com.metamx.http.client.response.ClientResponse;
import org.apache.hive.druid.com.metamx.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.StatusResponseHandler;
import org.apache.hive.druid.com.metamx.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.io.druid.query.BaseQuery;
import org.apache.hive.druid.io.druid.query.BySegmentResultValueClass;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryInterruptedException;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.io.druid.query.QueryWatcher;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulatorFns;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBufferInputStream;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;

public class DirectDruidClient<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(DirectDruidClient.class);
    private static final Map<Class<? extends Query>, Pair<JavaType, JavaType>> typesMap = Maps.newConcurrentMap();
    private final QueryToolChestWarehouse warehouse;
    private final QueryWatcher queryWatcher;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;
    private final String host;
    private final ServiceEmitter emitter;
    private final AtomicInteger openConnections;
    private final boolean isSmile;

    public DirectDruidClient(QueryToolChestWarehouse warehouse, QueryWatcher queryWatcher, ObjectMapper objectMapper, HttpClient httpClient, String host, ServiceEmitter emitter) {
        this.warehouse = warehouse;
        this.queryWatcher = queryWatcher;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.host = host;
        this.emitter = emitter;
        this.isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        this.openConnections = new AtomicInteger();
    }

    public int getNumOpenConnections() {
        return this.openConnections.get();
    }

    @Override
    public Sequence<T> run(final Query<T> query, final Map<String, Object> context) {
        ListenableFuture<InputStream> future;
        QueryToolChest toolChest = this.warehouse.getToolChest(query);
        boolean isBySegment = BaseQuery.getContextBySegment(query, false);
        Pair<JavaType, JavaType> types = typesMap.get(query.getClass());
        if (types == null) {
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            JavaType baseType = typeFactory.constructType(toolChest.getResultTypeReference());
            JavaType bySegmentType = typeFactory.constructParametricType(Result.class, typeFactory.constructParametricType(BySegmentResultValueClass.class, baseType));
            types = Pair.of(baseType, bySegmentType);
            typesMap.put(query.getClass(), types);
        }
        final JavaType typeRef = isBySegment ? (JavaType)types.rhs : (JavaType)types.lhs;
        final String url = String.format("http://%s/druid/v2/", this.host);
        final String cancelUrl = String.format("http://%s/druid/v2/%s", this.host, query.getId());
        try {
            log.debug("Querying queryId[%s] url[%s]", query.getId(), url);
            final long requestStartTime = System.currentTimeMillis();
            final ServiceMetricEvent.Builder builder = toolChest.makeMetricBuilder(query);
            builder.setDimension("server", this.host);
            HttpResponseHandler<InputStream, InputStream> responseHandler = new HttpResponseHandler<InputStream, InputStream>(){
                private long responseStartTime;
                private final AtomicLong byteCount = new AtomicLong(0L);
                private final BlockingQueue<InputStream> queue = new LinkedBlockingQueue<InputStream>();
                private final AtomicBoolean done = new AtomicBoolean(false);

                @Override
                public ClientResponse<InputStream> handleResponse(HttpResponse response) {
                    log.debug("Initial response from url[%s] for queryId[%s]", url, query.getId());
                    this.responseStartTime = System.currentTimeMillis();
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/ttfb", this.responseStartTime - requestStartTime));
                    try {
                        String responseContext = response.headers().get("X-Druid-Response-Context");
                        if (responseContext != null) {
                            context.putAll((Map)DirectDruidClient.this.objectMapper.readValue(responseContext, (TypeReference)new TypeReference<Map<String, Object>>(){}));
                        }
                        this.queue.put(new ChannelBufferInputStream(response.getContent()));
                    }
                    catch (IOException e) {
                        log.error(e, "Error parsing response context from url [%s]", url);
                        return ClientResponse.finished(new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw e;
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        log.error(e, "Queue appending interrupted", new Object[0]);
                        Thread.currentThread().interrupt();
                        throw Throwables.propagate(e);
                    }
                    this.byteCount.addAndGet(response.getContent().readableBytes());
                    return ClientResponse.finished(new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean hasMoreElements() {
                            AtomicBoolean atomicBoolean = done;
                            synchronized (atomicBoolean) {
                                return !done.get() || !queue.isEmpty();
                            }
                        }

                        @Override
                        public InputStream nextElement() {
                            try {
                                return (InputStream)queue.take();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw Throwables.propagate(e);
                            }
                        }
                    }));
                }

                @Override
                public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk) {
                    ChannelBuffer channelBuffer = chunk.getContent();
                    int bytes = channelBuffer.readableBytes();
                    if (bytes > 0) {
                        try {
                            this.queue.put(new ChannelBufferInputStream(channelBuffer));
                        }
                        catch (InterruptedException e) {
                            log.error(e, "Unable to put finalizing input stream into Sequence queue for url [%s]", url);
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(e);
                        }
                        this.byteCount.addAndGet(bytes);
                    }
                    return clientResponse;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
                    long stopTime = System.currentTimeMillis();
                    log.debug("Completed queryId[%s] request to url[%s] with %,d bytes returned in %,d millis [%,f b/s].", query.getId(), url, this.byteCount.get(), stopTime - this.responseStartTime, (double)this.byteCount.get() / (1.0E-4 * (double)(stopTime - this.responseStartTime)));
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/time", stopTime - requestStartTime));
                    DirectDruidClient.this.emitter.emit(builder.build("query/node/bytes", this.byteCount.get()));
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        try {
                            this.queue.put(ByteSource.empty().openStream());
                        }
                        catch (InterruptedException e) {
                            log.error(e, "Unable to put finalizing input stream into Sequence queue for url [%s]", url);
                            Thread.currentThread().interrupt();
                            throw Throwables.propagate(e);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate(e);
                        }
                        finally {
                            this.done.set(true);
                        }
                    }
                    return ClientResponse.finished(clientResponse.getObj());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void exceptionCaught(ClientResponse<InputStream> clientResponse, final Throwable e) {
                    AtomicBoolean atomicBoolean = this.done;
                    synchronized (atomicBoolean) {
                        this.done.set(true);
                        this.queue.offer(new InputStream(){

                            @Override
                            public int read() throws IOException {
                                throw new IOException(e);
                            }
                        });
                    }
                }
            };
            future = this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent(this.objectMapper.writeValueAsBytes(query)).setHeader("Content-Type", this.isSmile ? "application/x-jackson-smile" : "application/json"), responseHandler);
            this.queryWatcher.registerQuery(query, future);
            this.openConnections.getAndIncrement();
            Futures.addCallback(future, new FutureCallback<InputStream>(){

                @Override
                public void onSuccess(InputStream result) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                }

                @Override
                public void onFailure(Throwable t) {
                    DirectDruidClient.this.openConnections.getAndDecrement();
                    if (future.isCancelled()) {
                        try {
                            StatusResponseHolder res = (StatusResponseHolder)DirectDruidClient.this.httpClient.go(new Request(HttpMethod.DELETE, new URL(cancelUrl)).setContent(DirectDruidClient.this.objectMapper.writeValueAsBytes(query)).setHeader("Content-Type", DirectDruidClient.this.isSmile ? "application/x-jackson-smile" : "application/json"), new StatusResponseHandler(Charsets.UTF_8)).get();
                            if (res.getStatus().getCode() >= 500) {
                                throw new RE("Error cancelling query[%s]: queriable node returned status[%d] [%s].", res.getStatus().getCode(), res.getStatus().getReasonPhrase());
                            }
                        }
                        catch (IOException | InterruptedException | ExecutionException e) {
                            Throwables.propagate(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        Sequence retVal = new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){

            @Override
            public JsonParserIterator<T> make() {
                return new JsonParserIterator(typeRef, future, url);
            }

            @Override
            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseQuietly.close(iterFromMake);
            }
        });
        if (!isBySegment) {
            retVal = Sequences.map(retVal, toolChest.makePreComputeManipulatorFn(query, MetricManipulatorFns.deserializing()));
        }
        return retVal;
    }

    private class JsonParserIterator<T>
    implements Iterator<T>,
    Closeable {
        private JsonParser jp;
        private ObjectCodec objectCodec;
        private final JavaType typeRef;
        private final Future<InputStream> future;
        private final String url;

        public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url) {
            this.typeRef = typeRef;
            this.future = future;
            this.url = url;
            this.jp = null;
        }

        @Override
        public boolean hasNext() {
            this.init();
            if (this.jp.isClosed()) {
                return false;
            }
            if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
                CloseQuietly.close(this.jp);
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            this.init();
            try {
                Object retVal = this.objectCodec.readValue(this.jp, this.typeRef);
                this.jp.nextToken();
                return retVal;
            }
            catch (IOException e) {
                throw Throwables.propagate(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            if (this.jp == null) {
                try {
                    this.jp = DirectDruidClient.this.objectMapper.getFactory().createParser(this.future.get());
                    JsonToken nextToken = this.jp.nextToken();
                    if (nextToken == JsonToken.START_OBJECT) {
                        QueryInterruptedException cause = this.jp.getCodec().readValue(this.jp, QueryInterruptedException.class);
                        throw new QueryInterruptedException(cause, DirectDruidClient.this.host);
                    }
                    if (nextToken != JsonToken.START_ARRAY) {
                        throw new IAE("Next token wasn't a START_ARRAY, was[%s] from url [%s]", new Object[]{this.jp.getCurrentToken(), this.url});
                    }
                    this.jp.nextToken();
                    this.objectCodec = this.jp.getCodec();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RE(e, "Failure getting results from[%s] because of [%s]", this.url, e.getMessage());
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e, DirectDruidClient.this.host);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.jp != null) {
                this.jp.close();
            }
        }
    }
}

