/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common.parsers;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.math.BigInteger;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.metamx.common.Pair;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.apache.hive.druid.com.metamx.common.parsers.ParseException;
import org.apache.hive.druid.com.metamx.common.parsers.Parser;

public class JSONPathParser
implements Parser<String, Object> {
    private final Map<String, Pair<FieldType, JsonPath>> fieldPathMap;
    private final List<FieldSpec> fieldSpecs;
    private final boolean useFieldDiscovery;
    private final ObjectMapper mapper;
    private final CharsetEncoder enc = Charsets.UTF_8.newEncoder();
    private final Configuration jsonPathConfig;

    public JSONPathParser(List<FieldSpec> fieldSpecs, boolean useFieldDiscovery, ObjectMapper mapper) {
        this.fieldSpecs = fieldSpecs;
        this.fieldPathMap = this.generateFieldPaths(fieldSpecs);
        this.useFieldDiscovery = useFieldDiscovery;
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.jsonPathConfig = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    }

    @Override
    public List<String> getFieldNames() {
        return null;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
    }

    @Override
    public Map<String, Object> parse(String input) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Map document = (Map)this.mapper.readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry<String, Pair<FieldType, JsonPath>> entry : this.fieldPathMap.entrySet()) {
                String fieldName = entry.getKey();
                Pair<FieldType, JsonPath> pair = entry.getValue();
                JsonPath path = (JsonPath)pair.rhs;
                Object parsedVal = pair.lhs == FieldType.ROOT ? document.get(fieldName) : path.read((Object)document, this.jsonPathConfig);
                if (parsedVal == null) continue;
                parsedVal = this.valueConversionFunction(parsedVal);
                map.put(fieldName, parsedVal);
            }
            if (this.useFieldDiscovery) {
                this.discoverFields(map, document);
            }
            return map;
        }
        catch (Exception e) {
            throw new ParseException(e, "Unable to parse row [%s]", input);
        }
    }

    private Map<String, Pair<FieldType, JsonPath>> generateFieldPaths(List<FieldSpec> fieldSpecs) {
        LinkedHashMap<String, Pair<FieldType, JsonPath>> map = new LinkedHashMap<String, Pair<FieldType, JsonPath>>();
        for (FieldSpec fieldSpec : fieldSpecs) {
            String fieldName = fieldSpec.getName();
            if (map.get(fieldName) != null) {
                throw new IllegalArgumentException("Cannot have duplicate field definition: " + fieldName);
            }
            JsonPath path = JsonPath.compile((String)fieldSpec.getExpr(), (Predicate[])new Predicate[0]);
            Pair<FieldType, JsonPath> pair = new Pair<FieldType, JsonPath>(fieldSpec.getType(), path);
            map.put(fieldName, pair);
        }
        return map;
    }

    private void discoverFields(Map<String, Object> map, Map<String, Object> document) {
        for (String field : document.keySet()) {
            Object val;
            if (map.containsKey(field) || (val = document.get(field)) == null || val instanceof Map || val instanceof List && !this.isFlatList((List)val)) continue;
            val = this.valueConversionFunction(val);
            map.put(field, val);
        }
    }

    private Object valueConversionFunction(Object val) {
        if (val instanceof Integer) {
            return (long)((Integer)val).intValue();
        }
        if (val instanceof BigInteger) {
            return ((BigInteger)val).doubleValue();
        }
        if (val instanceof String) {
            return this.charsetFix((String)val);
        }
        if (val instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object entry : (List)val) {
                newList.add(this.valueConversionFunction(entry));
            }
            return newList;
        }
        if (val instanceof Map) {
            LinkedHashMap newMap = new LinkedHashMap();
            Map valMap = (Map)val;
            for (Map.Entry entry : valMap.entrySet()) {
                newMap.put(entry.getKey(), this.valueConversionFunction(entry.getValue()));
            }
            return newMap;
        }
        return val;
    }

    private String charsetFix(String s) {
        if (s != null && !this.enc.canEncode(s)) {
            return StringUtils.fromUtf8(StringUtils.toUtf8(s));
        }
        return s;
    }

    private boolean isFlatList(List<Object> list) {
        for (Object obj : list) {
            if (!(obj instanceof Map) && !(obj instanceof List)) continue;
            return false;
        }
        return true;
    }

    public static class FieldSpec {
        private final FieldType type;
        private final String name;
        private final String expr;

        public FieldSpec(FieldType type, String name, String expr) {
            this.type = type;
            this.name = name;
            this.expr = expr;
        }

        public FieldType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getExpr() {
            return this.expr;
        }
    }

    public static enum FieldType {
        ROOT,
        PATH;

    }
}

