/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.collections.bitmap;

import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import it.uniroma3.mat.extendedset.intset.IntSet;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.metamx.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.com.metamx.collections.bitmap.WrappedConciseIntIterator;
import org.roaringbitmap.IntIterator;

public class WrappedImmutableConciseBitmap
implements ImmutableBitmap {
    private final ImmutableConciseSet bitmap;

    public WrappedImmutableConciseBitmap(ByteBuffer byteBuffer) {
        this.bitmap = new ImmutableConciseSet(byteBuffer.asReadOnlyBuffer());
    }

    public WrappedImmutableConciseBitmap(ImmutableConciseSet immutableConciseSet) {
        this.bitmap = immutableConciseSet;
    }

    public ImmutableConciseSet getBitmap() {
        return this.bitmap;
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public byte[] toBytes() {
        return this.bitmap.toBytes();
    }

    @Override
    public int compareTo(ImmutableBitmap other) {
        return this.bitmap.compareTo(((WrappedImmutableConciseBitmap)other).getBitmap());
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public IntIterator iterator() {
        final IntSet.IntIterator i = this.bitmap.iterator();
        return new IntIterator(){

            public IntIterator clone() {
                return new WrappedConciseIntIterator(i.clone());
            }

            public boolean hasNext() {
                return i.hasNext();
            }

            public int next() {
                return i.next();
            }
        };
    }

    @Override
    public int size() {
        return this.bitmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.size() == 0;
    }

    @Override
    public ImmutableBitmap union(ImmutableBitmap otherBitmap) {
        WrappedImmutableConciseBitmap other = (WrappedImmutableConciseBitmap)otherBitmap;
        ImmutableConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.union(this.bitmap, unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableConciseBitmap other = (WrappedImmutableConciseBitmap)otherBitmap;
        ImmutableConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection(this.bitmap, unwrappedOtherBitmap));
    }

    @Override
    public ImmutableBitmap difference(ImmutableBitmap otherBitmap) {
        WrappedImmutableConciseBitmap other = (WrappedImmutableConciseBitmap)otherBitmap;
        ImmutableConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection(this.bitmap, ImmutableConciseSet.complement(unwrappedOtherBitmap)));
    }
}

